/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class AdocDocBuilder {
    private static final String API_EXTENSION = "Api.adoc";
    private static final String INDEX_DOC = "index.adoc";

    public static void builderControllersApi(ApiConfig config) {
        config.setAdoc(true);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.adoc", INDEX_DOC);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.btl", "ErrorCodeList.md");
        }
    }

    public static void buildSingleControllerApi(ApiConfig config, String controllerName) {
        config.setAdoc(true);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        builderTemplate.buildSingleControllerApi(config.getOutPath(), controllerName, "ApiDoc.adoc", API_EXTENSION);
    }
}

