/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.DateTimeUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class ApiDocBuilder {
    private static final String API_EXTENSION = "Api.md";
    private static final String DATE_FORMAT = "yyyyMMddHHmm";

    public static void builderControllersApi(ApiConfig config) {
        config.setAdoc(false);
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            String version = config.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)DATE_FORMAT);
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.btl", "AllInOne" + version + ".md");
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.btl", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.btl", "ErrorCodeList.md");
        }
    }

    public static void buildSingleControllerApi(ApiConfig config, String controllerName) {
        config.setAdoc(false);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        builderTemplate.buildSingleControllerApi(config.getOutPath(), controllerName, "ApiDoc.btl", API_EXTENSION);
    }
}

