/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.FileUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.postman.InfoBean;
import com.power.doc.model.postman.ItemBean;
import com.power.doc.model.postman.RequestItem;
import com.power.doc.model.postman.request.RequestBean;
import com.power.doc.model.postman.request.body.BodyBean;
import com.power.doc.model.postman.request.header.HeaderBean;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.List;

public class PostmanJsonBuilder {
    public static void buildPostmanApi(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        RequestItem requestItem = new RequestItem();
        requestItem.setInfo(new InfoBean(config.getProjectName()));
        ArrayList<ItemBean> itemBeans = new ArrayList<ItemBean>();
        apiDocList.forEach(apiDoc -> {
            ItemBean itemBean = PostmanJsonBuilder.buildItemBean(apiDoc);
            itemBeans.add(itemBean);
        });
        requestItem.setItem(itemBeans);
        String filePath = config.getOutPath();
        filePath = filePath + "/postman.json";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String data = gson.toJson((Object)requestItem);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static ItemBean buildItemBean(ApiDoc apiDoc) {
        ItemBean itemBean = new ItemBean();
        itemBean.setName(apiDoc.getDesc());
        ArrayList<ItemBean> itemBeans = new ArrayList<ItemBean>();
        List<ApiMethodDoc> apiMethodDocs = apiDoc.getList();
        apiMethodDocs.forEach(apiMethodDoc -> {
            ItemBean itemBean1 = PostmanJsonBuilder.buildItem(apiMethodDoc);
            itemBeans.add(itemBean1);
        });
        itemBean.setItem(itemBeans);
        return itemBean;
    }

    private static ItemBean buildItem(ApiMethodDoc apiMethodDoc) {
        ItemBean item = new ItemBean();
        RequestBean requestBean = new RequestBean();
        item.setName(apiMethodDoc.getDesc());
        item.setDescription(apiMethodDoc.getDetail());
        requestBean.setDescription(apiMethodDoc.getDesc());
        requestBean.setMethod(apiMethodDoc.getType());
        requestBean.setHeader(PostmanJsonBuilder.buildHeaderBeanList(apiMethodDoc));
        requestBean.setBody(PostmanJsonBuilder.buildBodyBean(apiMethodDoc));
        requestBean.setUrl(apiMethodDoc.getRequestExample().getUrl() == null ? apiMethodDoc.getUrl() : apiMethodDoc.getRequestExample().getUrl());
        item.setRequest(requestBean);
        return item;
    }

    private static BodyBean buildBodyBean(ApiMethodDoc apiMethodDoc) {
        if (apiMethodDoc.getContentType().contains("application/json; charset=utf-8")) {
            BodyBean bodyBean = new BodyBean(false);
            bodyBean.setMode("raw");
            if (apiMethodDoc.getRequestExample() != null) {
                bodyBean.setRaw(apiMethodDoc.getRequestExample().getJsonBody());
            }
            return bodyBean;
        }
        BodyBean bodyBean = new BodyBean(true);
        bodyBean.setMode("formdata");
        bodyBean.setFormdata(apiMethodDoc.getRequestExample().getFormDataList());
        return bodyBean;
    }

    private static List<HeaderBean> buildHeaderBeanList(ApiMethodDoc apiMethodDoc) {
        ArrayList<HeaderBean> headerBeans = new ArrayList<HeaderBean>();
        List<ApiReqHeader> headers = apiMethodDoc.getRequestHeaders();
        headers.forEach(apiReqHeader -> {
            HeaderBean headerBean = new HeaderBean();
            headerBean.setKey(apiReqHeader.getName());
            headerBean.setName(apiReqHeader.getName());
            headerBean.setDisabled(!apiReqHeader.isRequired());
            headerBean.setDescription(apiReqHeader.getDesc());
            headerBeans.add(headerBean);
        });
        return headerBeans;
    }
}

