/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.SourceCodePath;
import com.power.doc.utils.JavaClassUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ProjectDocConfigBuilder {
    private JavaProjectBuilder javaProjectBuilder;
    private Map<String, JavaClass> classFilesMap = new ConcurrentHashMap<String, JavaClass>();
    private Map<String, CustomRespField> customRespFieldMap = new ConcurrentHashMap<String, CustomRespField>();
    private String serverUrl;
    private ApiConfig apiConfig;

    public ProjectDocConfigBuilder(ApiConfig apiConfig, JavaProjectBuilder javaProjectBuilder) {
        if (null == apiConfig) {
            throw new NullPointerException("ApiConfig can't be null.");
        }
        this.apiConfig = apiConfig;
        if (Objects.isNull(javaProjectBuilder)) {
            javaProjectBuilder = new JavaProjectBuilder();
        }
        this.serverUrl = StringUtil.isEmpty((String)apiConfig.getServerUrl()) ? "http://{server}" : apiConfig.getServerUrl();
        this.javaProjectBuilder = javaProjectBuilder;
        this.loadJavaSource(apiConfig.getSourceCodePaths(), this.javaProjectBuilder);
        this.initClassFilesMap();
        this.initCustomResponseFieldsMap(apiConfig);
    }

    private void loadJavaSource(List<SourceCodePath> paths, JavaProjectBuilder builder) {
        if (CollectionUtil.isEmpty(paths)) {
            builder.addSourceTree(new File("src/main/java"));
        } else {
            if (!paths.contains("src/main/java")) {
                builder.addSourceTree(new File("src/main/java"));
            }
            for (SourceCodePath path : paths) {
                String strPath;
                if (null == path || !StringUtil.isNotEmpty((String)(strPath = path.getPath()))) continue;
                strPath = strPath.replace("\\", "/");
                builder.addSourceTree(new File(strPath));
            }
        }
    }

    private void initClassFilesMap() {
        Collection javaClasses = this.javaProjectBuilder.getClasses();
        for (JavaClass cls : javaClasses) {
            this.classFilesMap.put(cls.getFullyQualifiedName(), cls);
        }
    }

    private void initCustomResponseFieldsMap(ApiConfig config) {
        if (CollectionUtil.isNotEmpty(config.getCustomResponseFields())) {
            for (CustomRespField field : config.getCustomResponseFields()) {
                this.customRespFieldMap.put(field.getName(), field);
            }
        }
    }

    public JavaClass getClassByName(String simpleName) {
        JavaClass cls = this.javaProjectBuilder.getClassByName(simpleName);
        List<JavaField> fieldList = JavaClassUtil.getFields(cls, 0);
        if (Objects.isNull(cls.getFields()) || fieldList.isEmpty()) {
            cls = this.classFilesMap.get(simpleName);
        } else {
            List classList = cls.getNestedClasses();
            for (JavaClass javaClass : classList) {
                this.classFilesMap.put(javaClass.getFullyQualifiedName(), javaClass);
            }
        }
        return cls;
    }

    public JavaProjectBuilder getJavaProjectBuilder() {
        return this.javaProjectBuilder;
    }

    public Map<String, JavaClass> getClassFilesMap() {
        return this.classFilesMap;
    }

    public Map<String, CustomRespField> getCustomRespFieldMap() {
        return this.customRespFieldMap;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }
}

