/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.JsonFormatUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.constants.DocValidatorAnnotationEnum;
import com.power.doc.constants.Methods;
import com.power.doc.constants.SpringMvcRequestAnnotationsEnum;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.ApiReturn;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.SourceCodePath;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SourceBuilder {
    private static final String GET_MAPPING = "GetMapping";
    private static final String POST_MAPPING = "PostMapping";
    private static final String PUT_MAPPING = "PutMapping";
    private static final String DELETE_MAPPING = "DeleteMapping";
    private static final String REQUEST_MAPPING = "RequestMapping";
    private static final String REQUEST_BODY = "RequestBody";
    private static final String REQUEST_HERDER = "RequestHeader";
    private static final String REQUEST_PARAM = "RequestParam";
    private static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String MULTIPART_TYPE = "multipart/form-data";
    private static final String VALID = "Valid";
    private static final String DEFAULT_SERVER_URL = "http://{server}";
    private Map<String, JavaClass> javaFilesMap = new ConcurrentHashMap<String, JavaClass>();
    private Map<String, CustomRespField> fieldMap = new ConcurrentHashMap<String, CustomRespField>();
    private JavaProjectBuilder builder;
    private Collection<JavaClass> javaClasses;
    private boolean isStrict;
    private String packageMatch;
    private List<ApiReqHeader> headers;
    private String appUrl;
    private boolean isUseMD5;
    private boolean isAdoc;
    private boolean isShowAuthor;

    public SourceBuilder(boolean isStrict, JavaProjectBuilder projectBuilder) {
        this.loadJavaFiles(null, projectBuilder);
        this.isStrict = isStrict;
    }

    public SourceBuilder(ApiConfig config, JavaProjectBuilder projectBuilder) {
        if (null == config) {
            throw new NullPointerException("ApiConfig can't be null.");
        }
        this.appUrl = StringUtil.isEmpty((String)config.getServerUrl()) ? DEFAULT_SERVER_URL : config.getServerUrl();
        this.isUseMD5 = config.isMd5EncryptedHtmlName();
        this.packageMatch = config.getPackageFilters();
        this.isStrict = config.isStrict();
        this.isAdoc = config.isAdoc();
        this.isShowAuthor = config.isShowAuthor();
        this.loadJavaFiles(config.getSourceCodePaths(), projectBuilder);
        this.headers = config.getRequestHeaders();
        if (CollectionUtil.isNotEmpty(config.getCustomResponseFields())) {
            for (CustomRespField field : config.getCustomResponseFields()) {
                this.fieldMap.put(field.getName(), field);
            }
        }
    }

    public List<ApiDoc> getControllerApiData() {
        ArrayList<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        for (JavaClass cls : this.javaClasses) {
            if (!this.checkController(cls)) continue;
            if (StringUtil.isNotEmpty((String)this.packageMatch)) {
                if (!DocUtil.isMatch(this.packageMatch, cls.getCanonicalName())) continue;
                this.handleApiDoc(cls, apiDocList, ++order);
                continue;
            }
            this.handleApiDoc(cls, apiDocList, ++order);
        }
        return apiDocList;
    }

    public ApiDoc getSingleControllerApiData(String controller) {
        if (!this.javaFilesMap.containsKey(controller)) {
            throw new RuntimeException("Unable to find " + controller + " in your project");
        }
        JavaClass cls = this.builder.getClassByName(controller);
        if (this.checkController(cls)) {
            String controllerName = cls.getName();
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls);
            ApiDoc apiDoc = new ApiDoc();
            apiDoc.setList(apiMethodDocs);
            apiDoc.setName(controllerName);
            return apiDoc;
        }
        throw new RuntimeException(controller + " is not a Controller in your project");
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls) {
        String clazName = cls.getCanonicalName();
        List classAnnotations = cls.getAnnotations();
        String baseUrl = "";
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!REQUEST_MAPPING.equals(annotationName) && !"org.springframework.web.bind.annotation.RequestMapping".equals(annotationName)) continue;
            baseUrl = StringUtil.removeQuotes((String)annotation.getNamedParameter("value").toString());
        }
        List methods = cls.getMethods();
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (JavaMethod method : methods) {
            ArrayList<ApiReqHeader> apiReqHeaders = new ArrayList<ApiReqHeader>();
            if (method.getModifiers().contains("private")) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && this.isStrict) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setDesc(method.getComment());
            apiMethodDoc.setName(method.getName());
            String methodUid = clazName + method.getName();
            this.handleMethodUid(apiMethodDoc, methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            String authorValue = DocUtil.getNormalTagComments(method, "author", cls.getName());
            if (this.isShowAuthor && StringUtil.isNotEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(authorValue);
            }
            apiMethodDoc.setDetail(apiNoteValue);
            List annotations = method.getAnnotations();
            String url = null;
            String methodType = null;
            boolean isPostMethod = false;
            int methodCounter = 0;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getName();
                if (REQUEST_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.RequestMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    Object nameParam = annotation.getNamedParameter("method");
                    if (null != nameParam) {
                        methodType = nameParam.toString();
                        if ("POST".equals(methodType = DocUtil.handleHttpMethod(methodType)) || "PUT".equals(methodType)) {
                            isPostMethod = true;
                        }
                    } else {
                        methodType = Methods.GET.getValue();
                    }
                    ++methodCounter;
                    continue;
                }
                if (GET_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.GetMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    methodType = Methods.GET.getValue();
                    ++methodCounter;
                    continue;
                }
                if (POST_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.PostMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    methodType = Methods.POST.getValue();
                    ++methodCounter;
                    isPostMethod = true;
                    continue;
                }
                if (PUT_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.PutMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    methodType = Methods.PUT.getValue();
                    ++methodCounter;
                    continue;
                }
                if (!DELETE_MAPPING.equals(annotationName) && !"org.springframework.web.bind.annotation.DeleteMapping".equals(annotationName)) continue;
                url = DocUtil.handleMappingValue(annotation);
                methodType = Methods.DELETE.getValue();
                ++methodCounter;
            }
            block3: for (JavaParameter javaParameter : method.getParameters()) {
                List javaAnnotations = javaParameter.getAnnotations();
                String className = method.getDeclaringClass().getCanonicalName();
                Map<String, String> paramMap = DocUtil.getParamsComments(method, "param", className);
                String paramName = javaParameter.getName();
                for (JavaAnnotation annotation : javaAnnotations) {
                    String annotationName = annotation.getType().getName();
                    if (!REQUEST_HERDER.equals(annotationName)) continue;
                    ApiReqHeader apiReqHeader = new ApiReqHeader();
                    Map requestHeaderMap = annotation.getNamedParameterMap();
                    if (requestHeaderMap.get("value") != null) {
                        apiReqHeader.setName(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("value"))));
                    } else {
                        apiReqHeader.setName(paramName);
                    }
                    StringBuilder desc = new StringBuilder();
                    String comments = paramMap.get(paramName);
                    desc.append(comments);
                    if (requestHeaderMap.get("defaultValue") != null) {
                        desc.append("(defaultValue: ").append(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("defaultValue")))).append(")");
                    }
                    apiReqHeader.setDesc(desc.toString());
                    if (requestHeaderMap.get("required") != null) {
                        apiReqHeader.setRequired(!Boolean.FALSE.toString().equals(requestHeaderMap.get("required")));
                    } else {
                        apiReqHeader.setRequired(true);
                    }
                    String typeName = javaParameter.getType().getValue().toLowerCase();
                    apiReqHeader.setType(DocClassUtil.processTypeNameForParams(typeName));
                    apiReqHeaders.add(apiReqHeader);
                    continue block3;
                }
            }
            apiMethodDoc.setRequestHeaders(apiReqHeaders);
            if (methodCounter <= 0 || null != method.getTagByName("ignore")) continue;
            String[] urls = (url = StringUtil.removeQuotes((String)url)).split(",");
            url = urls.length > 1 ? this.getUrls(baseUrl, urls) : UrlUtil.simplifyUrl((String)(this.appUrl + "/" + baseUrl + "/" + url));
            apiMethodDoc.setType(methodType);
            apiMethodDoc.setUrl(url);
            List<ApiParam> requestParams = this.requestParams(method, "param", cls.getCanonicalName());
            apiMethodDoc.setRequestParams(requestParams);
            String requestJson = this.buildReqJson(method, apiMethodDoc, isPostMethod);
            if (StringUtil.isNotEmpty((String)requestJson) && !requestJson.startsWith("http")) {
                requestJson = JsonFormatUtil.formatJson((String)requestJson);
            }
            apiMethodDoc.setRequestUsage(requestJson);
            apiMethodDoc.setResponseUsage(this.buildReturnJson(method, this.fieldMap));
            List<ApiParam> responseParams = this.buildReturnApiParams(method, cls.getGenericFullyQualifiedName());
            apiMethodDoc.setResponseParams(responseParams);
            List<ApiReqHeader> allApiReqHeaders = this.headers != null ? Stream.of(this.headers, apiReqHeaders).flatMap(Collection::stream).distinct().collect(Collectors.toList()) : apiReqHeaders;
            apiMethodDoc.setHeaders(this.createHeaders(allApiReqHeaders, this.isAdoc));
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private String getUrls(String baseUrl, String[] urls) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < urls.length; ++i) {
            String url = this.appUrl + "/" + baseUrl + "/" + StringUtil.trimBlank((String)urls[i]).replace("[", "").replace("]", "");
            sb.append(UrlUtil.simplifyUrl((String)url));
            if (i >= urls.length - 1) continue;
            sb.append(";\t");
        }
        return sb.toString();
    }

    private void loadJavaFiles(List<SourceCodePath> paths, JavaProjectBuilder builder) {
        if (Objects.isNull(builder)) {
            builder = new JavaProjectBuilder();
        }
        if (CollectionUtil.isEmpty(paths)) {
            builder.addSourceTree(new File("src/main/java"));
        } else {
            if (!paths.contains("src/main/java")) {
                builder.addSourceTree(new File("src/main/java"));
            }
            for (SourceCodePath path : paths) {
                String strPath;
                if (null == path || !StringUtil.isNotEmpty((String)(strPath = path.getPath()))) continue;
                strPath = strPath.replace("\\", "/");
                builder.addSourceTree(new File(strPath));
            }
        }
        this.builder = builder;
        this.javaClasses = builder.getClasses();
        for (JavaClass cls : this.javaClasses) {
            this.javaFilesMap.put(cls.getFullyQualifiedName(), cls);
        }
    }

    private String createHeaders(List<ApiReqHeader> headers, boolean isAdoc) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isEmpty(headers)) {
            headers = new ArrayList<ApiReqHeader>(0);
        }
        for (ApiReqHeader header : headers) {
            if (isAdoc) {
                builder.append("|");
            }
            builder.append(header.getName()).append("|").append(header.getType()).append("|").append(header.getDesc()).append("|").append(header.isRequired()).append("|").append(header.getSince()).append("\n");
        }
        return builder.toString();
    }

    private List<ApiParam> buildReturnApiParams(JavaMethod method, String controllerName) {
        if ("void".equals(method.getReturnType().getFullyQualifiedName())) {
            return null;
        }
        ApiReturn apiReturn = DocClassUtil.processReturnType(method.getReturnType().getGenericCanonicalName());
        String returnType = apiReturn.getGenericCanonicalName();
        String typeName = apiReturn.getSimpleName();
        if (JavaClassValidateUtil.isMvcIgnoreParams(typeName)) {
            if ("org.springframework.web.servlet.ModelAndView".equals(typeName)) {
                return null;
            }
            throw new RuntimeException("Smart-doc can't support " + typeName + " as method return in " + controllerName);
        }
        if (JavaClassValidateUtil.isPrimitive(typeName)) {
            return this.primitiveReturnRespComment(DocClassUtil.processTypeNameForParams(typeName));
        }
        if (JavaClassValidateUtil.isCollection(typeName)) {
            if (returnType.contains("<")) {
                String gicName = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    return this.primitiveReturnRespComment("array of " + DocClassUtil.processTypeNameForParams(gicName));
                }
                return this.buildParams(gicName, "", 0, null, this.fieldMap, true, new HashMap<String, String>());
            }
            return null;
        }
        if (JavaClassValidateUtil.isMap(typeName)) {
            String[] keyValue = DocClassUtil.getMapKeyValueType(returnType);
            if (keyValue.length == 0) {
                return null;
            }
            if (JavaClassValidateUtil.isPrimitive(keyValue[1])) {
                return this.primitiveReturnRespComment("key value");
            }
            return this.buildParams(keyValue[1], "", 0, null, this.fieldMap, true, new HashMap<String, String>());
        }
        if (StringUtil.isNotEmpty((String)returnType)) {
            return this.buildParams(returnType, "", 0, null, this.fieldMap, true, new HashMap<String, String>());
        }
        return null;
    }

    private List<ApiParam> buildParams(String className, String pre, int i, String isRequired, Map<String, CustomRespField> responseFieldMap, boolean isResp, Map<String, String> registryClasses) {
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (registryClasses.containsKey(className) && i > registryClasses.size()) {
            return paramList;
        }
        registryClasses.put(className, className);
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = this.getJavaClass(simpleName);
        List<JavaField> fields = this.getFields(cls, 0);
        int n = 0;
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            paramList.addAll(this.primitiveReturnRespComment(DocClassUtil.processTypeNameForParams(simpleName)));
        } else if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            if (!JavaClassValidateUtil.isCollection(globGicName[0])) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                paramList.addAll(this.buildParams(gicName, pre, i + 1, isRequired, responseFieldMap, isResp, registryClasses));
            }
        } else if (JavaClassValidateUtil.isMap(simpleName)) {
            if (globGicName.length == 2) {
                paramList.addAll(this.buildParams(globGicName[1], pre, i + 1, isRequired, responseFieldMap, isResp, registryClasses));
            }
        } else if ("java.lang.Object".equals(className)) {
            ApiParam param = ApiParam.of().setField(pre + "any object").setType("object");
            if (StringUtil.isEmpty((String)isRequired)) {
                param.setDesc("any object.").setVersion("-");
            } else {
                param.setDesc("any object.").setRequired(false).setVersion("-");
            }
            paramList.add(param);
        } else {
            boolean isGenerics = this.checkGenerics(fields);
            block0: for (JavaField field : fields) {
                String gName;
                ApiParam param;
                CustomRespField customResponseField;
                String comment;
                String fieldName = field.getName();
                String subTypeName = field.getType().getFullyQualifiedName();
                if ("this$0".equals(fieldName) || "serialVersionUID".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName)) continue;
                String typeSimpleName = field.getType().getSimpleName();
                String fieldGicName = field.getType().getGenericCanonicalName();
                List javaAnnotations = field.getAnnotations();
                Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field);
                String since = "-";
                if (!isResp) {
                    if (tagsMap.containsKey("ignore")) continue;
                    if (tagsMap.containsKey("since")) {
                        since = tagsMap.get("since");
                    }
                } else if (tagsMap.containsKey("since")) {
                    since = tagsMap.get("since");
                }
                boolean strRequired = false;
                int annotationCounter = 0;
                for (JavaAnnotation annotation : javaAnnotations) {
                    String annotationName = annotation.getType().getSimpleName();
                    if ("JsonIgnore".equals(annotationName) && isResp) continue block0;
                    if ("JSONField".equals(annotationName) && isResp) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!Boolean.FALSE.toString().equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("name").toString());
                        continue;
                    }
                    if ("JsonProperty".equals(annotationName) && isResp) {
                        if (null == annotation.getProperty("value")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("value").toString());
                        continue;
                    }
                    if (!JavaClassValidateUtil.isJSR303Required(annotationName)) continue;
                    strRequired = true;
                    ++annotationCounter;
                    break;
                }
                if (annotationCounter < 1 && tagsMap.containsKey("required")) {
                    strRequired = true;
                }
                if (StringUtil.isNotEmpty((String)(comment = null != (customResponseField = responseFieldMap.get(field.getName())) && StringUtil.isNotEmpty((String)customResponseField.getDesc()) ? customResponseField.getDesc() : field.getComment()))) {
                    comment = DocUtil.replaceNewLineToHtmlBr(comment);
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                    param = ApiParam.of().setField(pre + fieldName);
                    String processedType = DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                    param.setType(processedType);
                    if (StringUtil.isNotEmpty((String)comment)) {
                        this.commonHandleParam(paramList, param, isRequired, comment, since, strRequired);
                        continue;
                    }
                    this.commonHandleParam(paramList, param, isRequired, "No comments found.", since, strRequired);
                    continue;
                }
                param = ApiParam.of().setField(pre + fieldName);
                JavaClass javaClass = this.builder.getClassByName(subTypeName);
                String enumComments = javaClass.getComment();
                if (StringUtil.isNotEmpty((String)enumComments) && javaClass.isEnum()) {
                    enumComments = DocUtil.replaceNewLineToHtmlBr(enumComments);
                    comment = comment + "(See: " + enumComments + ")";
                }
                String processedType = DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                param.setType(processedType);
                if (!isResp && javaClass.isEnum()) {
                    List methods = javaClass.getMethods();
                    int index = 0;
                    String reTypeName = "string";
                    block2: for (JavaMethod method : methods) {
                        JavaType type = method.getReturnType();
                        reTypeName = type.getCanonicalName();
                        List javaAnnotationList = method.getAnnotations();
                        for (JavaAnnotation annotation : javaAnnotationList) {
                            if (!annotation.getType().getSimpleName().contains("JsonValue")) continue;
                            break block2;
                        }
                        if (CollectionUtil.isEmpty((Collection)javaAnnotations) && index < 1) break;
                        ++index;
                    }
                    param.setType(DocClassUtil.processTypeNameForParams(reTypeName));
                }
                if (StringUtil.isNotEmpty((String)comment)) {
                    this.commonHandleParam(paramList, param, isRequired, comment, since, strRequired);
                } else {
                    this.commonHandleParam(paramList, param, isRequired, "No comments found.", since, strRequired);
                }
                StringBuilder preBuilder = new StringBuilder();
                for (int j = 0; j < i; ++j) {
                    preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                preBuilder.append("\u2514\u2500");
                if (JavaClassValidateUtil.isMap(subTypeName)) {
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    if (JavaClassValidateUtil.isMap(gNameTemp)) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    String valType = DocClassUtil.getMapKeyValueType(gNameTemp)[1];
                    if (JavaClassValidateUtil.isPrimitive(valType)) continue;
                    if (valType.length() == 1) {
                        String gicName = n < globGicName.length ? globGicName[n] : globGicName[globGicName.length - 1];
                        if (JavaClassValidateUtil.isPrimitive(gicName) || simpleName.equals(gicName)) continue;
                        paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                        continue;
                    }
                    paramList.addAll(this.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                    continue;
                }
                if (JavaClassValidateUtil.isCollection(subTypeName)) {
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    String[] gNameArr = DocClassUtil.getSimpleGicName(gNameTemp);
                    if (gNameArr.length == 0 || JavaClassValidateUtil.isPrimitive(gName = DocClassUtil.getSimpleGicName(gNameTemp)[0]) || simpleName.equals(gName) || gName.equals(simpleName)) continue;
                    if (gName.length() == 1) {
                        String gicName;
                        int len = globGicName.length;
                        if (len <= 0 || JavaClassValidateUtil.isPrimitive(gicName = n < len ? globGicName[n] : globGicName[len - 1]) || simpleName.equals(gicName)) continue;
                        paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                        continue;
                    }
                    paramList.addAll(this.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                    continue;
                }
                if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) {
                    if (isGenerics && "java.lang.Object".equals(subTypeName)) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    if (simpleName.equals(className)) continue;
                    if (n < globGicName.length) {
                        String gicName = globGicName[n];
                        String simple = DocClassUtil.getSimpleName(gicName);
                        if (!JavaClassValidateUtil.isPrimitive(simple)) {
                            if (gicName.contains("<")) {
                                if (JavaClassValidateUtil.isCollection(simple)) {
                                    gName = DocClassUtil.getSimpleGicName(gicName)[0];
                                    if (!JavaClassValidateUtil.isPrimitive(gName)) {
                                        paramList.addAll(this.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                                    }
                                } else if (JavaClassValidateUtil.isMap(simple)) {
                                    String valType = DocClassUtil.getMapKeyValueType(gicName)[1];
                                    if (!JavaClassValidateUtil.isPrimitive(valType)) {
                                        paramList.addAll(this.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                                    }
                                } else {
                                    paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                                }
                            } else {
                                paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                            }
                        }
                    } else {
                        paramList.addAll(this.buildParams(subTypeName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                    }
                    ++n;
                    continue;
                }
                if (JavaClassValidateUtil.isArray(subTypeName)) {
                    if (className.equals(fieldGicName = fieldGicName.substring(0, fieldGicName.indexOf("["))) || JavaClassValidateUtil.isPrimitive(fieldGicName)) continue;
                    paramList.addAll(this.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
                    continue;
                }
                if (simpleName.equals(subTypeName) || javaClass.isEnum()) continue;
                paramList.addAll(this.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses));
            }
        }
        return paramList;
    }

    private List<ApiParam> primitiveReturnRespComment(String typeName) {
        StringBuilder comments = new StringBuilder();
        comments.append("The api directly returns the ").append(typeName).append(" type value.");
        ApiParam apiParam = ApiParam.of().setField("No field").setType(typeName).setDesc(comments.toString()).setVersion("-");
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        paramList.add(apiParam);
        return paramList;
    }

    private String buildReturnJson(JavaMethod method, Map<String, CustomRespField> responseFieldMap) {
        if ("void".equals(method.getReturnType().getFullyQualifiedName())) {
            return "This api return nothing.";
        }
        ApiReturn apiReturn = DocClassUtil.processReturnType(method.getReturnType().getGenericCanonicalName());
        String returnType = apiReturn.getGenericCanonicalName();
        String typeName = apiReturn.getSimpleName();
        return JsonFormatUtil.formatJson((String)this.buildJson(typeName, returnType, responseFieldMap, true, 0, new HashMap<String, String>()));
    }

    private String buildJson(String typeName, String genericCanonicalName, Map<String, CustomRespField> responseFieldMap, boolean isResp, int counter, Map<String, String> registryClasses) {
        if (registryClasses.containsKey(typeName) && counter > registryClasses.size()) {
            return "{\"$ref\":\"...\"}";
        }
        registryClasses.put(typeName, typeName);
        if (JavaClassValidateUtil.isMvcIgnoreParams(typeName)) {
            if ("org.springframework.web.servlet.ModelAndView".equals(typeName)) {
                return "Forward or redirect to a page view.";
            }
            return "Error restful return.";
        }
        if (JavaClassValidateUtil.isPrimitive(typeName)) {
            return StringUtil.removeQuotes((String)DocUtil.jsonValueByType(typeName));
        }
        StringBuilder data0 = new StringBuilder();
        JavaClass cls = this.getJavaClass(typeName);
        data0.append("{");
        String[] globGicName = DocClassUtil.getSimpleGicName(genericCanonicalName);
        StringBuilder data = new StringBuilder();
        if (JavaClassValidateUtil.isCollection(typeName) || JavaClassValidateUtil.isArray(typeName)) {
            String gName;
            data.append("[");
            if (globGicName.length == 0) {
                data.append("{\"object\":\"any object\"}");
                data.append("]");
                return data.toString();
            }
            String gNameTemp = globGicName[0];
            String string = gName = JavaClassValidateUtil.isArray(typeName) ? gNameTemp.substring(0, gNameTemp.indexOf("[")) : globGicName[0];
            if ("java.lang.Object".equals(gName)) {
                data.append("{\"waring\":\"You may use java.util.Object instead of display generics in the List\"}");
            } else if (JavaClassValidateUtil.isPrimitive(gName)) {
                data.append(DocUtil.jsonValueByType(gName)).append(",");
                data.append(DocUtil.jsonValueByType(gName));
            } else if (gName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gName);
                String json = this.buildJson(simple, gName, responseFieldMap, isResp, counter + 1, registryClasses);
                data.append(json);
            } else if (JavaClassValidateUtil.isCollection(gName)) {
                data.append("\"any object\"");
            } else {
                String json = this.buildJson(gName, gName, responseFieldMap, isResp, counter + 1, registryClasses);
                data.append(json);
            }
            data.append("]");
            return data.toString();
        }
        if (JavaClassValidateUtil.isMap(typeName)) {
            String gNameTemp = genericCanonicalName;
            String[] getKeyValType = DocClassUtil.getMapKeyValueType(gNameTemp);
            if (getKeyValType.length == 0) {
                data.append("{\"mapKey\":{}}");
                return data.toString();
            }
            if (!"java.lang.String".equals(getKeyValType[0])) {
                throw new RuntimeException("Map's key can only use String for json,but you use " + getKeyValType[0]);
            }
            String gicName = gNameTemp.substring(gNameTemp.indexOf(",") + 1, gNameTemp.lastIndexOf(">"));
            if ("java.lang.Object".equals(gicName)) {
                data.append("{").append("\"mapKey\":").append("{\"waring\":\"You may use java.util.Object for Map value; smart-doc can't be handle.\"}").append("}");
            } else if (JavaClassValidateUtil.isPrimitive(gicName)) {
                data.append("{").append("\"mapKey1\":").append(DocUtil.jsonValueByType(gicName)).append(",");
                data.append("\"mapKey2\":").append(DocUtil.jsonValueByType(gicName)).append("}");
            } else if (gicName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gicName);
                String json = this.buildJson(simple, gicName, responseFieldMap, isResp, counter + 1, registryClasses);
                data.append("{").append("\"mapKey\":").append(json).append("}");
            } else {
                data.append("{").append("\"mapKey\":").append(this.buildJson(gicName, gNameTemp, responseFieldMap, isResp, counter + 1, registryClasses)).append("}");
            }
            return data.toString();
        }
        if ("java.lang.Object".equals(typeName)) {
            if ("java.lang.Object".equals(typeName)) {
                data.append("{\"object\":\" any object\"},");
            }
        } else {
            List<JavaField> fields = this.getFields(cls, 0);
            boolean isGenerics = this.checkGenerics(fields);
            int i = 0;
            block0: for (JavaField field : fields) {
                String gicName1;
                String gicName;
                String subTypeName = field.getType().getFullyQualifiedName();
                String fieldName = field.getName();
                if ("this$0".equals(fieldName) || "serialVersionUID".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName)) continue;
                Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field);
                if (!isResp && tagsMap.containsKey("ignore")) continue;
                List annotations = field.getAnnotations();
                for (JavaAnnotation annotation : annotations) {
                    String annotationName = annotation.getType().getSimpleName();
                    if ("JsonIgnore".equals(annotationName) && isResp) continue block0;
                    if ("JSONField".equals(annotationName) && isResp) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!Boolean.FALSE.toString().equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("name").toString());
                        continue;
                    }
                    if (!"JsonProperty".equals(annotationName) || !isResp || null == annotation.getProperty("value")) continue;
                    fieldName = StringUtil.removeQuotes((String)annotation.getProperty("value").toString());
                }
                String typeSimpleName = field.getType().getSimpleName();
                String fieldGicName = field.getType().getGenericCanonicalName();
                data0.append("\"").append(fieldName).append("\":");
                if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                    CustomRespField customResponseField;
                    String fieldValue = "";
                    if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                        fieldValue = tagsMap.get("mock");
                        if ("String".equals(typeSimpleName)) {
                            fieldValue = DocUtil.handleJsonStr(fieldValue);
                        }
                    } else {
                        fieldValue = DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName());
                    }
                    if (null != (customResponseField = responseFieldMap.get(fieldName))) {
                        Object val = customResponseField.getValue();
                        if (null != val) {
                            if ("String".equals(typeSimpleName)) {
                                data0.append(DocUtil.handleJsonStr(String.valueOf(val))).append(",");
                                continue;
                            }
                            data0.append(val).append(",");
                            continue;
                        }
                        data0.append(fieldValue).append(",");
                        continue;
                    }
                    data0.append(fieldValue).append(",");
                    continue;
                }
                if (JavaClassValidateUtil.isCollection(subTypeName) || JavaClassValidateUtil.isArray(subTypeName)) {
                    String string = fieldGicName = JavaClassValidateUtil.isArray(subTypeName) ? fieldGicName.substring(0, fieldGicName.indexOf("[")) : fieldGicName;
                    if (DocClassUtil.getSimpleGicName(fieldGicName).length == 0) {
                        data0.append("{\"object\":\"any object\"},");
                        continue;
                    }
                    gicName = DocClassUtil.getSimpleGicName(fieldGicName)[0];
                    if ("java.lang.String".equals(gicName)) {
                        data0.append("[").append("\"").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp, counter + 1, registryClasses)).append("\"]").append(",");
                        continue;
                    }
                    if ("java.util.List".equals(gicName)) {
                        data0.append("{\"object\":\"any object\"},");
                        continue;
                    }
                    if (gicName.length() == 1) {
                        if (globGicName.length == 0) {
                            data0.append("{\"object\":\"any object\"},");
                            continue;
                        }
                        String string2 = gicName1 = i < globGicName.length ? globGicName[i] : globGicName[globGicName.length - 1];
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("[").append("\"").append(this.buildJson(gicName1, gicName1, responseFieldMap, isResp, counter + 1, registryClasses)).append("\"]").append(",");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("[").append(this.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, responseFieldMap, isResp, counter + 1, registryClasses)).append("]").append(",");
                            continue;
                        }
                        data0.append("[{\"$ref\":\"..\"}]").append(",");
                        continue;
                    }
                    if (!typeName.equals(gicName)) {
                        if (JavaClassValidateUtil.isMap(gicName)) {
                            data0.append("[{\"mapKey\":{}}],");
                            continue;
                        }
                        data0.append("[").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp, counter + 1, registryClasses)).append("]").append(",");
                        continue;
                    }
                    data0.append("[{\"$ref\":\"..\"}]").append(",");
                    continue;
                }
                if (JavaClassValidateUtil.isMap(subTypeName)) {
                    if (JavaClassValidateUtil.isMap(fieldGicName)) {
                        data0.append("{").append("\"mapKey\":{}},");
                        continue;
                    }
                    gicName = fieldGicName.substring(fieldGicName.indexOf(",") + 1, fieldGicName.indexOf(">"));
                    if (gicName.length() == 1) {
                        String string = gicName1 = i < globGicName.length ? globGicName[i] : globGicName[globGicName.length - 1];
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":\"").append(this.buildJson(gicName1, gicName1, responseFieldMap, isResp, counter + 1, registryClasses)).append("\"},");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":").append(this.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, responseFieldMap, isResp, counter + 1, registryClasses)).append("},");
                            continue;
                        }
                        data0.append("{\"mapKey\":{}},");
                        continue;
                    }
                    data0.append("{").append("\"mapKey\":").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp, counter + 1, registryClasses)).append("},");
                    continue;
                }
                if (subTypeName.length() == 1) {
                    if (!typeName.equals(genericCanonicalName)) {
                        gicName = globGicName[i];
                        if (JavaClassValidateUtil.isPrimitive(gicName)) {
                            data0.append(DocUtil.jsonValueByType(gicName)).append(",");
                        } else {
                            String simple = DocClassUtil.getSimpleName(gicName);
                            data0.append(this.buildJson(simple, gicName, responseFieldMap, isResp, counter + 1, registryClasses)).append(",");
                        }
                    } else {
                        data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    }
                    ++i;
                    continue;
                }
                if ("java.lang.Object".equals(subTypeName)) {
                    if (isGenerics) {
                        data0.append("{\"object\":\"any object\"},");
                    } else if (i < globGicName.length) {
                        gicName = globGicName[i];
                        if (!typeName.equals(genericCanonicalName)) {
                            if (JavaClassValidateUtil.isPrimitive(gicName)) {
                                data0.append("\"").append(this.buildJson(gicName, genericCanonicalName, responseFieldMap, isResp, counter + 1, registryClasses)).append("\",");
                            } else {
                                String simpleName = DocClassUtil.getSimpleName(gicName);
                                data0.append(this.buildJson(simpleName, gicName, responseFieldMap, isResp, counter + 1, registryClasses)).append(",");
                            }
                        } else {
                            data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                        }
                    } else {
                        data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    }
                    if (isGenerics) continue;
                    ++i;
                    continue;
                }
                if (typeName.equals(subTypeName)) {
                    data0.append("{\"$ref\":\"...\"}").append(",");
                    continue;
                }
                JavaClass javaClass = this.builder.getClassByName(subTypeName);
                if (!isResp && javaClass.isEnum()) {
                    Object value = this.handleEnumValue(javaClass, Boolean.FALSE);
                    data0.append(value).append(",");
                    continue;
                }
                data0.append(this.buildJson(subTypeName, fieldGicName, responseFieldMap, isResp, counter + 1, registryClasses)).append(",");
            }
        }
        if (data0.toString().contains(",")) {
            data0.deleteCharAt(data0.lastIndexOf(","));
        }
        data0.append("}");
        return data0.toString();
    }

    private String buildReqJson(JavaMethod method, ApiMethodDoc apiMethodDoc, Boolean isPostMethod) {
        String url;
        List parameterList = method.getParameters();
        if (parameterList.size() < 1) {
            return apiMethodDoc.getUrl();
        }
        boolean containsBrace = apiMethodDoc.getUrl().replace(DEFAULT_SERVER_URL, "").contains("{");
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        Map<String, String> paramsComments = DocUtil.getParamsComments(method, "param", null);
        List<String> springMvcRequestAnnotations = SpringMvcRequestAnnotationsEnum.listSpringMvcRequestAnnotations();
        for (JavaParameter parameter : parameterList) {
            JavaType javaType = parameter.getType();
            String simpleTypeName = javaType.getValue();
            String gicTypeName = javaType.getGenericCanonicalName();
            String typeName = javaType.getFullyQualifiedName();
            JavaClass javaClass = this.builder.getClassByName(typeName);
            String paraName = parameter.getName();
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName)) continue;
            String mockValue = "";
            if (JavaClassValidateUtil.isPrimitive(simpleTypeName) && StringUtil.isEmpty((String)(mockValue = Objects.nonNull(mockValue = paramsComments.get(paraName)) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1, mockValue.length()) : ""))) {
                mockValue = DocUtil.getValByTypeAndFieldName(simpleTypeName, paraName, true);
            }
            if (gicTypeName.contains("org.springframework.web.multipart.MultipartFile")) {
                apiMethodDoc.setContentType(MULTIPART_TYPE);
                return JavaClassValidateUtil.isArray(typeName) ? "Use FormData upload files." : "Use FormData upload file.";
            }
            List annotations = parameter.getAnnotations();
            int requestBodyCounter = 0;
            String defaultVal = null;
            boolean notHasRequestParams = true;
            for (JavaAnnotation annotation : annotations) {
                AnnotationValue annotationOfName;
                AnnotationValue annotationValue;
                AnnotationValue annotationDefaultVal;
                String fullName = annotation.getType().getSimpleName();
                if (!springMvcRequestAnnotations.contains(fullName)) continue;
                String annotationName = annotation.getType().getSimpleName();
                if (REQUEST_BODY.equals(annotationName) || "org.springframework.web.bind.annotation.RequestBody".equals(annotationName)) {
                    ++requestBodyCounter;
                    apiMethodDoc.setContentType(JSON_CONTENT_TYPE);
                    if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("{\"").append(paraName).append("\":").append(DocUtil.handleJsonStr(mockValue)).append("}");
                        return builder.toString();
                    }
                    return this.buildJson(typeName, gicTypeName, this.fieldMap, false, 0, new HashMap<String, String>());
                }
                if (REQUEST_PARAM.equals(annotationName)) {
                    notHasRequestParams = false;
                }
                if (null != (annotationDefaultVal = annotation.getProperty("defaultValue"))) {
                    defaultVal = StringUtil.removeQuotes((String)annotationDefaultVal.toString());
                }
                if (null != (annotationValue = annotation.getProperty("value"))) {
                    paraName = StringUtil.removeQuotes((String)annotationValue.toString());
                }
                if (null != (annotationOfName = annotation.getProperty("name"))) {
                    paraName = StringUtil.removeQuotes((String)annotationOfName.toString());
                }
                if (!REQUEST_HERDER.equals(annotationName)) continue;
                paraName = null;
            }
            if (JavaClassValidateUtil.isPrimitive(typeName) && parameterList.size() == 1 && isPostMethod.booleanValue() && notHasRequestParams && !containsBrace) {
                apiMethodDoc.setContentType(JSON_CONTENT_TYPE);
                StringBuilder builder = new StringBuilder();
                builder.append("{\"").append(paraName).append("\":").append(DocUtil.handleJsonStr(mockValue)).append("}");
                return builder.toString();
            }
            if (requestBodyCounter >= true || paraName == null) continue;
            if (javaClass.isEnum()) {
                Object value = this.handleEnumValue(javaClass, Boolean.TRUE);
                paramsMap.put(paraName, StringUtil.removeQuotes((String)String.valueOf(value)));
                continue;
            }
            if (annotations.size() < 1 && !JavaClassValidateUtil.isPrimitive(typeName)) {
                return "Smart-doc can't support create form-data example,It is recommended to use @RequestBody to receive parameters.";
            }
            if (StringUtil.isEmpty(defaultVal) && JavaClassValidateUtil.isPrimitive(typeName)) {
                paramsMap.put(paraName, mockValue);
                continue;
            }
            if (StringUtil.isEmpty(defaultVal) && JavaClassValidateUtil.isPrimitiveArray(typeName)) {
                paramsMap.put(paraName, mockValue);
                continue;
            }
            paramsMap.put(paraName, defaultVal);
        }
        if (containsBrace && !apiMethodDoc.getUrl().equals(DEFAULT_SERVER_URL)) {
            String[] urls = apiMethodDoc.getUrl().split(";");
            StringBuilder urlBuilder = new StringBuilder();
            int uriCounter = 0;
            String body = "";
            for (String uri : urls) {
                HashMap<String, String> paramsMapTemp = new HashMap<String, String>();
                paramsMapTemp.putAll(paramsMap);
                if (isPostMethod.booleanValue()) {
                    url = DocUtil.formatAndRemove(uri, paramsMapTemp);
                    body = UrlUtil.urlJoin((String)"", paramsMapTemp).replace("?", "");
                    url = url.replaceAll("\t", "");
                    url = uriCounter == 0 ? "curl -X POST -i " + url + " --data '" + body + "'\n" : "curl -X POST -i " + url + " --data '" + body + "'";
                    urlBuilder.append(url);
                } else {
                    url = DocUtil.formatAndRemove(uri, paramsMapTemp);
                    url = UrlUtil.urlJoin((String)url, paramsMapTemp);
                    if (uriCounter == 0 && urls.length > 1) {
                        urlBuilder.append(url).append(";\t");
                    } else {
                        urlBuilder.append(url);
                    }
                }
                ++uriCounter;
            }
            url = urlBuilder.toString();
        } else if (isPostMethod.booleanValue()) {
            StringBuilder urlBuilder = new StringBuilder();
            url = UrlUtil.urlJoin((String)"", paramsMap).replace("?", "");
            urlBuilder.append("curl -X POST -i ").append(apiMethodDoc.getUrl()).append(" --data ").append("'").append(url).append("'");
            url = urlBuilder.toString();
        } else {
            url = UrlUtil.urlJoin((String)apiMethodDoc.getUrl(), paramsMap);
        }
        return url;
    }

    private List<ApiParam> requestParams(JavaMethod javaMethod, String tagName, String className) {
        HashMap<String, CustomRespField> responseFieldMap = new HashMap<String, CustomRespField>();
        Map<String, String> paramTagMap = DocUtil.getParamsComments(javaMethod, tagName, className);
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() < 1) {
            return null;
        }
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        int requestBodyCounter = 0;
        ArrayList<ApiParam> reqBodyParamsList = new ArrayList<ApiParam>();
        block0: for (JavaParameter parameter : parameterList) {
            boolean paramAdded = false;
            String paramName = parameter.getName();
            String typeName = parameter.getType().getGenericCanonicalName();
            String simpleName = parameter.getType().getValue().toLowerCase();
            String fullTypeName = parameter.getType().getFullyQualifiedName();
            JavaClass javaClass = this.builder.getClassByName(fullTypeName);
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName)) continue;
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && this.isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            String comment = paramTagMap.get(paramName);
            if (StringUtil.isEmpty((String)comment)) {
                comment = "No comments found.";
            } else if (comment.contains("|")) {
                comment = comment.substring(0, comment.indexOf("|"));
            }
            List annotations = parameter.getAnnotations();
            if (annotations.size() == 0) {
                ApiParam param;
                if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                    ApiParam param2;
                    String[] gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                    String gicName = gicNameArr[0];
                    if (JavaClassValidateUtil.isArray(gicName)) {
                        gicName = gicName.substring(0, gicName.indexOf("["));
                    }
                    String typeTemp = "";
                    if (JavaClassValidateUtil.isPrimitive(gicName)) {
                        typeTemp = " of " + DocClassUtil.processTypeNameForParams(gicName);
                        param2 = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName) + typeTemp).setDesc(comment).setRequired(true).setVersion("-");
                        paramList.add(param2);
                    } else {
                        param2 = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName) + typeTemp).setDesc(comment).setRequired(true).setVersion("-");
                        paramList.add(param2);
                        paramList.addAll(this.buildParams(gicNameArr[0], "\u2514\u2500", 1, "true", responseFieldMap, false, new HashMap<String, String>()));
                    }
                } else if (JavaClassValidateUtil.isPrimitive(simpleName)) {
                    param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(true).setVersion("-");
                    paramList.add(param);
                } else if ("java.util.Map".equals(typeName)) {
                    param = ApiParam.of().setField(paramName).setType("map").setDesc(comment).setRequired(true).setVersion("-");
                    paramList.add(param);
                } else if (javaClass.isEnum()) {
                    param = ApiParam.of().setField(paramName).setType("string").setDesc(comment).setRequired(true).setVersion("-");
                    paramList.add(param);
                } else {
                    paramList.addAll(this.buildParams(fullTypeName, "", 0, "true", responseFieldMap, false, new HashMap<String, String>()));
                }
            }
            for (JavaAnnotation annotation : annotations) {
                String annotationName;
                String required = "true";
                AnnotationValue annotationRequired = annotation.getProperty("required");
                if (null != annotationRequired) {
                    required = annotationRequired.toString();
                }
                if (REQUEST_BODY.equals(annotationName = annotation.getType().getName()) || VALID.equals(annotationName) && annotations.size() == 1) {
                    String[] gicNameArr;
                    if (requestBodyCounter > 0) {
                        throw new RuntimeException("You have use @RequestBody Passing multiple variables  for method " + javaMethod.getName() + " in " + className + ",@RequestBody annotation could only bind one variables.");
                    }
                    if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                        ApiParam bodyParam = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required));
                        reqBodyParamsList.add(bodyParam);
                    } else if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                        gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                        String gicName = gicNameArr[0];
                        if (JavaClassValidateUtil.isArray(gicName)) {
                            gicName = gicName.substring(0, gicName.indexOf("["));
                        }
                        if (JavaClassValidateUtil.isPrimitive(gicName)) {
                            ApiParam bodyParam = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                            reqBodyParamsList.add(bodyParam);
                        } else {
                            reqBodyParamsList.addAll(this.buildParams(gicNameArr[0], "", 0, "true", responseFieldMap, false, new HashMap<String, String>()));
                        }
                    } else if (JavaClassValidateUtil.isMap(fullTypeName)) {
                        if ("java.util.Map".equals(typeName)) {
                            ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                            paramList.add(apiParam);
                            continue block0;
                        }
                        gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                        reqBodyParamsList.addAll(this.buildParams(gicNameArr[1], "", 0, "true", responseFieldMap, false, new HashMap<String, String>()));
                    } else {
                        reqBodyParamsList.addAll(this.buildParams(typeName, "", 0, "true", responseFieldMap, false, new HashMap<String, String>()));
                    }
                    ++requestBodyCounter;
                    continue;
                }
                if (paramAdded) continue;
                List<String> validatorAnnotations = DocValidatorAnnotationEnum.listValidatorAnnotations();
                if (REQUEST_PARAM.equals(annotationName) || "PathVariable".equals(annotationName)) {
                    AnnotationValue annotationOfName;
                    AnnotationValue annotationValue = annotation.getProperty("value");
                    if (null != annotationValue) {
                        paramName = StringUtil.removeQuotes((String)annotationValue.toString());
                    }
                    if (null != (annotationOfName = annotation.getProperty("name"))) {
                        paramName = StringUtil.removeQuotes((String)annotationOfName.toString());
                    }
                    ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                    paramList.add(param);
                    paramAdded = true;
                    continue;
                }
                if (!validatorAnnotations.contains(annotationName)) continue;
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                paramList.add(param);
                paramAdded = true;
            }
        }
        if (requestBodyCounter > 0) {
            paramList.addAll(reqBodyParamsList);
            return paramList;
        }
        return paramList;
    }

    private JavaClass getJavaClass(String simpleName) {
        JavaClass cls = this.builder.getClassByName(simpleName);
        List<JavaField> fieldList = this.getFields(cls, 0);
        if (Objects.isNull(cls.getFields()) || fieldList.isEmpty()) {
            cls = this.javaFilesMap.get(simpleName);
        } else {
            List classList = cls.getNestedClasses();
            for (JavaClass javaClass : classList) {
                this.javaFilesMap.put(javaClass.getFullyQualifiedName(), javaClass);
            }
        }
        return cls;
    }

    private List<JavaField> getFields(JavaClass cls1, int i) {
        ArrayList<JavaField> fieldList = new ArrayList<JavaField>();
        if (null == cls1) {
            return fieldList;
        }
        if ("Object".equals(cls1.getSimpleName()) || "Timestamp".equals(cls1.getSimpleName()) || "Date".equals(cls1.getSimpleName()) || "Locale".equals(cls1.getSimpleName())) {
            return fieldList;
        }
        JavaClass pcls = cls1.getSuperJavaClass();
        fieldList.addAll(this.getFields(pcls, i));
        fieldList.addAll(cls1.getFields());
        return fieldList;
    }

    private boolean checkController(JavaClass cls) {
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!"Controller".equals(annotationName) && !"RestController".equals(annotationName) && !"org.springframework.web.bind.annotation.RestController".equals(annotationName) && !"org.springframework.stereotype.Controller".equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    private void handControllerAlias(ApiDoc apiDoc) {
        if (this.isUseMD5) {
            String name = DocUtil.handleId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
    }

    private void handleMethodUid(ApiMethodDoc methodDoc, String methodName) {
        String name = DocUtil.handleId(methodName);
        methodDoc.setMethodId(name);
    }

    private void commonHandleParam(List<ApiParam> paramList, ApiParam param, String isRequired, String comment, String since, boolean strRequired) {
        if (StringUtil.isEmpty((String)isRequired)) {
            param.setDesc(comment).setVersion(since);
            paramList.add(param);
        } else {
            param.setDesc(comment).setVersion(since).setRequired(strRequired);
            paramList.add(param);
        }
    }

    private void handleApiDoc(JavaClass cls, List<ApiDoc> apiDocList, int order) {
        List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls);
        String controllerName = cls.getName();
        ApiDoc apiDoc = new ApiDoc();
        apiDoc.setOrder(order);
        apiDoc.setName(controllerName);
        apiDoc.setAlias(controllerName);
        this.handControllerAlias(apiDoc);
        apiDoc.setDesc(cls.getComment());
        apiDoc.setList(apiMethodDocs);
        apiDocList.add(apiDoc);
    }

    private Object handleEnumValue(JavaClass javaClass, boolean returnEnum) {
        List javaFields = javaClass.getEnumConstants();
        String value = null;
        int index = 0;
        for (JavaField javaField : javaFields) {
            String simpleName = javaField.getType().getSimpleName();
            StringBuilder valueBuilder = new StringBuilder();
            valueBuilder.append("\"").append(javaField.getName()).append("\"").toString();
            if (returnEnum) {
                value = valueBuilder.toString();
                return value;
            }
            if (!JavaClassValidateUtil.isPrimitive(simpleName) && index < 1) {
                value = null != javaField.getEnumConstantArguments() ? javaField.getEnumConstantArguments().get(0) : valueBuilder.toString();
            }
            ++index;
        }
        return value;
    }

    private boolean checkGenerics(List<JavaField> fields) {
        for (JavaField field : fields) {
            if (field.getType().getFullyQualifiedName().length() != 1) continue;
            return true;
        }
        return false;
    }
}

