/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.constants.Methods;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocUrlUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Arrays;
import java.util.List;

public class SpringMVCRequestMappingHandler {
    public RequestMapping handle(String serverUrl, String controllerBaseUrl, JavaMethod method) {
        List annotations = method.getAnnotations();
        String url = null;
        String methodType = null;
        String shortUrl = null;
        String mediaType = null;
        boolean isPostMethod = false;
        int methodCounter = 0;
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            Object produces = annotation.getNamedParameter("produces");
            if (produces != null) {
                mediaType = produces.toString();
            }
            if ("RequestMapping".equals(annotationName) || "org.springframework.web.bind.annotation.RequestMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                Object nameParam = annotation.getNamedParameter("method");
                if (null != nameParam) {
                    methodType = nameParam.toString();
                    if ("POST".equals(methodType = DocUtil.handleHttpMethod(methodType)) || "PUT".equals(methodType)) {
                        isPostMethod = true;
                    }
                } else {
                    methodType = Methods.GET.getValue();
                }
                ++methodCounter;
                continue;
            }
            if ("GetMapping".equals(annotationName) || "org.springframework.web.bind.annotation.GetMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                methodType = Methods.GET.getValue();
                ++methodCounter;
                continue;
            }
            if ("PostMapping".equals(annotationName) || "org.springframework.web.bind.annotation.PostMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                methodType = Methods.POST.getValue();
                ++methodCounter;
                isPostMethod = true;
                continue;
            }
            if ("PutMapping".equals(annotationName) || "org.springframework.web.bind.annotation.PutMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                methodType = Methods.PUT.getValue();
                ++methodCounter;
                continue;
            }
            if (!"DeleteMapping".equals(annotationName) && !"org.springframework.web.bind.annotation.DeleteMapping".equals(annotationName)) continue;
            shortUrl = DocUtil.handleMappingValue(annotation);
            methodType = Methods.DELETE.getValue();
            ++methodCounter;
        }
        if (methodCounter > 0) {
            if (null != method.getTagByName("ignore")) {
                return null;
            }
            String[] urls = (shortUrl = StringUtil.removeQuotes(shortUrl)).split(",");
            if (urls.length > 1) {
                url = DocUrlUtil.getMvcUrls(serverUrl, controllerBaseUrl, Arrays.asList(urls));
                shortUrl = DocUrlUtil.getMvcUrls("", controllerBaseUrl, Arrays.asList(urls));
            } else {
                url = UrlUtil.simplifyUrl((String)(serverUrl + "/" + controllerBaseUrl + "/" + shortUrl));
                shortUrl = UrlUtil.simplifyUrl((String)("/" + controllerBaseUrl + "/" + shortUrl));
            }
            RequestMapping requestMapping = RequestMapping.builder().setMediaType(mediaType).setMethodType(methodType).setUrl(url).setShortUrl(shortUrl).setPostMethod(isPostMethod);
            return requestMapping;
        }
        return null;
    }
}

