/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.helper;

import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.FormData;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FormDataBuildHelper {
    public static List<FormData> getFormData(String className, Map<String, String> registryClasses, int counter, ProjectDocConfigBuilder builder, String pre) {
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        if (registryClasses.containsKey(className) && counter > registryClasses.size()) {
            return formDataList;
        }
        registryClasses.put(className, className);
        ++counter;
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = builder.getJavaProjectBuilder().getClassByName(simpleName);
        List<JavaField> fields = JavaClassUtil.getFields(cls, 0);
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            FormData formData = new FormData();
            formData.setKey(pre);
            formData.setType("text");
            formData.setValue(StringUtil.removeQuotes((String)RandomUtil.randomValueByType((String)className)));
            formDataList.add(formData);
            return formDataList;
        }
        if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            String gicName = globGicName[0];
            if (JavaClassValidateUtil.isArray(gicName)) {
                gicName = gicName.substring(0, gicName.indexOf("["));
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicName, registryClasses, counter, builder, pre + "[]"));
        }
        int n = 0;
        for (JavaField field : fields) {
            FormData formData;
            String fieldName = field.getName();
            String subTypeName = field.getType().getFullyQualifiedName();
            String fieldGicName = field.getType().getGenericCanonicalName();
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(subTypeName);
            boolean ignoreField = field.getModifiers().stream().anyMatch(str -> str.equals("static") || str.equals("final"));
            if (ignoreField || "this$0".equals(fieldName) || "serialVersionUID".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName)) continue;
            String typeSimpleName = field.getType().getSimpleName();
            if (JavaClassValidateUtil.isMap(subTypeName)) continue;
            String comment = field.getComment();
            if (StringUtil.isNotEmpty((String)comment)) {
                comment = DocUtil.replaceNewLineToHtmlBr(comment);
            }
            if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                String fieldValue = DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName());
                formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("text");
                formData.setValue(StringUtil.removeQuotes((String)fieldValue));
                formData.setDesc(comment);
                formDataList.add(formData);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("text");
                formData.setValue(StringUtil.removeQuotes((String)String.valueOf(value)));
                formData.setDesc(comment);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isCollection(subTypeName)) {
                String gName;
                String gNameTemp = field.getType().getGenericCanonicalName();
                String[] gNameArr = DocClassUtil.getSimpleGicName(gNameTemp);
                if (gNameArr.length == 0 || JavaClassValidateUtil.isPrimitive(gName = DocClassUtil.getSimpleGicName(gNameTemp)[0]) || simpleName.equals(gName) || gName.equals(simpleName)) continue;
                if (gName.length() == 1) {
                    String gicName;
                    int len = globGicName.length;
                    if (len <= 0 || JavaClassValidateUtil.isPrimitive(gicName = n < len ? globGicName[n] : globGicName[len - 1]) || simpleName.equals(gicName)) continue;
                    formDataList.addAll(FormDataBuildHelper.getFormData(gicName, registryClasses, counter, builder, pre + fieldName + "[0]."));
                    continue;
                }
                formDataList.addAll(FormDataBuildHelper.getFormData(gName, registryClasses, counter, builder, pre + fieldName + "[0]."));
                continue;
            }
            if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) continue;
            formDataList.addAll(FormDataBuildHelper.getFormData(fieldGicName, registryClasses, counter, builder, pre + fieldName + "."));
        }
        return formDataList;
    }
}

