/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.JsonFormatUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.DocValidatorAnnotationEnum;
import com.power.doc.constants.SpringMvcRequestAnnotationsEnum;
import com.power.doc.handler.SpringMVCRequestHeaderHandler;
import com.power.doc.handler.SpringMVCRequestMappingHandler;
import com.power.doc.helper.FormDataBuildHelper;
import com.power.doc.helper.JsonBuildHelper;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.FormData;
import com.power.doc.model.request.ApiRequestExample;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringBootDocBuildTemplate
implements IDocBuildTemplate {
    private List<ApiReqHeader> headers;

    @Override
    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        this.headers = apiConfig.getRequestHeaders();
        ArrayList<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        for (JavaClass cls : projectBuilder.getJavaProjectBuilder().getClasses()) {
            List<ApiMethodDoc> apiMethodDocs;
            if (!this.checkController(cls)) continue;
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters())) {
                if (!DocUtil.isMatch(apiConfig.getPackageFilters(), cls.getCanonicalName())) continue;
                apiMethodDocs = this.buildControllerMethod(cls, apiConfig, projectBuilder);
                this.handleApiDoc(cls, apiDocList, apiMethodDocs, ++order, apiConfig.isMd5EncryptedHtmlName());
                continue;
            }
            apiMethodDocs = this.buildControllerMethod(cls, apiConfig, projectBuilder);
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, ++order, apiConfig.isMd5EncryptedHtmlName());
        }
        return apiDocList;
    }

    @Override
    public boolean ignoreReturnObject(String typeName) {
        return JavaClassValidateUtil.isMvcIgnoreParams(typeName) && "org.springframework.web.servlet.ModelAndView".equals(typeName);
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        List classAnnotations = cls.getAnnotations();
        String baseUrl = "";
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!"RequestMapping".equals(annotationName) && !"org.springframework.web.bind.annotation.RequestMapping".equals(annotationName) || annotation.getNamedParameter("value") == null) continue;
            baseUrl = StringUtil.removeQuotes((String)annotation.getNamedParameter("value").toString());
        }
        List methods = cls.getMethods();
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (JavaMethod method : methods) {
            if (method.getModifiers().contains("private")) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setDesc(method.getComment());
            apiMethodDoc.setName(method.getName());
            String methodUid = DocUtil.handleId(clazName + method.getName());
            apiMethodDoc.setMethodId(methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            String authorValue = DocUtil.getNormalTagComments(method, "author", cls.getName());
            if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(authorValue);
            }
            apiMethodDoc.setDetail(apiNoteValue);
            RequestMapping requestMapping = new SpringMVCRequestMappingHandler().handle(projectBuilder.getServerUrl(), baseUrl, method);
            List<ApiReqHeader> apiReqHeaders = new SpringMVCRequestHeaderHandler().handle(method);
            apiMethodDoc.setRequestHeaders(apiReqHeaders);
            if (!Objects.nonNull(requestMapping) || null != method.getTagByName("ignore")) continue;
            apiMethodDoc.setType(requestMapping.getMethodType());
            apiMethodDoc.setUrl(requestMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(requestMapping.getShortUrl());
            List<ApiParam> requestParams = this.requestParams(method, "param", projectBuilder);
            apiMethodDoc.setRequestParams(requestParams);
            ApiRequestExample requestExample = this.buildReqJson(method, apiMethodDoc, requestMapping.isPostMethod(), projectBuilder);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(method, projectBuilder));
            List<ApiParam> responseParams = this.buildReturnApiParams(method, cls.getGenericFullyQualifiedName(), projectBuilder);
            apiMethodDoc.setResponseParams(responseParams);
            List<ApiReqHeader> allApiReqHeaders = this.headers != null ? Stream.of(this.headers, apiReqHeaders).flatMap(Collection::stream).distinct().collect(Collectors.toList()) : apiReqHeaders;
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqHeaders, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private ApiRequestExample buildReqJson(JavaMethod method, ApiMethodDoc apiMethodDoc, Boolean isPostMethod, ProjectDocConfigBuilder configBuilder) {
        String exampleBody;
        String url;
        List parameterList = method.getParameters();
        if (parameterList.size() < 1) {
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl());
        }
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        Map<String, String> paramsComments = DocUtil.getParamsComments(method, "param", null);
        List<String> springMvcRequestAnnotations = SpringMvcRequestAnnotationsEnum.listSpringMvcRequestAnnotations();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        for (JavaParameter parameter : parameterList) {
            FormData formData;
            JavaType javaType = parameter.getType();
            String typeName = javaType.getFullyQualifiedName();
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName)) continue;
            String simpleTypeName = javaType.getValue();
            String gicTypeName = javaType.getGenericCanonicalName();
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String paramName = parameter.getName();
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = "";
            if (JavaClassValidateUtil.isPrimitive(simpleTypeName) && StringUtil.isEmpty((String)(mockValue = Objects.nonNull(mockValue = paramsComments.get(paramName)) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1, mockValue.length()) : ""))) {
                mockValue = DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName, Boolean.TRUE);
            }
            List annotations = parameter.getAnnotations();
            boolean paramAdded = false;
            for (JavaAnnotation annotation : annotations) {
                AnnotationValue annotationOfName;
                AnnotationValue annotationValue;
                String annotationName = annotation.getType().getSimpleName();
                String fullName = annotation.getType().getSimpleName();
                if (!springMvcRequestAnnotations.contains(fullName) || paramAdded || "RequestHeader".equals(annotationName)) continue;
                AnnotationValue annotationDefaultVal = annotation.getProperty("defaultValue");
                if (null != annotationDefaultVal) {
                    mockValue = StringUtil.removeQuotes((String)annotationDefaultVal.toString());
                }
                if (null != (annotationValue = annotation.getProperty("value"))) {
                    paramName = StringUtil.removeQuotes((String)annotationValue.toString());
                }
                if (null != (annotationOfName = annotation.getProperty("name"))) {
                    paramName = StringUtil.removeQuotes((String)annotationOfName.toString());
                }
                if ("RequestBody".equals(annotationName) || "org.springframework.web.bind.annotation.RequestBody".equals(annotationName)) {
                    apiMethodDoc.setContentType("application/json; charset=utf-8");
                    if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("{\"").append(paramName).append("\":").append(DocUtil.handleJsonStr(mockValue)).append("}");
                        requestExample.setJsonBody(builder.toString()).setJson(true);
                        paramAdded = true;
                        continue;
                    }
                    String json = JsonBuildHelper.buildJson(typeName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(), configBuilder);
                    requestExample.setJsonBody(json).setJson(true);
                    paramAdded = true;
                    continue;
                }
                if (!"PathVariable".contains(annotationName)) continue;
                if (javaClass.isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                    mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                }
                pathParamsMap.put(paramName, mockValue);
                paramAdded = true;
            }
            if (paramAdded) continue;
            if (gicTypeName.contains("org.springframework.web.multipart.MultipartFile")) {
                apiMethodDoc.setContentType("multipart/form-data");
                formData = new FormData();
                formData.setKey(paramName);
                formData.setType("file");
                formData.setDesc(comment);
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(typeName)) {
                formData = new FormData();
                formData.setKey(paramName);
                formData.setDesc(comment);
                formData.setType("text");
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (!JavaClassValidateUtil.isPrimitive(gicName)) {
                    throw new RuntimeException("FormData can't support binding Collection<T> on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                }
                FormData formData2 = new FormData();
                formData2.setKey(paramName);
                if (!paramName.contains("[]")) {
                    formData2.setKey(paramName + "[]");
                }
                formData2.setDesc(comment);
                formData2.setType("text");
                formData2.setValue(RandomUtil.randomValueByType((String)gicName));
                formDataList.add(formData2);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                FormData formData3 = new FormData();
                formData3.setKey(paramName);
                formData3.setType("text");
                formData3.setDesc(comment);
                formData3.setValue(strVal);
                formDataList.add(formData3);
                continue;
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(), 0, configBuilder, ""));
        }
        requestExample.setFormDataList(formDataList);
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        if (isPostMethod.booleanValue()) {
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String body = UrlUtil.urlJoin((String)"", DocUtil.formDataToMap(formDataList)).replace("?", "");
            body = StringUtil.removeQuotes((String)body);
            url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            exampleBody = requestExample.isJson() ? (StringUtil.isNotEmpty((String)requestExample.getJsonBody()) ? "curl -X POST -H 'Content-Type: application/json; charset=utf-8' -i " + url + " --data '" + JsonFormatUtil.formatJson((String)requestExample.getJsonBody()) + "\n'" : "curl -X POST -i " + url) : (StringUtil.isNotEmpty((String)body) ? "curl -X POST -i " + url + " --data '" + body + "'" : "curl -X POST -i " + url);
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            pathParamsMap.putAll(DocUtil.formDataToMap(formDataList));
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            url = UrlUtil.urlJoin((String)path, pathParamsMap);
            url = StringUtil.removeQuotes((String)url);
            url = apiMethodDoc.getServerUrl() + "/" + url;
            url = UrlUtil.simplifyUrl((String)url);
            exampleBody = "curl -X GET -i '" + url + "'";
            requestExample.setExampleBody(exampleBody).setJsonBody("").setUrl(url);
        }
        return requestExample;
    }

    private List<ApiParam> requestParams(JavaMethod javaMethod, String tagName, ProjectDocConfigBuilder builder) {
        boolean isStrict = builder.getApiConfig().isStrict();
        HashMap<String, CustomRespField> responseFieldMap = new HashMap<String, CustomRespField>();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = DocUtil.getParamsComments(javaMethod, tagName, className);
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() < 1) {
            return null;
        }
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        int requestBodyCounter = 0;
        ArrayList<ApiParam> reqBodyParamsList = new ArrayList<ApiParam>();
        block0: for (JavaParameter parameter : parameterList) {
            boolean paramAdded = false;
            String paramName = parameter.getName();
            String typeName = parameter.getType().getGenericCanonicalName();
            String simpleName = parameter.getType().getValue().toLowerCase();
            String fullTypeName = parameter.getType().getFullyQualifiedName();
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName)) continue;
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            String comment = this.paramCommentResolve(paramTagMap.get(paramName));
            if (typeName.contains("org.springframework.web.multipart.MultipartFile")) {
                ApiParam param = ApiParam.of().setField(paramName).setType("file").setDesc(comment).setRequired(true).setVersion("-");
                paramList.add(param);
                continue;
            }
            List annotations = parameter.getAnnotations();
            if (annotations.size() == 0) {
                ApiParam param;
                if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                    ApiParam param2;
                    String[] gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                    String gicName = gicNameArr[0];
                    if (JavaClassValidateUtil.isArray(gicName)) {
                        gicName = gicName.substring(0, gicName.indexOf("["));
                    }
                    String typeTemp = "";
                    if (JavaClassValidateUtil.isPrimitive(gicName)) {
                        typeTemp = " of " + DocClassUtil.processTypeNameForParams(gicName);
                        param2 = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName) + typeTemp).setDesc(comment).setRequired(true).setVersion("-");
                        paramList.add(param2);
                    } else {
                        param2 = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName) + typeTemp).setDesc(comment).setRequired(true).setVersion("-");
                        paramList.add(param2);
                        paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], "\u2514\u2500", 1, "true", responseFieldMap, Boolean.FALSE, new HashMap<String, String>(), builder));
                    }
                } else if (JavaClassValidateUtil.isPrimitive(simpleName)) {
                    param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(true).setVersion("-");
                    paramList.add(param);
                } else if ("java.util.Map".equals(typeName)) {
                    param = ApiParam.of().setField(paramName).setType("map").setDesc(comment).setRequired(true).setVersion("-");
                    paramList.add(param);
                } else if (javaClass.isEnum()) {
                    param = ApiParam.of().setField(paramName).setType("string").setDesc(comment).setRequired(true).setVersion("-");
                    paramList.add(param);
                } else {
                    paramList.addAll(ParamsBuildHelper.buildParams(fullTypeName, "", 0, "true", responseFieldMap, Boolean.FALSE, new HashMap<String, String>(), builder));
                }
            }
            for (JavaAnnotation annotation : annotations) {
                String annotationName;
                String required = "true";
                AnnotationValue annotationRequired = annotation.getProperty("required");
                if (null != annotationRequired) {
                    required = annotationRequired.toString();
                }
                if ("RequestBody".equals(annotationName = annotation.getType().getName()) || "Valid".equals(annotationName) && annotations.size() == 1) {
                    String[] gicNameArr;
                    if (requestBodyCounter > 0) {
                        throw new RuntimeException("You have use @RequestBody Passing multiple variables  for method " + javaMethod.getName() + " in " + className + ",@RequestBody annotation could only bind one variables.");
                    }
                    if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                        ApiParam bodyParam = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required));
                        reqBodyParamsList.add(bodyParam);
                    } else if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                        gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                        String gicName = gicNameArr[0];
                        if (JavaClassValidateUtil.isArray(gicName)) {
                            gicName = gicName.substring(0, gicName.indexOf("["));
                        }
                        if (JavaClassValidateUtil.isPrimitive(gicName)) {
                            ApiParam bodyParam = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                            reqBodyParamsList.add(bodyParam);
                        } else {
                            reqBodyParamsList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], "", 0, "true", responseFieldMap, Boolean.FALSE, new HashMap<String, String>(), builder));
                        }
                    } else if (JavaClassValidateUtil.isMap(fullTypeName)) {
                        if ("java.util.Map".equals(typeName)) {
                            ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                            paramList.add(apiParam);
                            continue block0;
                        }
                        gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                        reqBodyParamsList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, "true", responseFieldMap, Boolean.FALSE, new HashMap<String, String>(), builder));
                    } else {
                        reqBodyParamsList.addAll(ParamsBuildHelper.buildParams(typeName, "", 0, "true", responseFieldMap, Boolean.FALSE, new HashMap<String, String>(), builder));
                    }
                    ++requestBodyCounter;
                    continue;
                }
                if (paramAdded) continue;
                List<String> validatorAnnotations = DocValidatorAnnotationEnum.listValidatorAnnotations();
                if ("RequestParam".equals(annotationName) || "PathVariable".equals(annotationName)) {
                    AnnotationValue annotationOfName;
                    AnnotationValue annotationValue = annotation.getProperty("value");
                    if (null != annotationValue) {
                        paramName = StringUtil.removeQuotes((String)annotationValue.toString());
                    }
                    if (null != (annotationOfName = annotation.getProperty("name"))) {
                        paramName = StringUtil.removeQuotes((String)annotationOfName.toString());
                    }
                    ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                    paramList.add(param);
                    paramAdded = true;
                    continue;
                }
                if (!validatorAnnotations.contains(annotationName)) continue;
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                paramList.add(param);
                paramAdded = true;
            }
        }
        if (requestBodyCounter > 0) {
            paramList.addAll(reqBodyParamsList);
            return paramList;
        }
        return paramList;
    }

    private boolean checkController(JavaClass cls) {
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getName();
            if (!"Controller".equals(name = JavaClassUtil.getAnnotationSimpleName(name)) && !"RestController".equals(name)) continue;
            return true;
        }
        return false;
    }
}

