/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.github.javafaker.Faker;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.IDCardUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.FormData;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class DocUtil {
    private static Faker faker = new Faker(new Locale(System.getProperty("smart-doc_language")));
    private static Faker enFaker = new Faker(new Locale("en-US"));
    private static Map<String, String> fieldValue = new LinkedHashMap<String, String>();

    public static String jsonValueByType(String typeName) {
        String type = typeName.contains(".") ? typeName.substring(typeName.lastIndexOf(".") + 1) : typeName;
        String value = RandomUtil.randomValueByType((String)type);
        if ("Integer".equals(type) || "int".equals(type) || "Long".equals(type) || "long".equals(type) || "Double".equals(type) || "double".equals(type) || "Float".equals(type) || "float".equals(type) || "BigDecimal".equals(type) || "boolean".equals(type) || "Boolean".equals(type) || "Short".equals(type) || "BigInteger".equals(type)) {
            return value;
        }
        if ("Void".equals(type)) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"").append(value).append("\"");
        return builder.toString();
    }

    public static String getValByTypeAndFieldName(String typeName, String filedName) {
        boolean isArray = true;
        String type = typeName.contains("java.lang") ? typeName.substring(typeName.lastIndexOf(".") + 1, typeName.length()) : typeName;
        String key = filedName.toLowerCase() + "-" + type.toLowerCase();
        StringBuilder value = null;
        if (!type.contains("[")) {
            isArray = false;
        }
        for (Map.Entry<String, String> entry : fieldValue.entrySet()) {
            if (!key.contains(entry.getKey())) continue;
            value = new StringBuilder(entry.getValue());
            if (!isArray) break;
            for (int i = 0; i < 2; ++i) {
                value.append(",").append(entry.getValue());
            }
        }
        if (null == value) {
            return DocUtil.jsonValueByType(typeName);
        }
        if ("string".equals(type.toLowerCase())) {
            return DocUtil.handleJsonStr(value.toString());
        }
        return value.toString();
    }

    public static String getValByTypeAndFieldName(String type0, String filedName, boolean removeDoubleQuotation) {
        if (removeDoubleQuotation) {
            return DocUtil.getValByTypeAndFieldName(type0, filedName).replace("\"", "");
        }
        return DocUtil.getValByTypeAndFieldName(type0, filedName);
    }

    public static boolean isClassName(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return false;
        }
        if (className.contains("<") && !className.contains(">")) {
            return false;
        }
        return !className.contains(">") || className.contains("<");
    }

    public static boolean isMatch(String packageFilters, String controllerName) {
        if (StringUtil.isNotEmpty((String)packageFilters)) {
            String[] patterns;
            for (String str : patterns = packageFilters.split(",")) {
                String name;
                if (!(str.endsWith("*") ? controllerName.contains(name = str.substring(0, str.length() - 2)) : controllerName.contains(str))) continue;
                return true;
            }
        }
        return false;
    }

    public static String formatAndRemove(String str, Map<String, String> values) {
        StringBuilder builder = new StringBuilder(str);
        Set<Map.Entry<String, String>> entries = values.entrySet();
        Iterator<Map.Entry<String, String>> iteratorMap = entries.iterator();
        while (iteratorMap.hasNext()) {
            int start;
            Map.Entry<String, String> next = iteratorMap.next();
            String pattern = "{" + next.getKey() + "}";
            String value = next.getValue().toString();
            while ((start = builder.indexOf(pattern)) != -1) {
                builder.replace(start, start + pattern.length(), value);
                iteratorMap.remove();
                values.remove(next.getKey());
            }
        }
        return builder.toString();
    }

    public static String handleHttpMethod(String method) {
        switch (method) {
            case "RequestMethod.POST": {
                return "POST";
            }
            case "RequestMethod.GET": {
                return "GET";
            }
            case "RequestMethod.PUT": {
                return "PUT";
            }
            case "RequestMethod.DELETE": {
                return "DELETE";
            }
        }
        return "GET";
    }

    public static String handleMappingValue(JavaAnnotation annotation) {
        if (null == annotation.getNamedParameter("value")) {
            return "/";
        }
        return StringUtil.trimBlank((String)String.valueOf(annotation.getNamedParameter("value")));
    }

    public static Map<String, String> getParamsComments(JavaMethod javaMethod, String tagName, String className) {
        List paramTags = javaMethod.getTagsByName(tagName);
        HashMap<String, String> paramTagMap = new HashMap<String, String>();
        for (DocletTag docletTag : paramTags) {
            String pValue;
            String pName;
            String value = docletTag.getValue();
            if (StringUtil.isEmpty((String)value) && StringUtil.isNotEmpty((String)className)) {
                throw new RuntimeException("ERROR: #" + javaMethod.getName() + "() - bad @" + tagName + " javadoc from " + javaMethod.getDeclaringClass().getCanonicalName() + ", must be add comment if you use it.");
            }
            int idx = value.indexOf("\n");
            if (idx > -1) {
                pName = value.substring(0, idx);
                pValue = value.substring(idx + 1);
            } else {
                pName = value.indexOf(" ") > -1 ? value.substring(0, value.indexOf(" ")) : value;
                pValue = value.indexOf(" ") > -1 ? value.substring(value.indexOf(32) + 1) : "No comments found.";
            }
            paramTagMap.put(pName, pValue);
        }
        return paramTagMap;
    }

    public static String getNormalTagComments(JavaMethod javaMethod, String tagName, String className) {
        Map<String, String> map = DocUtil.getParamsComments(javaMethod, tagName, className);
        return DocUtil.getFirstKeyAndValue(map);
    }

    public static Map<String, String> getFieldTagsValue(JavaField field) {
        List paramTags = field.getTags();
        return paramTags.stream().collect(Collectors.toMap(DocletTag::getName, DocletTag::getValue));
    }

    public static String getFirstKeyAndValue(Map<String, String> map) {
        Map.Entry<String, String> entry;
        String value = null;
        if (map != null && map.size() > 0 && (entry = map.entrySet().iterator().next()) != null) {
            value = "No comments found.".equals(entry.getValue()) ? entry.getKey() : entry.getKey() + entry.getValue();
            value = DocUtil.replaceNewLineToHtmlBr(value);
        }
        return value;
    }

    public static String handleId(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        String valueId = DigestUtils.md5Hex((String)value);
        int length = valueId.length();
        if (valueId.length() < 32) {
            return valueId;
        }
        return valueId.substring(length - 32, length);
    }

    public static String replaceNewLineToHtmlBr(String content) {
        if (StringUtil.isNotEmpty((String)content)) {
            return content.replaceAll("(\r\n|\r|\n|\n\r)", "<br>");
        }
        return null;
    }

    public static String handleJsonStr(String content) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"").append(content).append("\"");
        return builder.toString();
    }

    public static Map<String, String> formDataToMap(List<FormData> formDataList) {
        LinkedHashMap<String, String> formDataMap = new LinkedHashMap<String, String>();
        for (FormData formData : formDataList) {
            if ("file".equals(formData.getType())) continue;
            formDataMap.put(formData.getKey(), formData.getValue());
        }
        return formDataMap;
    }

    static {
        fieldValue.put("uuid-string", UUID.randomUUID().toString());
        fieldValue.put("uid", UUID.randomUUID().toString());
        fieldValue.put("id-string", String.valueOf(RandomUtil.randomInt((int)1, (int)200)));
        fieldValue.put("nickname-string", enFaker.name().username());
        fieldValue.put("hostname-string", faker.internet().ipV4Address());
        fieldValue.put("name-string", faker.name().username());
        fieldValue.put("author-string", faker.book().author());
        fieldValue.put("url-string", faker.internet().url());
        fieldValue.put("username-string", faker.name().username());
        fieldValue.put("page-int", "1");
        fieldValue.put("page-integer", "1");
        fieldValue.put("age-int", String.valueOf(RandomUtil.randomInt((int)0, (int)70)));
        fieldValue.put("age-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)70)));
        fieldValue.put("email-string", faker.internet().emailAddress());
        fieldValue.put("domain-string", faker.internet().domainName());
        fieldValue.put("phone-string", faker.phoneNumber().cellPhone());
        fieldValue.put("mobile-string", faker.phoneNumber().cellPhone());
        fieldValue.put("telephone-string", faker.phoneNumber().phoneNumber());
        fieldValue.put("address-string", faker.address().fullAddress().replace(",", "\uff0c"));
        fieldValue.put("ip-string", faker.internet().ipV4Address());
        fieldValue.put("ipv4-string", faker.internet().ipV4Address());
        fieldValue.put("ipv6-string", faker.internet().ipV6Address());
        fieldValue.put("company-string", faker.company().name());
        fieldValue.put("timestamp-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("timestamp-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        fieldValue.put("time-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("time-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        fieldValue.put("birthday-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("birthday-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("code-string", String.valueOf(RandomUtil.randomInt((int)100, (int)99999)));
        fieldValue.put("message-string", "success,fail".split(",")[RandomUtil.randomInt((int)0, (int)1)]);
        fieldValue.put("date-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("date-date", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("state-int", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("state-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("flag-int", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("flag-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("flag-boolean", "true");
        fieldValue.put("flag-Boolean", "false");
        fieldValue.put("idcard-string", IDCardUtil.getIdCard());
        fieldValue.put("sex-int", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("sex-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("gender-int", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("gender-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("limit-int", "10");
        fieldValue.put("limit-integer", "10");
        fieldValue.put("size-int", "10");
        fieldValue.put("size-integer", "10");
        fieldValue.put("offset-int", "1");
        fieldValue.put("offset-integer", "1");
        fieldValue.put("offset-long", "1");
        fieldValue.put("version-string", enFaker.app().version());
    }
}

