/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.ApiReqParamInTypeEnum;
import com.power.doc.constants.Methods;
import com.power.doc.constants.SpringMvcRequestAnnotationsEnum;
import com.power.doc.handler.SpringMVCRequestHeaderHandler;
import com.power.doc.handler.SpringMVCRequestMappingHandler;
import com.power.doc.helper.FormDataBuildHelper;
import com.power.doc.helper.JsonBuildHelper;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiMethodReqParam;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.FormData;
import com.power.doc.model.request.ApiRequestExample;
import com.power.doc.model.request.CurlRequest;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.CurlUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.power.doc.utils.JsonUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.power.doc.utils.TornaUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SpringBootDocBuildTemplate
implements IDocBuildTemplate<ApiDoc> {
    private static Logger log = Logger.getLogger(SpringBootDocBuildTemplate.class.getName());
    private final AtomicInteger atomicInteger = new AtomicInteger(1);
    private List<ApiReqParam> configApiReqParams;

    @Override
    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        this.configApiReqParams = Stream.of(apiConfig.getRequestHeaders(), apiConfig.getRequestParams()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        Collection classes = projectBuilder.getJavaProjectBuilder().getClasses();
        boolean setCustomOrder = false;
        for (JavaClass cls : classes) {
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls.getCanonicalName())) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.checkController(cls) || Objects.nonNull(ignoreTag)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonnegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
            }
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls, apiConfig, projectBuilder);
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, order, apiConfig.isMd5EncryptedHtmlName());
        }
        apiDocList = this.handleTagsApiDoc(apiDocList);
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).peek(p -> p.setOrder(this.atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    private List<ApiDoc> handleTagsApiDoc(List<ApiDoc> apiDocList) {
        if (CollectionUtil.isEmpty(apiDocList)) {
            return Collections.emptyList();
        }
        HashMap copyMap = new HashMap();
        apiDocList.forEach(doc -> {
            Object[] tags = doc.getTags();
            if (ArrayUtils.isEmpty((Object[])tags)) {
                tags = new String[]{doc.getName()};
            }
            for (Object tag : tags) {
                tag = StringUtil.trim((String)tag);
                copyMap.computeIfPresent(tag, (k, v) -> {
                    List<Object> list = CollectionUtil.isEmpty(v.getList()) ? new ArrayList() : v.getList();
                    list.addAll(doc.getList());
                    v.setList(list);
                    return v;
                });
                copyMap.putIfAbsent(tag, doc);
            }
        });
        HashMap<String, ApiDoc> allMap = new HashMap<String, ApiDoc>(copyMap);
        allMap.forEach((k, v) -> {
            List<ApiMethodDoc> methodDocList = v.getList();
            methodDocList.forEach(method -> {
                Object[] tags = method.getTags();
                if (ArrayUtils.isEmpty((Object[])tags)) {
                    return;
                }
                for (Object tag : tags) {
                    tag = StringUtil.trim((String)tag);
                    copyMap.computeIfPresent(tag, (k1, v2) -> {
                        method.setOrder(v2.getList().size() + 1);
                        v2.getList().add((ApiMethodDoc)method);
                        return v2;
                    });
                    copyMap.putIfAbsent(tag, ApiDoc.buildTagApiDoc(v, (String)tag, method));
                }
            });
        });
        ArrayList<ApiDoc> apiDocs = new ArrayList<ApiDoc>(copyMap.values());
        int index = apiDocs.size() - 1;
        for (ApiDoc apiDoc : apiDocs) {
            if (apiDoc.getOrder() != null) continue;
            apiDoc.setOrder(index++);
        }
        apiDocs.sort(Comparator.comparing(ApiDoc::getOrder));
        return apiDocs;
    }

    @Override
    public ApiDoc getSingleApiData(ProjectDocConfigBuilder projectBuilder, String apiClassName) {
        return null;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return JavaClassValidateUtil.isMvcIgnoreParams(typeName, ignoreParams);
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        String group = JavaClassUtil.getClassTagsValue(cls, "group", Boolean.TRUE);
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        List<JavaAnnotation> classAnnotations = this.getAnnotations(cls);
        Map<String, String> constantsMap = projectBuilder.getConstantsMap();
        String baseUrl = "";
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getValue();
            if ("RequestMapping".equals(annotationName) || "org.springframework.web.bind.annotation.RequestMapping".equals(annotationName)) {
                baseUrl = StringUtil.removeQuotes((String)DocUtil.getRequestMappingUrl(annotation));
            }
            if (!"FeignClient".equals(annotationName) && !"org.springframework.cloud.netflix.feign.FeignClient".equals(annotationName)) continue;
            baseUrl = StringUtil.removeQuotes((String)DocUtil.getPathUrl(annotation, "path"));
        }
        List methods = cls.getMethods();
        ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
        for (JavaMethod method : methods) {
            if (method.isPrivate() || DocUtil.isMatch(apiConfig.getPackageExcludeFilters(), clazName + "." + method.getName())) continue;
            docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method));
        }
        JavaClass parentClass = cls.getSuperJavaClass();
        if (Objects.nonNull(parentClass) && !"Object".equals(parentClass.getSimpleName())) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(parentClass);
            List parentMethodList = parentClass.getMethods();
            Iterator iterator = parentMethodList.iterator();
            while (iterator.hasNext()) {
                JavaMethod method = (JavaMethod)iterator.next();
                docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method).setActualTypesMap(actualTypesMap));
            }
        }
        List implClasses = cls.getImplements();
        for (JavaType type : implClasses) {
            JavaClass javaClass = (JavaClass)type;
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(javaClass);
            for (JavaMethod method : javaClass.getMethods()) {
                if (!method.isDefault()) continue;
                docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method).setActualTypesMap(actualTypesMap));
            }
        }
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (DocJavaMethod docJavaMethod : docJavaMethods) {
            List<ApiReqParam> allApiReqHeaders;
            DocletTag docletTag;
            DocletTag pageTag;
            RequestMapping requestMapping;
            JavaMethod method = docJavaMethod.getJavaMethod();
            if (method.isPrivate() || Objects.nonNull(method.getTagByName("ignore")) || Objects.isNull(requestMapping = new SpringMVCRequestMappingHandler().handle(projectBuilder, baseUrl, method, constantsMap))) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            DocletTag downloadTag = method.getTagByName("download");
            if (Objects.nonNull(downloadTag)) {
                apiMethodDoc.setDownload(true);
            }
            if (Objects.nonNull(pageTag = method.getTagByName("page"))) {
                String pageUrl = projectBuilder.getServerUrl() + "/" + pageTag.getValue();
                apiMethodDoc.setPage(UrlUtil.simplifyUrl((String)pageUrl));
            }
            if (Objects.nonNull(docletTag = method.getTagByName("group"))) {
                apiMethodDoc.setGroup(docletTag.getValue());
            } else {
                apiMethodDoc.setGroup(group);
            }
            List tags = method.getTagsByName("tag");
            apiMethodDoc.setTags((String[])tags.stream().map(DocletTag::getValue).toArray(String[]::new));
            apiMethodDoc.setName(method.getName());
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setDesc(method.getComment());
            String methodUid = DocUtil.generateId(clazName + method.getName());
            apiMethodDoc.setMethodId(methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            Map<String, String> authorMap = DocUtil.getCommentsByTag(method, "author", cls.getName());
            String authorValue = String.join((CharSequence)", ", new ArrayList<String>(authorMap.keySet()));
            if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(StringUtil.removeQuotes((String)authorValue));
            }
            if (apiConfig.isShowAuthor() && StringUtil.isEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(classAuthor);
            }
            apiMethodDoc.setDetail(apiNoteValue != null ? apiNoteValue : "");
            List<ApiReqParam> apiReqHeaders = new SpringMVCRequestHeaderHandler().handle(method, projectBuilder);
            apiReqHeaders = apiReqHeaders.stream().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            apiMethodDoc.setType(requestMapping.getMethodType());
            apiMethodDoc.setUrl(requestMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(requestMapping.getShortUrl());
            apiMethodDoc.setDeprecated(requestMapping.isDeprecated());
            List javaParameters = method.getParameters();
            TornaUtil.setTornaArrayTags(javaParameters, apiMethodDoc, docJavaMethod.getJavaMethod().getReturns(), apiConfig);
            List<ApiReqParam> apiReqParamList = this.configApiReqParams.stream().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            ApiMethodReqParam apiMethodReqParam = this.requestParams(docJavaMethod, projectBuilder, apiReqParamList);
            if (paramsDataToTree) {
                apiMethodDoc.setPathParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getPathParams()));
                apiMethodDoc.setQueryParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getQueryParams()));
                apiMethodDoc.setRequestParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getRequestParams()));
            } else {
                apiMethodDoc.setPathParams(apiMethodReqParam.getPathParams());
                apiMethodDoc.setQueryParams(apiMethodReqParam.getQueryParams());
                apiMethodDoc.setRequestParams(apiMethodReqParam.getRequestParams());
            }
            if (this.configApiReqParams != null) {
                Map<String, List<ApiReqParam>> reqParamMap = this.configApiReqParams.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn));
                List headerParamList = reqParamMap.getOrDefault(ApiReqParamInTypeEnum.HEADER.getValue(), Collections.emptyList());
                allApiReqHeaders = Stream.of(headerParamList, apiReqHeaders).filter(Objects::nonNull).flatMap(Collection::stream).distinct().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            } else {
                allApiReqHeaders = apiReqHeaders.stream().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            }
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqHeaders, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            String path = apiMethodDoc.getPath().split(";")[0];
            String pathUrl = DocUtil.formatPathUrl(path);
            List<ApiParam> pathParams = apiMethodDoc.getPathParams();
            Iterator<ApiParam> pathIterator = pathParams.iterator();
            while (pathIterator.hasNext()) {
                ApiParam next = pathIterator.next();
                String pathKey = "{" + next.getField() + "}";
                if (pathUrl.contains(pathKey)) continue;
                pathIterator.remove();
            }
            ApiRequestExample requestExample = this.buildReqJson(docJavaMethod, apiMethodDoc, requestMapping.getMethodType(), projectBuilder);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
            if (StringUtil.isNotEmpty((String)responseValue)) {
                responseValue = responseValue.replaceAll("<br>", "");
                apiMethodDoc.setResponseUsage(JsonUtil.toPrettyFormat(responseValue));
            } else {
                apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
            }
            List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
            }
            apiMethodDoc.setReturnSchema(docJavaMethod.getReturnSchema());
            apiMethodDoc.setRequestSchema(docJavaMethod.getRequestSchema());
            apiMethodDoc.setResponseParams(responseParams);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private ApiRequestExample buildReqJson(DocJavaMethod javaMethod, ApiMethodDoc apiMethodDoc, String methodType, ProjectDocConfigBuilder configBuilder) {
        String exampleBody;
        CurlRequest curlRequest;
        String url;
        JavaMethod method = javaMethod.getJavaMethod();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> queryParamsMap = new LinkedHashMap<String, String>();
        apiMethodDoc.getPathParams().stream().filter(Objects::nonNull).filter(p -> StringUtil.isNotEmpty((String)p.getValue()) || p.isConfigParam()).forEach(param -> pathParamsMap.put(param.getSourceField(), param.getValue()));
        apiMethodDoc.getQueryParams().stream().filter(Objects::nonNull).filter(p -> StringUtil.isNotEmpty((String)p.getValue()) || p.isConfigParam()).forEach(param -> queryParamsMap.put(param.getSourceField(), param.getValue()));
        List methodAnnotations = method.getAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            if (!annotationName.contains("Mapping") || Objects.isNull(paramsObjects = annotation.getNamedParameter("params"))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamProcess(paramsObjects.toString(), queryParamsMap);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamProcess(str, queryParamsMap);
            }
        }
        List parameterList = method.getParameters();
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        if (parameterList.size() < 1) {
            String path = apiMethodDoc.getPath().split(";")[0];
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String url2 = UrlUtil.urlJoin((String)path, queryParamsMap);
            url2 = StringUtil.removeQuotes((String)url2);
            url2 = apiMethodDoc.getServerUrl() + "/" + url2;
            url2 = UrlUtil.simplifyUrl((String)url2);
            CurlRequest curlRequest2 = CurlRequest.builder().setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url2);
            String format = CurlUtil.toCurl(curlRequest2);
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        Set<String> ignoreSets = this.ignoreParamsSets(method);
        Map<String, JavaType> actualTypesMap = javaMethod.getActualTypesMap();
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map<String, String> replacementMap = configBuilder.getReplaceClassMap();
        Map<String, String> paramsComments = DocUtil.getCommentsByTag(method, "param", null);
        List<String> springMvcRequestAnnotations = SpringMvcRequestAnnotationsEnum.listSpringMvcRequestAnnotations();
        List<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        block2: for (JavaParameter parameter : parameterList) {
            FormData formData;
            String paramName;
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            if (ignoreSets.contains(paramName = parameter.getName())) continue;
            String typeName = javaType.getFullyQualifiedName();
            String gicTypeName = javaType.getGenericCanonicalName();
            String commentClass = paramsComments.get(paramName);
            if (Objects.nonNull(commentClass) && commentClass.contains("ignore")) continue;
            String rewriteClassName = this.getRewriteClassName(replacementMap, typeName, commentClass);
            if (DocUtil.isClassName(rewriteClassName)) {
                gicTypeName = rewriteClassName;
                typeName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName, configBuilder.getApiConfig().getIgnoreRequestParams())) continue;
            String simpleTypeName = javaType.getValue();
            typeName = DocClassUtil.rewriteRequestParam(typeName);
            gicTypeName = DocClassUtil.rewriteRequestParam(gicTypeName);
            if (JavaClassValidateUtil.isCollection(typeName)) {
                apiMethodDoc.setListParam(true);
            }
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicTypeName, simpleTypeName);
            if (queryParamsMap.containsKey(paramName)) {
                mockValue = (String)queryParamsMap.get(paramName);
            }
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, configBuilder.getJavaProjectBuilder());
            boolean paramAdded = false;
            boolean requestParam = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                String fullName = annotation.getType().getSimpleName();
                if (!springMvcRequestAnnotations.contains(fullName) || paramAdded) continue;
                if (JavaClassValidateUtil.ignoreSpringMvcParamWithAnnotation(annotationName)) continue block2;
                AnnotationValue annotationDefaultVal = annotation.getProperty("defaultValue");
                if (Objects.nonNull(annotationDefaultVal)) {
                    mockValue = DocUtil.resolveAnnotationValue(annotationDefaultVal);
                }
                paramName = this.getParamName(paramName, annotation);
                if ("RequestBody".equals(annotationName) || "org.springframework.web.bind.annotation.RequestBody".equals(annotationName)) {
                    apiMethodDoc.setContentType("application/json");
                    if (Objects.nonNull(configBuilder.getApiConfig().getRequestBodyAdvice()) && Objects.isNull(method.getTagByName("ignoreRequestBodyAdvice"))) {
                        String requestBodyAdvice = configBuilder.getApiConfig().getRequestBodyAdvice().getClassName();
                        typeName = configBuilder.getApiConfig().getRequestBodyAdvice().getClassName();
                        gicTypeName = requestBodyAdvice + "<" + gicTypeName + ">";
                    }
                    boolean isArrayOrCollection = false;
                    if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                        simpleTypeName = globGicName[0];
                        isArrayOrCollection = true;
                    }
                    if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                        if (isArrayOrCollection) {
                            mockValue = StringUtil.isNotEmpty((String)mockValue) ? "[" + mockValue + "]" : "[" + DocUtil.getValByTypeAndFieldName(gicTypeName, paramName) + "]";
                            mockValue = JsonUtil.toPrettyFormat(mockValue);
                        }
                        requestExample.setJsonBody(mockValue).setJson(true);
                    } else {
                        String json = JsonBuildHelper.buildJson(typeName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(), groupClasses, configBuilder);
                        requestExample.setJsonBody(JsonUtil.toPrettyFormat(json)).setJson(true);
                    }
                    queryParamsMap.remove(paramName);
                    paramAdded = true;
                    continue;
                }
                if ("PathVariable".contains(annotationName)) {
                    if (javaClass.isEnum()) {
                        Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                        mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                    }
                    if (pathParamsMap.containsKey(paramName)) {
                        mockValue = (String)pathParamsMap.get(paramName);
                    }
                    pathParamsMap.put(paramName, mockValue);
                    paramAdded = true;
                    continue;
                }
                if (!"RequestParam".contains(annotationName)) continue;
                if (javaClass.isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                    mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                }
                if (queryParamsMap.containsKey(paramName)) {
                    mockValue = (String)queryParamsMap.get(paramName);
                }
                if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                    requestExample.addJsonBody(mockValue);
                }
                if (JavaClassValidateUtil.isFile(typeName)) break;
                queryParamsMap.put(paramName, mockValue);
                requestParam = true;
                paramAdded = true;
            }
            if (paramAdded) continue;
            if (JavaClassValidateUtil.isFile(gicTypeName)) {
                apiMethodDoc.setContentType("multipart/form-data");
                formData = new FormData();
                formData.setKey(paramName);
                formData.setType("file");
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment = comment + "(array of file)";
                    formData.setType("file");
                    formData.setHasItems(true);
                }
                formData.setDescription(comment);
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(typeName) && !requestParam) {
                formData = new FormData();
                formData.setKey(paramName);
                formData.setDescription(comment);
                formData.setType("text");
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (!JavaClassValidateUtil.isPrimitive(gicName) && !configBuilder.getJavaProjectBuilder().getClassByName(gicName).isEnum()) {
                    throw new RuntimeException("Spring MVC can't support binding Collection on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                }
                String value = null;
                JavaClass javaClass1 = configBuilder.getClassByName(gicName);
                value = Objects.nonNull(javaClass1) && javaClass1.isEnum() ? String.valueOf(JavaClassUtil.getEnumValue(javaClass1, Boolean.TRUE)) : RandomUtil.randomValueByType((String)gicName);
                FormData formData2 = new FormData();
                formData2.setKey(paramName);
                if (!paramName.contains("[]")) {
                    formData2.setKey(paramName + "[]");
                }
                formData2.setDescription(comment);
                formData2.setType("text");
                formData2.setValue(value);
                formDataList.add(formData2);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                FormData formData3 = new FormData();
                formData3.setKey(paramName);
                formData3.setType("text");
                formData3.setDescription(comment);
                formData3.setValue(strVal);
                formDataList.add(formData3);
                continue;
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(), 0, configBuilder, ""));
        }
        boolean hasFormDataUploadFile = formDataList.stream().anyMatch(form -> Objects.equals(form.getType(), "file"));
        Map<Boolean, List<FormData>> formDataGroupMap = formDataList.stream().collect(Collectors.groupingBy(e -> Objects.equals(e.getType(), "file")));
        List fileFormDataList = formDataGroupMap.getOrDefault(Boolean.TRUE, new ArrayList());
        if (hasFormDataUploadFile) {
            formDataList = formDataGroupMap.getOrDefault(Boolean.FALSE, new ArrayList());
            apiMethodDoc.setContentType("multipart/form-data");
        }
        requestExample.setFormDataList(formDataList);
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        Map<String, String> formDataToMap = DocUtil.formDataToMap(formDataList);
        queryParamsMap.putAll(formDataToMap);
        if (Methods.POST.getValue().equals(methodType) || Methods.PUT.getValue().equals(methodType)) {
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String body = UrlUtil.urlJoin((String)"", queryParamsMap).replace("?", "");
            body = StringUtil.removeQuotes((String)body);
            url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            if (requestExample.isJson()) {
                if (StringUtil.isNotEmpty((String)body)) {
                    url = url + "?" + body;
                }
                curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            } else {
                curlRequest = StringUtil.isNotEmpty((String)body) ? CurlRequest.builder().setBody(body).setContentType(apiMethodDoc.getContentType()).setFileFormDataList(fileFormDataList).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url) : CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setFileFormDataList(fileFormDataList).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            }
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            url = UrlUtil.urlJoin((String)path, queryParamsMap);
            url = StringUtil.removeQuotes((String)url);
            url = apiMethodDoc.getServerUrl() + "/" + url;
            url = UrlUtil.simplifyUrl((String)url);
            curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
            exampleBody = CurlUtil.toCurl(curlRequest);
            requestExample.setExampleBody(exampleBody).setJsonBody(requestExample.isJson() ? requestExample.getJsonBody() : "").setUrl(url);
        }
        return requestExample;
    }

    private ApiMethodReqParam requestParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder, List<ApiReqParam> configApiReqParams) {
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        boolean isStrict = builder.getApiConfig().isStrict();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> replacementMap = builder.getReplaceClassMap();
        Map<String, String> paramTagMap = DocUtil.getCommentsByTag(javaMethod, "param", className);
        Map<String, String> paramsComments = DocUtil.getCommentsByTag(javaMethod, "param", null);
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        HashMap<String, String> mappingParams = new HashMap<String, String>();
        List methodAnnotations = javaMethod.getAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            if (!annotationName.contains("Mapping") || Objects.isNull(paramsObjects = annotation.getNamedParameter("params"))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamToApiParam(paramsObjects.toString(), paramList, mappingParams);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamToApiParam(str, paramList, mappingParams);
            }
        }
        Map<String, Map<String, ApiReqParam>> collect = configApiReqParams.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn, Collectors.toMap(ApiReqParam::getName, m -> m, (k1, k2) -> k1)));
        Map<String, ApiReqParam> pathReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.PATH.getValue(), Collections.emptyMap());
        Map<String, ApiReqParam> queryReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.QUERY.getValue(), Collections.emptyMap());
        List parameterList = javaMethod.getParameters();
        if (parameterList.isEmpty()) {
            AtomicInteger querySize = new AtomicInteger(paramList.size() + 1);
            paramList.addAll(queryReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setQueryParam(true).setId(querySize.getAndIncrement())).collect(Collectors.toList()));
            AtomicInteger pathSize = new AtomicInteger(1);
            return ApiMethodReqParam.builder().setPathParams(new ArrayList<ApiParam>(pathReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setPathParam(true).setId(pathSize.getAndIncrement())).collect(Collectors.toList()))).setQueryParams(paramList).setRequestParams(new ArrayList<ApiParam>(0));
        }
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        Set<String> ignoreSets = this.ignoreParamsSets(javaMethod);
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        int requestBodyCounter = 0;
        block2: for (JavaParameter parameter : parameterList) {
            Map<String, Object> map;
            String[] gicNameArr;
            String paramName = parameter.getName();
            if (ignoreSets.contains(paramName) || mappingParams.containsKey(paramName)) continue;
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            String typeName = javaType.getGenericCanonicalName();
            String simpleName = javaType.getValue().toLowerCase();
            String fullTypeName = javaType.getFullyQualifiedName();
            String simpleTypeName = javaType.getValue();
            String commentClass = paramTagMap.get(paramName);
            String rewriteClassName = this.getRewriteClassName(replacementMap, fullTypeName, commentClass);
            if (DocUtil.isClassName(rewriteClassName)) {
                typeName = rewriteClassName;
                fullTypeName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName, builder.getApiConfig().getIgnoreRequestParams())) continue;
            fullTypeName = DocClassUtil.rewriteRequestParam(fullTypeName);
            typeName = DocClassUtil.rewriteRequestParam(typeName);
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            String comment = this.paramCommentResolve(paramTagMap.get(paramName));
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, builder.getJavaProjectBuilder());
            String strRequired = "false";
            boolean isPathVariable = false;
            boolean isRequestBody = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if (JavaClassValidateUtil.ignoreSpringMvcParamWithAnnotation(annotationName)) continue block2;
                if ("RequestParam".equals(annotationName) || "PathVariable".equals(annotationName)) {
                    AnnotationValue annotationDefaultVal;
                    if ("PathVariable".equals(annotationName)) {
                        isPathVariable = true;
                    }
                    if (Objects.nonNull(annotationDefaultVal = annotation.getProperty("defaultValue"))) {
                        mockValue = DocUtil.resolveAnnotationValue(annotationDefaultVal);
                    }
                    paramName = this.getParamName(paramName, annotation);
                    AnnotationValue annotationRequired = annotation.getProperty("required");
                    strRequired = Objects.nonNull(annotationRequired) ? annotationRequired.toString() : "true";
                }
                if (JavaClassValidateUtil.isJSR303Required(annotationName)) {
                    strRequired = "true";
                }
                if (!"RequestBody".equals(annotationName) && !"org.springframework.web.bind.annotation.RequestBody".equals(annotationName)) continue;
                if (requestBodyCounter > 0) {
                    throw new RuntimeException("You have use @RequestBody Passing multiple variables  for method " + javaMethod.getName() + " in " + className + ",@RequestBody annotation could only bind one variables.");
                }
                if (Objects.nonNull(builder.getApiConfig().getRequestBodyAdvice()) && Objects.isNull(javaMethod.getTagByName("ignoreRequestBodyAdvice"))) {
                    String requestBodyAdvice;
                    fullTypeName = requestBodyAdvice = builder.getApiConfig().getRequestBodyAdvice().getClassName();
                    typeName = requestBodyAdvice + "<" + typeName + ">";
                }
                mockValue = JsonBuildHelper.buildJson(fullTypeName, typeName, Boolean.FALSE, 0, new HashMap<String, String>(), groupClasses, builder);
                ++requestBodyCounter;
                isRequestBody = true;
            }
            boolean required = Boolean.parseBoolean(strRequired);
            if (JavaClassValidateUtil.isFile(typeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(required).setVersion("-").setDesc(comment);
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment = comment + "(array of file)";
                    param.setType("file");
                    param.setDesc(comment);
                    param.setHasItems(true);
                }
                paramList.add(param);
                continue;
            }
            boolean queryParam = false;
            if (!isRequestBody && !isPathVariable) {
                queryParam = true;
            }
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                Map<String, Object> map2;
                ApiParam param;
                JavaClass gicJavaClass;
                String gicName;
                if (JavaClassValidateUtil.isCollection(typeName)) {
                    typeName = typeName + "<T>";
                }
                if (JavaClassValidateUtil.isArray(gicName = (gicNameArr = DocClassUtil.getSimpleGicName(typeName))[0])) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (StringUtil.isNotEmpty((String)(mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicName, gicName))) && !mockValue.contains(",")) {
                    mockValue = StringUtils.join((Object[])new String[]{mockValue, ",", JavaFieldUtil.createMockValue(paramsComments, paramName, gicName, gicName)});
                }
                if ((gicJavaClass = builder.getJavaProjectBuilder().getClassByName(gicName)).isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(gicJavaClass, Boolean.TRUE);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of enum]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setEnumValues(JavaClassUtil.getEnumValues(gicJavaClass)).setEnumInfo(JavaClassUtil.getEnumInfo(gicJavaClass, builder)).setType("array").setValue(String.valueOf(value));
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams(gicName);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(mockValue);
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (JavaClassValidateUtil.isFile(gicName)) {
                    ApiParam param2 = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(required).setVersion("-").setHasItems(true).setDesc(comment + "(array of file)");
                    paramList.add(param2);
                    continue;
                }
                if (requestBodyCounter <= 0) continue;
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.TRUE));
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(mockValue).setDesc(comment).setRequired(required).setVersion("-");
                paramList.add(param);
                if (requestBodyCounter <= 0) continue;
                map = OpenApiSchemaUtil.primaryTypeSchema(simpleName);
                docJavaMethod.setRequestSchema(map);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                log.warning("When using smart-doc, it is not recommended to use Map to receive parameters, Check it in " + javaMethod.getDeclaringClass().getCanonicalName() + "#" + javaMethod.getName());
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    map = OpenApiSchemaUtil.mapTypeSchema("object");
                    docJavaMethod.setRequestSchema(map);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                if (JavaClassValidateUtil.isPrimitive(gicNameArr[1])) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    Map<String, Object> map3 = OpenApiSchemaUtil.mapTypeSchema(gicNameArr[1]);
                    docJavaMethod.setRequestSchema(map3);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
                continue;
            }
            if (javaClass.isEnum()) {
                String o = JavaClassUtil.getEnumParams(javaClass);
                Object value = JavaClassUtil.getEnumValue(javaClass, isPathVariable || queryParam);
                ApiParam param = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(String.valueOf(value)).setType("enum").setDesc(StringUtil.removeQuotes((String)o)).setRequired(required).setVersion("-").setEnumInfo(JavaClassUtil.getEnumInfo(javaClass, builder)).setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
        }
        return ApiParamTreeUtil.buildMethodReqParam(paramList, queryReqParamMap, pathReqParamMap, requestBodyCounter);
    }

    private String getParamName(String paramName, JavaAnnotation annotation) {
        String resolvedParamName = DocUtil.resolveAnnotationValue(annotation.getProperty("value"));
        if (StringUtils.isBlank((CharSequence)resolvedParamName)) {
            resolvedParamName = DocUtil.resolveAnnotationValue(annotation.getProperty("name"));
        }
        if (!StringUtils.isBlank((CharSequence)resolvedParamName)) {
            paramName = StringUtil.removeQuotes((String)resolvedParamName);
        }
        return StringUtil.removeQuotes((String)paramName);
    }

    private boolean checkController(JavaClass cls) {
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        JavaClass superClass = cls.getSuperJavaClass();
        ArrayList classAnnotations = new ArrayList();
        if (Objects.nonNull(superClass)) {
            classAnnotations.addAll(superClass.getAnnotations());
        }
        classAnnotations.addAll(cls.getAnnotations());
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getValue();
            if (!"Controller".equals(name) && !"RestController".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"restApi".equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getRewriteClassName(Map<String, String> replacementMap, String fullTypeName, String commentClass) {
        if (Objects.nonNull(commentClass) && !"No comments found.".equals(commentClass)) {
            String[] comments = commentClass.split("\\|");
            if (comments.length < 1) {
                return replacementMap.get(fullTypeName);
            }
            String rewriteClassName = comments[comments.length - 1];
            if (DocUtil.isClassName(rewriteClassName)) {
                return rewriteClassName;
            }
        }
        return replacementMap.get(fullTypeName);
    }

    private List<JavaAnnotation> getAnnotations(JavaClass cls) {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        annotationsList.addAll(cls.getAnnotations());
        boolean flag = annotationsList.stream().anyMatch(item -> {
            String annotationName = item.getType().getValue();
            return "RequestMapping".equals(annotationName) || "org.springframework.web.bind.annotation.RequestMapping".equals(annotationName);
        });
        if (flag) {
            return annotationsList;
        }
        JavaClass superJavaClass = cls.getSuperJavaClass();
        if (Objects.nonNull(superJavaClass) && !"Object".equals(superJavaClass.getSimpleName())) {
            annotationsList.addAll(this.getAnnotations(superJavaClass));
        }
        return annotationsList;
    }
}

