/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiMethodReqParam;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ApiParamTreeUtil {
    public static List<ApiParam> apiParamToTree(List<ApiParam> apiParamList) {
        if (CollectionUtil.isEmpty(apiParamList)) {
            return new ArrayList<ApiParam>(0);
        }
        ArrayList<ApiParam> params = new ArrayList<ApiParam>();
        for (ApiParam apiParam : apiParamList) {
            apiParam.setField(apiParam.getField().replaceAll("\u2514\u2500", "").replaceAll("&nbsp;", ""));
            if (apiParam.getPid() != 0) continue;
            params.add(apiParam);
        }
        for (ApiParam apiParam : params) {
            apiParam.setChildren(ApiParamTreeUtil.getChild(apiParam.getId(), apiParamList, 0));
        }
        return params;
    }

    private static List<ApiParam> getChild(int id, List<ApiParam> apiParamList, int counter) {
        ArrayList<ApiParam> childList = new ArrayList<ApiParam>();
        if (counter > 7) {
            return childList;
        }
        for (ApiParam param : apiParamList) {
            if (param.getPid() != id) continue;
            childList.add(param);
        }
        ++counter;
        for (ApiParam param : childList) {
            param.setChildren(ApiParamTreeUtil.getChild(param.getId(), apiParamList, counter));
        }
        if (childList.size() == 0) {
            return new ArrayList<ApiParam>(0);
        }
        return childList;
    }

    public static ApiMethodReqParam buildMethodReqParam(List<ApiParam> paramList, Map<String, ApiReqParam> queryReqParamMap, Map<String, ApiReqParam> pathReqParamMap, int requestBodyCounter) {
        ArrayList<ApiParam> pathParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> queryParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> bodyParams = new ArrayList<ApiParam>();
        for (ApiParam apiParam : paramList) {
            apiParam.setValue(StringUtil.removeDoubleQuotes((String)apiParam.getValue()));
            if (apiParam.isPathParam()) {
                if (pathReqParamMap.containsKey(apiParam.getField())) {
                    apiParam.setConfigParam(true).setValue(pathReqParamMap.get(apiParam.getField()).getValue());
                }
                apiParam.setId(pathParams.size() + 1);
                pathParams.add(apiParam);
                continue;
            }
            if (apiParam.isQueryParam() || requestBodyCounter < 1) {
                if (queryReqParamMap.containsKey(apiParam.getField())) {
                    apiParam.setConfigParam(true).setValue(queryReqParamMap.get(apiParam.getField()).getValue());
                }
                apiParam.setId(queryParams.size() + 1);
                queryParams.add(apiParam);
                continue;
            }
            apiParam.setId(bodyParams.size() + 1);
            bodyParams.add(apiParam);
        }
        Set queryParamSet = queryParams.stream().map(ApiParam::getField).collect(Collectors.toSet());
        for (ApiReqParam value : queryReqParamMap.values()) {
            if (queryParamSet.contains(value.getName())) continue;
            ApiParam apiParam = ApiReqParam.convertToApiParam(value).setQueryParam(true).setId(queryParams.size() + 1);
            queryParams.add(apiParam);
        }
        Set set = pathParams.stream().map(ApiParam::getField).collect(Collectors.toSet());
        for (ApiReqParam value : pathReqParamMap.values()) {
            if (set.contains(value.getName())) continue;
            ApiParam apiParam = ApiReqParam.convertToApiParam(value).setPathParam(true).setId(pathParams.size() + 1);
            pathParams.add(apiParam);
        }
        return ApiMethodReqParam.builder().setRequestParams(bodyParams).setPathParams(pathParams).setQueryParams(queryParams);
    }
}

