/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocUrlUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SolonRequestMappingHandler {
    public RequestMapping handle(ProjectDocConfigBuilder projectBuilder, String controllerBaseUrl, JavaMethod method, Map<String, String> constantsMap, boolean isRemoting) {
        List annotations = method.getAnnotations();
        String methodType = "GET";
        String shortUrl = null;
        String mediaType = null;
        String serverUrl = projectBuilder.getServerUrl();
        String contextPath = projectBuilder.getApiConfig().getPathPrefix();
        boolean deprecated = false;
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            if ("Deprecated".equals(annotationName)) {
                deprecated = true;
            }
            if ("Mapping".equals(annotationName) || "org.noear.solon.annotation.Mapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                Object produces = annotation.getNamedParameter("produces");
                if (Objects.nonNull(produces)) {
                    mediaType = produces.toString();
                }
            }
            if ("Get".equals(annotationName) || "org.noear.solon.annotation.Get".equals(annotationName)) {
                methodType = Methods.GET.getValue();
                continue;
            }
            if ("Post".equals(annotationName) || "org.noear.solon.annotation.Post".equals(annotationName)) {
                methodType = Methods.POST.getValue();
                continue;
            }
            if ("Put".equals(annotationName) || "org.noear.solon.annotation.Put".equals(annotationName)) {
                methodType = Methods.PUT.getValue();
                continue;
            }
            if ("Patch".equals(annotationName) || "org.noear.solon.annotation.Patch".equals(annotationName)) {
                methodType = Methods.PATCH.getValue();
                continue;
            }
            if (!"Delete".equals(annotationName) && !"org.noear.solon.annotation.Delete".equals(annotationName)) continue;
            methodType = Methods.DELETE.getValue();
        }
        if (isRemoting) {
            methodType = Methods.POST.getValue();
            if (shortUrl == null) {
                shortUrl = method.getName();
            }
            if (mediaType == null) {
                mediaType = "text/json";
            }
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            deprecated = true;
        }
        if (Objects.nonNull(shortUrl)) {
            if (Objects.nonNull(method.getTagByName("ignore"))) {
                return null;
            }
            shortUrl = StringUtil.removeQuotes((String)shortUrl);
            String url = DocUrlUtil.getMvcUrls(serverUrl, contextPath + "/" + controllerBaseUrl, shortUrl);
            shortUrl = DocUrlUtil.getMvcUrls("", contextPath + "/" + controllerBaseUrl, shortUrl);
            String urlSuffix = projectBuilder.getApiConfig().getUrlSuffix();
            if (StringUtil.isNotEmpty((String)urlSuffix)) {
                url = UrlUtil.simplifyUrl((String)StringUtil.trim((String)url)) + urlSuffix;
                shortUrl = UrlUtil.simplifyUrl((String)StringUtil.trim((String)shortUrl)) + urlSuffix;
            } else {
                url = UrlUtil.simplifyUrl((String)StringUtil.trim((String)url));
                shortUrl = UrlUtil.simplifyUrl((String)StringUtil.trim((String)shortUrl));
            }
            return RequestMapping.builder().setMediaType(mediaType).setMethodType(methodType).setUrl(url).setShortUrl(shortUrl).setDeprecated(deprecated);
        }
        return null;
    }
}

