/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocUrlUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpringMVCRequestMappingHandler {
    public RequestMapping handle(ProjectDocConfigBuilder projectBuilder, String controllerBaseUrl, JavaMethod method, Map<String, String> constantsMap) {
        List annotations = method.getAnnotations();
        String methodType = null;
        String shortUrl = null;
        String mediaType = null;
        String serverUrl = projectBuilder.getServerUrl();
        String contextPath = projectBuilder.getApiConfig().getPathPrefix();
        boolean deprecated = false;
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            Object produces = annotation.getNamedParameter("produces");
            if (Objects.nonNull(produces)) {
                mediaType = produces.toString();
            }
            if ("Deprecated".equals(annotationName)) {
                deprecated = true;
            }
            if ("RequestMapping".equals(annotationName) || "org.springframework.web.bind.annotation.RequestMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                Object nameParam = annotation.getNamedParameter("method");
                if (Objects.nonNull(nameParam)) {
                    methodType = nameParam.toString();
                    methodType = DocUtil.handleHttpMethod(methodType);
                    continue;
                }
                methodType = Methods.GET.getValue();
                continue;
            }
            if ("GetMapping".equals(annotationName) || "org.springframework.web.bind.annotation.GetMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                methodType = Methods.GET.getValue();
                continue;
            }
            if ("PostMapping".equals(annotationName) || "org.springframework.web.bind.annotation.PostMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                methodType = Methods.POST.getValue();
                continue;
            }
            if ("PutMapping".equals(annotationName) || "org.springframework.web.bind.annotation.PutMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                methodType = Methods.PUT.getValue();
                continue;
            }
            if ("PatchMapping".equals(annotationName) || "org.springframework.web.bind.annotation.PatchMapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                methodType = Methods.PATCH.getValue();
                continue;
            }
            if (!"DeleteMapping".equals(annotationName) && !"org.springframework.web.bind.annotation.DeleteMapping".equals(annotationName)) continue;
            shortUrl = DocUtil.handleMappingValue(annotation);
            methodType = Methods.DELETE.getValue();
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            deprecated = true;
        }
        if (Objects.nonNull(shortUrl)) {
            if (Objects.nonNull(method.getTagByName("ignore"))) {
                return null;
            }
            shortUrl = StringUtil.removeQuotes(shortUrl);
            String url = DocUrlUtil.getMvcUrls(serverUrl, contextPath + "/" + controllerBaseUrl, shortUrl);
            shortUrl = DocUrlUtil.getMvcUrls("", contextPath + "/" + controllerBaseUrl, shortUrl);
            String urlSuffix = projectBuilder.getApiConfig().getUrlSuffix();
            if (StringUtil.isNotEmpty((String)urlSuffix)) {
                url = UrlUtil.simplifyUrl((String)StringUtil.trim((String)url)) + urlSuffix;
                shortUrl = UrlUtil.simplifyUrl((String)StringUtil.trim((String)shortUrl)) + urlSuffix;
            } else {
                url = UrlUtil.simplifyUrl((String)StringUtil.trim((String)url));
                shortUrl = UrlUtil.simplifyUrl((String)StringUtil.trim((String)shortUrl));
            }
            return RequestMapping.builder().setMediaType(mediaType).setMethodType(methodType).setUrl(url).setShortUrl(shortUrl).setDeprecated(deprecated);
        }
        return null;
    }
}

