/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.BodyAdvice;
import com.power.doc.model.SourceCodePath;
import com.smartdoc.constant.GlobalConstants;
import com.smartdoc.util.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;

public class MojoUtils {
    public static final Gson GSON = new GsonBuilder().addDeserializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }).create();

    public static ApiConfig buildConfig(File configFile, String projectName, MavenProject project, ProjectBuilder projectBuilder, MavenSession mavenSession, List<String> projectArtifacts, Log log) throws MojoExecutionException {
        try {
            ClassLoader classLoader = ClassLoaderUtil.getRuntimeClassLoader(project);
            String data = FileUtil.getFileContent((InputStream)new FileInputStream(configFile));
            ApiConfig apiConfig = (ApiConfig)GSON.fromJson(data, ApiConfig.class);
            if (StringUtil.isEmpty((String)apiConfig.getCodePath())) {
                apiConfig.setCodePath("src/main/java");
            }
            apiConfig.setClassLoader(classLoader);
            List apiDataDictionaries = apiConfig.getDataDictionaries();
            List apiErrorCodes = apiConfig.getErrorCodeDictionaries();
            List apiConstants = apiConfig.getApiConstants();
            BodyAdvice responseBodyAdvice = apiConfig.getResponseBodyAdvice();
            BodyAdvice requestBodyAdvice = apiConfig.getRequestBodyAdvice();
            if (Objects.nonNull(apiErrorCodes)) {
                apiErrorCodes.forEach(apiErrorCode -> {
                    String className = apiErrorCode.getEnumClassName();
                    apiErrorCode.setEnumClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (Objects.nonNull(apiDataDictionaries)) {
                apiDataDictionaries.forEach(apiDataDictionary -> {
                    String className = apiDataDictionary.getEnumClassName();
                    apiDataDictionary.setEnumClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (Objects.nonNull(apiConstants)) {
                apiConstants.forEach(apiConstant -> {
                    String className = apiConstant.getConstantsClassName();
                    apiConstant.setConstantsClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (Objects.nonNull(responseBodyAdvice) && StringUtil.isNotEmpty((String)responseBodyAdvice.getClassName())) {
                responseBodyAdvice.setWrapperClass(MojoUtils.getClassByClassName(responseBodyAdvice.getClassName(), classLoader));
            }
            if (Objects.nonNull(requestBodyAdvice) && StringUtil.isNotEmpty((String)requestBodyAdvice.getClassName())) {
                requestBodyAdvice.setWrapperClass(MojoUtils.getClassByClassName(requestBodyAdvice.getClassName(), classLoader));
            }
            if (StringUtil.isEmpty((String)apiConfig.getProjectName()) && StringUtil.isEmpty((String)projectName)) {
                apiConfig.setProjectName(project.getName());
            } else if (StringUtil.isNotEmpty((String)apiConfig.getProjectName()) && "${project.artifactId}".equals(apiConfig.getProjectName())) {
                apiConfig.setProjectName(project.getArtifactId());
            } else if (StringUtil.isNotEmpty((String)projectName)) {
                apiConfig.setProjectName(projectName);
            }
            MojoUtils.addSourcePaths(project, projectBuilder, mavenSession, apiConfig, projectArtifacts, log);
            return apiConfig;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getClassByClassName(String className, ClassLoader classLoader) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addSourcePaths(MavenProject project, ProjectBuilder projectBuilder, MavenSession mavenSession, ApiConfig apiConfig, List<String> projectArtifacts, Log log) {
        ArrayList<SourceCodePath> sourceCodePaths = new ArrayList<SourceCodePath>();
        HashMap<String, String> modules = new HashMap<String, String>(40);
        MojoUtils.buildModules(project, projectBuilder, mavenSession, modules, apiConfig.getCodePath(), log);
        modules.forEach((key, modulePath) -> projectArtifacts.forEach(artifactName -> {
            if (artifactName.equals(key)) {
                sourceCodePaths.add(SourceCodePath.builder().setPath(modulePath));
            }
        }));
        sourceCodePaths.add(SourceCodePath.builder().setPath(project.getBasedir() + GlobalConstants.FILE_SEPARATOR + apiConfig.getCodePath()));
        SourceCodePath[] codePaths = new SourceCodePath[sourceCodePaths.size()];
        sourceCodePaths.toArray(codePaths);
        log.info((CharSequence)("Artifacts that the current project depends on: " + GSON.toJson(projectArtifacts)));
        log.info((CharSequence)("Smart-doc has loaded the source code path: " + GSON.toJson(sourceCodePaths).replaceAll("\\\\", "/").replaceAll("//", "/")));
        apiConfig.setSourceCodePaths(codePaths);
    }

    private static void buildModules(MavenProject project, ProjectBuilder projectBuilder, MavenSession mavenSession, Map<String, String> moduleList, String codePath, Log log) {
        Map<String, MavenProject> referenceMavenProject = new HashMap<String, MavenProject>(20);
        if (project.getProjectReferences().isEmpty()) {
            referenceMavenProject = MojoUtils.collectProject(project, projectBuilder, mavenSession, log);
        } else {
            MojoUtils.addByProjectReference(referenceMavenProject, project.getProjectReferences());
        }
        for (Map.Entry mavenProject : referenceMavenProject.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)(project.getName() + " references mavenProject is: " + ((MavenProject)mavenProject.getValue()).getName()));
            }
            String artifactId = ((MavenProject)mavenProject.getValue()).getModel().getArtifactId();
            String groupId = ((MavenProject)mavenProject.getValue()).getGroupId();
            moduleList.put(groupId + ":" + artifactId, ((MavenProject)mavenProject.getValue()).getBasedir() + GlobalConstants.FILE_SEPARATOR + codePath);
        }
    }

    public static void addByProjectReference(Map<String, MavenProject> referenceMavenProject, Map<String, MavenProject> sourceProject) {
        if (sourceProject.isEmpty()) {
            return;
        }
        referenceMavenProject.putAll(sourceProject);
        for (Map.Entry<String, MavenProject> map : sourceProject.entrySet()) {
            MojoUtils.addByProjectReference(referenceMavenProject, map.getValue().getProjectReferences());
        }
    }

    public static Map<String, MavenProject> collectProject(MavenProject project, ProjectBuilder projectBuilder, MavenSession session, Log log) {
        HashMap<String, MavenProject> mavenProjects = new HashMap<String, MavenProject>(40);
        ArrayList<String> pomPath = new ArrayList<String>();
        MojoUtils.getPomFilePath(MojoUtils.getRootPath(project, log), pomPath);
        for (String s : pomPath) {
            File pomFile = new File(s);
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            try {
                MavenProject target = projectBuilder.build(pomFile, (ProjectBuildingRequest)request).getProject();
                mavenProjects.put(target.getGroupId() + ":" + target.getArtifactId(), target);
            }
            catch (ProjectBuildingException e) {
                e.printStackTrace();
            }
        }
        return mavenProjects;
    }

    private static void getPomFilePath(File file, List<String> path) {
        File[] fs = file.listFiles();
        assert (fs != null);
        for (File f : fs) {
            if (!f.isDirectory()) {
                if (!f.getPath().endsWith("pom.xml")) continue;
                path.add(f.getPath());
                continue;
            }
            MojoUtils.getPomFilePath(f, path);
        }
    }

    private static File getRootPath(MavenProject project, Log log) {
        if (project.hasParent()) {
            MavenProject mavenProject = project.getParent();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)(project.getName() + " parent is: " + mavenProject.getName()));
            }
            if (null != mavenProject) {
                if (mavenProject.getBasedir() == null) {
                    return project.getBasedir();
                }
                return MojoUtils.getRootPath(mavenProject, log);
            }
            return project.getBasedir();
        }
        return project.getBasedir();
    }
}

