package springfox.documentation.swagger2.mappers;

import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.service.ResourceListing;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2022-01-08T12:57:22+0800",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.12 (Oracle Corporation)"
)
*/
@Component
public class ServiceModelToSwagger2MapperImpl extends ServiceModelToSwagger2Mapper {

    @Autowired
    private CompatibilityModelMapper compatibilityModelMapper;
    @Autowired
    private SecurityMapper securityMapper;
    @Autowired
    private LicenseMapper licenseMapper;
    @Autowired
    private VendorExtensionsMapper vendorExtensionsMapper;

    @Override
    public Swagger mapDocumentation(Documentation from) {
        if ( from == null ) {
            return null;
        }

        Swagger swagger = new Swagger();

        swagger.setVendorExtensions( vendorExtensionsMapper.mapExtensions( from.getVendorExtensions() ) );
        swagger.setSchemes( mapSchemes( from.getSchemes() ) );
        swagger.setPaths( mapApiListings( from.getApiListings() ) );
        swagger.setHost( from.getHost() );
        swagger.setDefinitions( compatibilityModelMapper.modelsFromApiListings( from.getApiListings() ) );
        swagger.setSecurityDefinitions( securityMapper.toSecuritySchemeDefinitions( from.getResourceListing() ) );
        swagger.setInfo( mapApiInfo( fromResourceListingInfo( from ) ) );
        swagger.setBasePath( from.getBasePath() );
        swagger.setTags( tagSetToTagList( from.getTags() ) );
        List<String> list2 = from.getConsumes();
        if ( list2 != null ) {
            swagger.setConsumes( new ArrayList<String>( list2 ) );
        }
        List<String> list3 = from.getProduces();
        if ( list3 != null ) {
            swagger.setProduces( new ArrayList<String>( list3 ) );
        }

        return swagger;
    }

    @Override
    protected Info mapApiInfo(ApiInfo from) {
        if ( from == null ) {
            return null;
        }

        Info info = new Info();

        info.setLicense( licenseMapper.apiInfoToLicense( from ) );
        info.setVendorExtensions( vendorExtensionsMapper.mapExtensions( from.getVendorExtensions() ) );
        info.setTermsOfService( from.getTermsOfServiceUrl() );
        info.setContact( map( from.getContact() ) );
        info.setVersion( from.getVersion() );
        info.setTitle( from.getTitle() );
        info.setDescription( from.getDescription() );

        return info;
    }

    @Override
    protected io.swagger.models.Contact map(Contact from) {
        if ( from == null ) {
            return null;
        }

        io.swagger.models.Contact contact = new io.swagger.models.Contact();

        contact.setName( from.getName() );
        contact.setUrl( from.getUrl() );
        contact.setEmail( from.getEmail() );

        return contact;
    }

    @Override
    protected Operation mapOperation(springfox.documentation.service.Operation from, ModelNamesRegistry modelNames) {
        if ( from == null ) {
            return null;
        }

        Operation operation = new Operation();

        beforeMappingOperations( operation, from, modelNames );

        operation.vendorExtensions( vendorExtensionsMapper.mapExtensions( from.getVendorExtensions() ) );
        operation.setDescription( from.getNotes() );
        operation.setSchemes( stringSetToSchemeList( from.getProtocol(), modelNames ) );
        operation.setSecurity( mapAuthorizations( from.getSecurityReferences() ) );
        operation.setOperationId( from.getUniqueId() );
        operation.setSummary( from.getSummary() );
        Set<String> set = from.getConsumes();
        if ( set != null ) {
            operation.setConsumes( new ArrayList<String>( set ) );
        }
        Set<String> set1 = from.getProduces();
        if ( set1 != null ) {
            operation.setProduces( new ArrayList<String>( set1 ) );
        }
        Set<String> set2 = from.getTags();
        if ( set2 != null ) {
            operation.setTags( new ArrayList<String>( set2 ) );
        }
        if ( from.getDeprecated() != null ) {
            operation.setDeprecated( Boolean.parseBoolean( from.getDeprecated() ) );
        }

        return operation;
    }

    @Override
    protected Tag mapTag(springfox.documentation.service.Tag from) {
        if ( from == null ) {
            return null;
        }

        Tag tag = new Tag();

        tag.setVendorExtensions( vendorExtensionsMapper.mapExtensions( from.getVendorExtensions() ) );
        tag.setName( from.getName() );
        tag.setDescription( from.getDescription() );

        return tag;
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {
        if ( documentation == null ) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if ( resourceListing == null ) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        if ( info == null ) {
            return null;
        }
        return info;
    }

    protected List<Tag> tagSetToTagList(Set<springfox.documentation.service.Tag> set) {
        if ( set == null ) {
            return null;
        }

        List<Tag> list = new ArrayList<Tag>( set.size() );
        for ( springfox.documentation.service.Tag tag : set ) {
            list.add( mapTag( tag ) );
        }

        return list;
    }

    protected List<Scheme> stringSetToSchemeList(Set<String> set, ModelNamesRegistry modelNames) {
        if ( set == null ) {
            return null;
        }

        List<Scheme> list = new ArrayList<Scheme>( set.size() );
        for ( String string : set ) {
            list.add( Enum.valueOf( Scheme.class, string ) );
        }

        return list;
    }
}
