/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefanbirkner.fakesftpserver.rule;

import com.github.marschall.memoryfilesystem.MemoryFileSystemBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class FakeSftpServerRule
implements TestRule {
    private static final SimpleFileVisitor<Path> DELETE_FILES_AND_DIRECTORIES = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (dir.getParent() != null) {
                Files.delete(dir);
            }
            return super.postVisitDirectory(dir, exc);
        }
    };
    private final Map<String, String> usernamesAndPasswords = new HashMap<String, String>();
    private int port = 0;
    private FileSystem fileSystem;
    private SshServer server;

    public int getPort() {
        if (this.port == 0) {
            return this.getPortFromServer();
        }
        return this.port;
    }

    private int getPortFromServer() {
        this.verifyThatTestIsRunning("call getPort()");
        return this.server.getPort();
    }

    public FakeSftpServerRule setPort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port cannot be set to " + port + " because only ports between 1 and 65535 are valid.");
        }
        this.port = port;
        if (this.server != null) {
            this.restartServer();
        }
        return this;
    }

    public FakeSftpServerRule addUser(String username, String password) {
        this.usernamesAndPasswords.put(username, password);
        return this;
    }

    private void restartServer() {
        try {
            this.server.stop();
            this.startServer(this.fileSystem);
        }
        catch (IOException e) {
            throw new IllegalStateException("The SFTP server cannot be restarted.", e);
        }
    }

    public void putFile(String path, String content, Charset encoding) throws IOException {
        byte[] contentAsBytes = content.getBytes(encoding);
        this.putFile(path, contentAsBytes);
    }

    public void putFile(String path, byte[] content) throws IOException {
        this.verifyThatTestIsRunning("upload file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        this.ensureDirectoryOfPathExists(pathAsObject);
        Files.write(pathAsObject, content, new OpenOption[0]);
    }

    public void putFile(String path, InputStream is) throws IOException {
        this.verifyThatTestIsRunning("upload file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        this.ensureDirectoryOfPathExists(pathAsObject);
        Files.copy(is, pathAsObject, new CopyOption[0]);
    }

    public void createDirectory(String path) throws IOException {
        this.verifyThatTestIsRunning("create directory");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        Files.createDirectories(pathAsObject, new FileAttribute[0]);
    }

    public void createDirectories(String ... paths) throws IOException {
        for (String path : paths) {
            this.createDirectory(path);
        }
    }

    public String getFileContent(String path, Charset encoding) throws IOException {
        byte[] content = this.getFileContent(path);
        return new String(content, encoding);
    }

    public byte[] getFileContent(String path) throws IOException {
        this.verifyThatTestIsRunning("download file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        return Files.readAllBytes(pathAsObject);
    }

    public boolean existsFile(String path) {
        this.verifyThatTestIsRunning("check existence of file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        return Files.exists(pathAsObject, new LinkOption[0]) && !Files.isDirectory(pathAsObject, new LinkOption[0]);
    }

    public void deleteAllFilesAndDirectories() throws IOException {
        for (Path directory : this.fileSystem.getRootDirectories()) {
            Files.walkFileTree(directory, DELETE_FILES_AND_DIRECTORIES);
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try (FileSystem fileSystem = FakeSftpServerRule.this.createFileSystem();){
                    FakeSftpServerRule.this.startServer(fileSystem);
                    try {
                        base.evaluate();
                    }
                    finally {
                        FakeSftpServerRule.this.server.stop();
                        FakeSftpServerRule.this.server = null;
                    }
                }
                finally {
                    FakeSftpServerRule.this.fileSystem = null;
                }
            }
        };
    }

    private FileSystem createFileSystem() throws IOException {
        this.fileSystem = MemoryFileSystemBuilder.newLinux().build("FakeSftpServerRule@" + this.hashCode());
        return this.fileSystem;
    }

    private SshServer startServer(FileSystem fileSystem) throws IOException {
        SshServer server = SshServer.setUpDefaultServer();
        server.setPort(this.port);
        server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        server.setPasswordAuthenticator(this::authenticate);
        server.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        server.setFileSystemFactory(session -> new DoNotClose(fileSystem));
        server.start();
        this.server = server;
        return server;
    }

    private boolean authenticate(String username, String password, ServerSession session) {
        return this.usernamesAndPasswords.isEmpty() || Objects.equals(this.usernamesAndPasswords.get(username), password);
    }

    private void ensureDirectoryOfPathExists(Path path) throws IOException {
        Path directory = path.getParent();
        if (directory != null && !directory.equals(path.getRoot())) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    private void verifyThatTestIsRunning(String mode) {
        if (this.fileSystem == null) {
            throw new IllegalStateException("Failed to " + mode + " because test has not been started or is already finished.");
        }
    }

    private static class DoNotClose
    extends FileSystem {
        final FileSystem fileSystem;

        DoNotClose(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public FileSystemProvider provider() {
            return this.fileSystem.provider();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isOpen() {
            return this.fileSystem.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.fileSystem.isReadOnly();
        }

        @Override
        public String getSeparator() {
            return this.fileSystem.getSeparator();
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return this.fileSystem.getRootDirectories();
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return this.fileSystem.getFileStores();
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return this.fileSystem.supportedFileAttributeViews();
        }

        @Override
        public Path getPath(String first, String ... more) {
            return this.fileSystem.getPath(first, more);
        }

        @Override
        public PathMatcher getPathMatcher(String syntaxAndPattern) {
            return this.fileSystem.getPathMatcher(syntaxAndPattern);
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return this.fileSystem.getUserPrincipalLookupService();
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return this.fileSystem.newWatchService();
        }
    }
}

