/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import jetbrick.util.ArrayUtils;

public final class TypeResolverUtils {
    public static Class<?> getRawType(Type type) {
        return TypeResolverUtils.getRawType(type, null);
    }

    public static Class<?> getRawType(Type type, Class<?> implClass) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return TypeResolverUtils.getRawType(pType.getRawType(), implClass);
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            Type[] lowerTypes = wType.getLowerBounds();
            if (lowerTypes.length > 0) {
                return TypeResolverUtils.getRawType(lowerTypes[0], implClass);
            }
            Type[] upperTypes = wType.getUpperBounds();
            if (upperTypes.length != 0) {
                return TypeResolverUtils.getRawType(upperTypes[0], implClass);
            }
            return Object.class;
        }
        if (type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> rawType = TypeResolverUtils.getRawType(genericComponentType, implClass);
            return Array.newInstance(rawType, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            Type resolvedType;
            TypeVariable varType = (TypeVariable)type;
            if (implClass != null && (resolvedType = TypeResolverUtils.resolveVariable(varType, implClass)) != null) {
                return TypeResolverUtils.getRawType(resolvedType, null);
            }
            Type[] boundsTypes = varType.getBounds();
            if (boundsTypes.length == 0) {
                return Object.class;
            }
            return TypeResolverUtils.getRawType(boundsTypes[0], implClass);
        }
        return null;
    }

    public static Type resolveVariable(TypeVariable<?> variable, Class<?> implClass) {
        Class<?> rawType = TypeResolverUtils.getRawType(implClass, null);
        int index = ArrayUtils.indexOf(rawType.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] interfaces = rawType.getInterfaces();
        Type[] genericInterfaces = rawType.getGenericInterfaces();
        for (int i = 0; i <= interfaces.length; ++i) {
            Type type;
            Class<?> rawInterface;
            if (i < interfaces.length) {
                rawInterface = interfaces[i];
            } else {
                rawInterface = rawType.getSuperclass();
                if (rawInterface == null) continue;
            }
            Type resolved = TypeResolverUtils.resolveVariable(variable, rawInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtils.indexOf(rawInterface.getTypeParameters(), typeVariable);
            if (index < 0) {
                throw new IllegalArgumentException("Can't resolve type variable:" + typeVariable);
            }
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : rawType.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[index];
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return null;
    }

    public static Class<?> getComponentType(Type type) {
        return TypeResolverUtils.getComponentType(type, null, -1);
    }

    public static Class<?> getComponentType(Type type, Class<?> implClass) {
        return TypeResolverUtils.getComponentType(type, implClass, -1);
    }

    public static Class<?> getComponentType(Type type, int index) {
        return TypeResolverUtils.getComponentType(type, null, index);
    }

    public static Class<?> getComponentType(Type type, Class<?> implClass, int index) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] generics = pt.getActualTypeArguments();
            if (index < 0) {
                index = generics.length + index;
            }
            if (index < generics.length) {
                return TypeResolverUtils.getRawType(generics[index], implClass);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return TypeResolverUtils.getRawType(gat.getGenericComponentType(), implClass);
        }
        return null;
    }

    public static Class<?> getGenericSupertype(Class<?> type) {
        return TypeResolverUtils.getComponentType(type.getGenericSuperclass());
    }

    public static Class<?> getGenericSupertype(Class<?> type, int index) {
        return TypeResolverUtils.getComponentType(type.getGenericSuperclass(), null, index);
    }
}

