/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection.bidimap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import jetbrick.collection.bidimap.BidiMap;

abstract class AbstractBidiMap<K, V>
implements BidiMap<K, V> {
    final transient Map<K, V> normalMap;
    final transient Map<V, K> reverseMap;
    transient BidiMap<V, K> inverseBidiMap;

    protected AbstractBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap, BidiMap<V, K> inverseBidiMap) {
        this.normalMap = normalMap;
        this.reverseMap = reverseMap;
        this.inverseBidiMap = inverseBidiMap;
    }

    protected abstract BidiMap<V, K> createBidiMap(Map<V, K> var1, Map<K, V> var2, BidiMap<K, V> var3);

    @Override
    public V get(Object key) {
        return this.normalMap.get(key);
    }

    @Override
    public K getKey(Object value) {
        return this.reverseMap.get(value);
    }

    @Override
    public int size() {
        return this.normalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.normalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.normalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.reverseMap.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.normalMap.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.normalMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.normalMap.values();
    }

    @Override
    public V put(K key, V value) {
        if (this.normalMap.containsKey(key)) {
            this.reverseMap.remove(this.normalMap.get(key));
        }
        if (this.reverseMap.containsKey(value)) {
            this.normalMap.remove(this.reverseMap.get(value));
        }
        V obj = this.normalMap.put(key, value);
        this.reverseMap.put(value, key);
        return obj;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V value = null;
        if (this.normalMap.containsKey(key)) {
            value = this.normalMap.remove(key);
            this.reverseMap.remove(value);
        }
        return value;
    }

    @Override
    public K removeValue(Object value) {
        K key = null;
        if (this.reverseMap.containsKey(value)) {
            key = this.reverseMap.remove(value);
            this.normalMap.remove(key);
        }
        return key;
    }

    @Override
    public void clear() {
        this.normalMap.clear();
        this.reverseMap.clear();
    }

    @Override
    public BidiMap<V, K> inverse() {
        if (this.inverseBidiMap == null) {
            this.inverseBidiMap = this.createBidiMap(this.reverseMap, this.normalMap, this);
        }
        return this.inverseBidiMap;
    }

    @Override
    public boolean equals(Object obj) {
        return this.normalMap.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.normalMap.hashCode();
    }

    public String toString() {
        return this.normalMap.toString();
    }
}

