/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LoopIterator
implements Iterator<Integer> {
    private final int start;
    private final int step;
    private final int stop;
    private int current;

    public LoopIterator(int start, int stop) {
        this(start, stop, 1);
    }

    public LoopIterator(int start, int stop, int step) {
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.current = start;
    }

    @Override
    public boolean hasNext() {
        if (this.step > 0) {
            return this.current <= this.stop;
        }
        return this.current >= this.stop;
    }

    @Override
    public Integer next() {
        if (this.hasNext()) {
            int next = this.current;
            this.current += this.step;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return (this.stop - this.start + this.step) / this.step;
    }
}

