/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class ByteConvertor
implements Convertor<Byte> {
    public static final ByteConvertor INSTANCE = new ByteConvertor();

    @Override
    public Byte convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, Byte.class, e);
        }
    }

    @Override
    public Byte convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Byte.class) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return this.convert(value.toString());
    }
}

