/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jetbrick.collection.ListUtils;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.ArrayConvertor;
import jetbrick.util.StringUtils;

public final class ListConvertor<T>
implements Convertor<List<T>> {
    private final Class<T> elementType;
    private final Convertor<T> elementConvertor;

    public ListConvertor(Class<T> elementType, Convertor<T> elementConvertor) {
        this.elementType = elementType;
        this.elementConvertor = elementConvertor;
    }

    @Override
    public List<T> convert(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        String[] values = StringUtils.split(value.toString(), ',');
        return this.convertToList(Arrays.asList(values));
    }

    @Override
    public List<T> convert(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Iterable) {
            List results = ListUtils.asList((Iterable)value);
            return this.convertToList(results);
        }
        if (value instanceof Iterator) {
            List results = ListUtils.asList((Iterator)value);
            return this.convertToList(results);
        }
        if (value instanceof Enumeration) {
            List results = ListUtils.asList((Enumeration)value);
            return this.convertToList(results);
        }
        if (value.getClass().isArray()) {
            Object[] arrays = ArrayConvertor.toObjectArray(value);
            return this.convertToList(Arrays.asList(arrays));
        }
        return this.convert(value.toString());
    }

    private List<T> convertToList(List items) {
        int length = items.size();
        if (length == 0) {
            return Collections.emptyList();
        }
        ListIterator it = items.listIterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (this.elementType.isInstance(value)) continue;
            value = this.elementConvertor.convert(value);
            it.set(value);
        }
        return items;
    }
}

