/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.time.LocalDate;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.DateConvertor;

public final class LocalDateConvertor
implements Convertor<LocalDate> {
    public static final LocalDateConvertor INSTANCE = new LocalDateConvertor();

    @Override
    public LocalDate convert(String value) {
        if (value == null) {
            return null;
        }
        long milliseconds = DateConvertor.toMilliseconds(value, LocalDate.class);
        return LocalDateConvertor.convertToLocalDate(milliseconds);
    }

    @Override
    public LocalDate convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        long milliseconds = DateConvertor.toMilliseconds(value, LocalDate.class);
        return LocalDateConvertor.convertToLocalDate(milliseconds);
    }

    private static LocalDate convertToLocalDate(long milliseconds) {
        long days = Math.floorDiv(milliseconds, 86400000L);
        return LocalDate.ofEpochDay(days);
    }
}

