/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.DateConvertor;

public final class LocalDateTimeConvertor
implements Convertor<LocalDateTime> {
    public static final LocalDateTimeConvertor INSTANCE = new LocalDateTimeConvertor();

    @Override
    public LocalDateTime convert(String value) {
        if (value == null) {
            return null;
        }
        long milliseconds = DateConvertor.toMilliseconds(value, LocalDateTime.class);
        return LocalDateTimeConvertor.convertToLocalDateTime(milliseconds);
    }

    @Override
    public LocalDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        long milliseconds = DateConvertor.toMilliseconds(value, LocalDateTime.class);
        return LocalDateTimeConvertor.convertToLocalDateTime(milliseconds);
    }

    private static LocalDateTime convertToLocalDateTime(long milliseconds) {
        long days = Math.floorDiv(milliseconds, 86400000L);
        int ms = (int)Math.floorMod(milliseconds, 86400000L);
        LocalDate date = LocalDate.ofEpochDay(days);
        LocalTime time = LocalTime.ofNanoOfDay(ms * 1000 * 1000);
        return LocalDateTime.of(date, time);
    }
}

