/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.MethodInfo;
import jetbrick.util.ExceptionUtils;
import jetbrick.util.StringEscapeUtils;

public final class JSONUtils {
    public static String toJSONString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Number) {
            return ((Number)object).toString();
        }
        if (object instanceof Boolean) {
            return ((Boolean)object).toString();
        }
        if (object instanceof CharSequence) {
            return JSONUtils.stringToJSONString(object.toString());
        }
        if (object instanceof Date) {
            return JSONUtils.dateToJSONString((Date)object);
        }
        if (object instanceof Iterable) {
            return JSONUtils.iteratorToJSONString(((Iterable)object).iterator());
        }
        if (object instanceof Map) {
            return JSONUtils.mapToJSONString((Map)object);
        }
        if (object.getClass().isArray()) {
            return JSONUtils.iteratorToJSONString(Arrays.asList((Object[])object).iterator());
        }
        if (object instanceof Enumeration) {
            return JSONUtils.iteratorToJSONString(Collections.list((Enumeration)object).iterator());
        }
        if (object instanceof Iterator) {
            return JSONUtils.iteratorToJSONString((Iterator)object);
        }
        if (object instanceof Character) {
            return JSONUtils.stringToJSONString(object.toString());
        }
        return JSONUtils.beanToJSONString(object);
    }

    private static String stringToJSONString(String str) {
        return '\"' + StringEscapeUtils.escapeJavaScript(str) + '\"';
    }

    private static String dateToJSONString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return JSONUtils.stringToJSONString(dateFormat.format(date));
    }

    private static String iteratorToJSONString(Iterator<?> it) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        while (it.hasNext()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(JSONUtils.toJSONString(it.next()));
        }
        sb.append(']');
        return sb.toString();
    }

    private static String mapToJSONString(Map<?, ?> map) {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(JSONUtils.stringToJSONString(entry.getKey().toString()));
            sb.append(':');
            sb.append(JSONUtils.toJSONString(entry.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    private static String beanToJSONString(Object bean) {
        try {
            KlassInfo klass = KlassInfo.create(bean.getClass());
            MethodInfo method = klass.getMethod("toJSONString", new Class[0]);
            if (method == null) {
                return JSONUtils.stringToJSONString(bean.toString());
            }
            Object result = method.invoke(bean, new Object[0]);
            return result == null ? "null" : result.toString();
        }
        catch (Exception e) {
            throw ExceptionUtils.unchecked(e);
        }
    }
}

