/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import jetbrick.io.IoUtils;
import jetbrick.io.stream.UnsafeByteArrayOutputStream;
import jetbrick.util.SystemUtils;

public final class ShellUtils {
    public static Result shell(String command) {
        return ShellUtils.shell(command, null, null);
    }

    public static Result shell(String command, File directory, Map<String, String> envp) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return ShellUtils.execute(directory, envp, "cmd.exe", "/c", command);
        }
        return ShellUtils.execute(directory, envp, "/bin/sh", "-c", command);
    }

    public static Result execute(String ... command) {
        return ShellUtils.execute(null, null, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result execute(File directory, Map<String, String> envp, String ... command) {
        ProcessBuilder pb = new ProcessBuilder(command);
        if (directory != null) {
            pb.directory(directory);
        }
        if (envp != null) {
            pb.environment().putAll(envp);
        }
        Result result = new Result();
        Process p = null;
        try {
            p = pb.start();
            new InputStreamReadThread("shell-exec-stdout", p.getInputStream(), result.stdout).start();
            new InputStreamReadThread("shell-exec-stderr", p.getErrorStream(), result.stderr).start();
            p.waitFor();
            result.exitValue = p.exitValue();
        }
        catch (Exception e) {
            result.error = e;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return result;
    }

    static final class InputStreamReadThread
    extends Thread {
        final InputStream is;
        final OutputStream os;

        InputStreamReadThread(String name, InputStream is, OutputStream os) {
            super(name);
            this.setDaemon(true);
            this.is = is;
            this.os = os;
        }

        @Override
        public void run() {
            try {
                int n = this.is.read();
                while (n > -1) {
                    this.os.write(n);
                    n = this.is.read();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IoUtils.closeQuietly(this.is);
            }
        }
    }

    public static final class Result {
        int exitValue = -99;
        UnsafeByteArrayOutputStream stdout = new UnsafeByteArrayOutputStream();
        UnsafeByteArrayOutputStream stderr = new UnsafeByteArrayOutputStream();
        Exception error;

        public boolean success() {
            return this.error == null && this.exitValue == 0;
        }

        public int exitValue() {
            return this.exitValue;
        }

        public String stdout() {
            return this.stdout.toString();
        }

        public String stdout(String charsetName) {
            try {
                return this.stdout.toString(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public String stderr() {
            return this.stderr.toString();
        }

        public String stderr(String charsetName) {
            try {
                return this.stderr.toString(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public Exception getException() {
            return this.error;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("exitValue: ").append(this.exitValue).append('\n');
            sb.append("stdout: ").append(this.stdout()).append('\n');
            sb.append("stderr: ").append(this.stderr()).append('\n');
            sb.append("error: ").append(this.error).append('\n');
            return sb.toString();
        }

        public String toString(String charsetName) {
            StringBuilder sb = new StringBuilder();
            sb.append("exitValue: ").append(this.exitValue).append('\n');
            sb.append("stdout: ").append(this.stdout(charsetName)).append('\n');
            sb.append("stderr: ").append(this.stderr(charsetName)).append('\n');
            sb.append("error: ").append(this.error).append('\n');
            return sb.toString();
        }
    }
}

