/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util.builder;

import java.util.Comparator;

public final class CompareToBuilder {
    private int result = 0;

    public CompareToBuilder append(Object lhs, Object rhs) {
        return this.append(lhs, rhs, null);
    }

    public CompareToBuilder append(Object lhs, Object rhs, Comparator<?> comparator) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.getClass().isArray()) {
            if (lhs instanceof long[]) {
                this.append((long[])lhs, (long[])rhs);
            } else if (lhs instanceof int[]) {
                this.append((int[])lhs, (int[])rhs);
            } else if (lhs instanceof short[]) {
                this.append((short[])lhs, (short[])rhs);
            } else if (lhs instanceof char[]) {
                this.append((char[])lhs, (char[])rhs);
            } else if (lhs instanceof byte[]) {
                this.append((byte[])lhs, (byte[])rhs);
            } else if (lhs instanceof double[]) {
                this.append((double[])lhs, (double[])rhs);
            } else if (lhs instanceof float[]) {
                this.append((float[])lhs, (float[])rhs);
            } else if (lhs instanceof boolean[]) {
                this.append((boolean[])lhs, (boolean[])rhs);
            } else {
                this.append((Object[])lhs, (Object[])rhs, comparator);
            }
        } else if (comparator == null) {
            Comparable comparable = (Comparable)lhs;
            this.result = comparable.compareTo(rhs);
        } else {
            Comparator<?> comparator2 = comparator;
            this.result = comparator2.compare(lhs, rhs);
        }
        return this;
    }

    public CompareToBuilder append(long lhs, long rhs) {
        if (this.result != 0) {
            return this;
        }
        this.result = lhs > rhs ? 1 : (lhs < rhs ? -1 : 0);
        return this;
    }

    public CompareToBuilder append(int lhs, int rhs) {
        if (this.result != 0) {
            return this;
        }
        this.result = lhs > rhs ? 1 : (lhs < rhs ? -1 : 0);
        return this;
    }

    public CompareToBuilder append(short lhs, short rhs) {
        if (this.result != 0) {
            return this;
        }
        this.result = lhs > rhs ? 1 : (lhs < rhs ? -1 : 0);
        return this;
    }

    public CompareToBuilder append(char lhs, char rhs) {
        if (this.result != 0) {
            return this;
        }
        this.result = lhs > rhs ? 1 : (lhs < rhs ? -1 : 0);
        return this;
    }

    public CompareToBuilder append(byte lhs, byte rhs) {
        if (this.result != 0) {
            return this;
        }
        this.result = lhs > rhs ? 1 : (lhs < rhs ? -1 : 0);
        return this;
    }

    public CompareToBuilder append(double lhs, double rhs) {
        if (this.result != 0) {
            return this;
        }
        this.result = Double.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(float lhs, float rhs) {
        if (this.result != 0) {
            return this;
        }
        this.result = Float.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(boolean lhs, boolean rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        this.result = !lhs ? -1 : 1;
        return this;
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs) {
        return this.append(lhs, rhs, (Comparator<?>)null);
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs, Comparator<?> comparator) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i], comparator);
        }
        return this;
    }

    public CompareToBuilder append(long[] lhs, long[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(int[] lhs, int[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(short[] lhs, short[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(char[] lhs, char[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(byte[] lhs, byte[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(double[] lhs, double[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(float[] lhs, float[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(boolean[] lhs, boolean[] rhs) {
        if (this.result != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.result = -1;
            return this;
        }
        if (rhs == null) {
            this.result = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public int toComparison() {
        return this.result;
    }
}

