/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util.builder;

public final class EqualsBuilder {
    private boolean result = true;

    public EqualsBuilder append(Object lhs, Object rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (!lhs.getClass().isArray()) {
            this.result = lhs.equals(rhs);
        } else if (lhs.getClass() != rhs.getClass()) {
            this.result = false;
        } else if (lhs instanceof long[]) {
            this.append((long[])lhs, (long[])rhs);
        } else if (lhs instanceof int[]) {
            this.append((int[])lhs, (int[])rhs);
        } else if (lhs instanceof short[]) {
            this.append((short[])lhs, (short[])rhs);
        } else if (lhs instanceof char[]) {
            this.append((char[])lhs, (char[])rhs);
        } else if (lhs instanceof byte[]) {
            this.append((byte[])lhs, (byte[])rhs);
        } else if (lhs instanceof double[]) {
            this.append((double[])lhs, (double[])rhs);
        } else if (lhs instanceof float[]) {
            this.append((float[])lhs, (float[])rhs);
        } else if (lhs instanceof boolean[]) {
            this.append((boolean[])lhs, (boolean[])rhs);
        } else {
            this.append((Object[])lhs, (Object[])rhs);
        }
        return this;
    }

    public EqualsBuilder append(long lhs, long rhs) {
        if (!this.result) {
            return this;
        }
        this.result = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(int lhs, int rhs) {
        if (!this.result) {
            return this;
        }
        this.result = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(short lhs, short rhs) {
        if (!this.result) {
            return this;
        }
        this.result = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(char lhs, char rhs) {
        if (!this.result) {
            return this;
        }
        this.result = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(byte lhs, byte rhs) {
        if (!this.result) {
            return this;
        }
        this.result = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(double lhs, double rhs) {
        if (!this.result) {
            return this;
        }
        return this.append(Double.doubleToLongBits(lhs), Double.doubleToLongBits(rhs));
    }

    public EqualsBuilder append(float lhs, float rhs) {
        if (!this.result) {
            return this;
        }
        return this.append(Float.floatToIntBits(lhs), Float.floatToIntBits(rhs));
    }

    public EqualsBuilder append(boolean lhs, boolean rhs) {
        if (!this.result) {
            return this;
        }
        this.result = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(Object[] lhs, Object[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(long[] lhs, long[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(int[] lhs, int[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(short[] lhs, short[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(char[] lhs, char[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(byte[] lhs, byte[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(double[] lhs, double[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(float[] lhs, float[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public EqualsBuilder append(boolean[] lhs, boolean[] rhs) {
        if (!this.result) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.result = false;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.result = false;
            return this;
        }
        for (int i = 0; i < lhs.length && this.result; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public boolean isEquals() {
        return this.result;
    }
}

