/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.web.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.template.JetEngine;
import jetbrick.template.JetTemplate;
import jetbrick.template.web.JetWebContext;
import jetbrick.template.web.JetWebEngine;
import jetbrick.web.servlet.RequestUtils;

public final class JetTemplateFilter
implements Filter {
    private JetEngine engine;
    private String charsetEncoding;

    public void init(FilterConfig fc) throws ServletException {
        this.engine = JetWebEngine.create(fc.getServletContext());
        this.charsetEncoding = this.engine.getConfig().getOutputEncoding().name();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        response.setCharacterEncoding(this.charsetEncoding);
        if (response.getContentType() == null) {
            response.setContentType("text/html; charset=" + this.charsetEncoding);
        }
        String path = RequestUtils.getPathInfo((HttpServletRequest)request);
        try {
            JetTemplate template = this.engine.getTemplate(path);
            JetWebContext context = new JetWebContext(request, response);
            template.render((Map)context, (OutputStream)response.getOutputStream());
        }
        catch (ResourceNotFoundException e) {
            response.sendError(404, "Template not found: " + path);
        }
    }

    public void destroy() {
    }
}

