/*
 * Decompiled with CFR 0.152.
 */
package com.tls.tls_sigature;

import com.tls.base64_url.base64_url;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONObject;

public class tls_sigature {
    @Deprecated
    public static GenTLSSignatureResult GenTLSSignature(long expire, String strAppid3rd, long skdAppid, String identifier, long accountType, String privStr) {
        PrivateKey privKeyStruct;
        GenTLSSignatureResult result = new GenTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        CharArrayReader reader = new CharArrayReader(privStr.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PEMParser parser = new PEMParser((Reader)reader);
        try {
            Object obj = parser.readObject();
            parser.close();
            privKeyStruct = converter.getPrivateKey((PrivateKeyInfo)obj);
        }
        catch (IOException e) {
            result.errMessage = "read pem error:" + e.getMessage();
            return result;
        }
        String jsonString = "{\"TLS.account_type\":\"" + accountType + "\",\"TLS.identifier\":\"" + identifier + "\",\"TLS.appid_at_3rd\":\"" + strAppid3rd + "\",\"TLS.sdk_appid\":\"" + skdAppid + "\",\"TLS.expire_after\":\"" + expire + "\"}";
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String SerialString = "TLS.appid_at_3rd:" + strAppid3rd + "\nTLS.account_type:" + accountType + "\nTLS.identifier:" + identifier + "\nTLS.sdk_appid:" + skdAppid + "\nTLS.time:" + time + "\nTLS.expire_after:" + expire + "\n";
        try {
            Signature signature = Signature.getInstance("SHA256withECDSA", "BC");
            signature.initSign(privKeyStruct);
            signature.update(SerialString.getBytes(Charset.forName("UTF-8")));
            byte[] signatureBytes = signature.sign();
            String sigTLS = Base64.toBase64String((byte[])signatureBytes);
            JSONObject jsonObject = new JSONObject(jsonString);
            jsonObject.put("TLS.sig", (Object)sigTLS);
            jsonObject.put("TLS.time", (Object)time);
            jsonString = jsonObject.toString();
            Deflater compresser = new Deflater();
            compresser.setInput(jsonString.getBytes(Charset.forName("UTF-8")));
            compresser.finish();
            byte[] compressBytes = new byte[512];
            int compressBytesLength = compresser.deflate(compressBytes);
            compresser.end();
            result.urlSig = new String(base64_url.base64EncodeUrl(Arrays.copyOfRange((byte[])compressBytes, (int)0, (int)compressBytesLength)));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.errMessage = e.getMessage();
        }
        return result;
    }

    @Deprecated
    public static CheckTLSSignatureResult CheckTLSSignature(String urlSig, String strAppid3rd, long skdAppid, String identifier, long accountType, String publicKey) {
        int decompressLength;
        CheckTLSSignatureResult result = new CheckTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] compressBytes = base64_url.base64DecodeUrl(urlSig.getBytes(Charset.forName("UTF-8")));
        Inflater decompression = new Inflater();
        decompression.setInput(compressBytes, 0, compressBytes.length);
        byte[] decompressBytes = new byte[1024];
        try {
            decompressLength = decompression.inflate(decompressBytes);
        }
        catch (DataFormatException e) {
            result.errMessage = "uncompress data error:" + e.getMessage();
            return result;
        }
        decompression.end();
        String jsonString = new String(Arrays.copyOfRange((byte[])decompressBytes, (int)0, (int)decompressLength));
        JSONObject jsonObject = new JSONObject(jsonString);
        String sigTLS = jsonObject.getString("TLS.sig");
        byte[] signatureBytes = Base64.decode((byte[])sigTLS.getBytes(Charset.forName("UTF-8")));
        try {
            String sigTime = jsonObject.getString("TLS.time");
            String sigExpire = jsonObject.getString("TLS.expire_after");
            if (System.currentTimeMillis() / 1000L - Long.parseLong(sigTime) > Long.parseLong(sigExpire)) {
                result.errMessage = new String("TLS sig is out of date ");
                System.out.println("Timeout");
                return result;
            }
            String SerialString = "TLS.appid_at_3rd:" + strAppid3rd + "\nTLS.account_type:" + accountType + "\nTLS.identifier:" + identifier + "\nTLS.sdk_appid:" + skdAppid + "\nTLS.time:" + sigTime + "\nTLS.expire_after:" + sigExpire + "\n";
            CharArrayReader reader = new CharArrayReader(publicKey.toCharArray());
            PEMParser parser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object obj = parser.readObject();
            parser.close();
            PublicKey pubKeyStruct = converter.getPublicKey((SubjectPublicKeyInfo)obj);
            Signature signature = Signature.getInstance("SHA256withECDSA", "BC");
            signature.initVerify(pubKeyStruct);
            signature.update(SerialString.getBytes(Charset.forName("UTF-8")));
            result.verifyResult = signature.verify(signatureBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.errMessage = "Failed in checking sig";
        }
        return result;
    }

    public static GenTLSSignatureResult GenTLSSignatureEx(long skdAppid, String identifier, String privStr) {
        return tls_sigature.GenTLSSignatureEx(skdAppid, identifier, privStr, 15552000L);
    }

    public static GenTLSSignatureResult GenTLSSignatureEx(long skdAppid, String identifier, String privStr, long expire) {
        return tls_sigature.GenTLSSignature(expire, "0", skdAppid, identifier, 0L, privStr);
    }

    public static CheckTLSSignatureResult CheckTLSSignatureEx(String urlSig, long sdkAppid, String identifier, String publicKey) throws DataFormatException {
        CheckTLSSignatureResult result = new CheckTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] compressBytes = base64_url.base64DecodeUrl(urlSig.getBytes(Charset.forName("UTF-8")));
        Inflater decompression = new Inflater();
        decompression.setInput(compressBytes, 0, compressBytes.length);
        byte[] decompressBytes = new byte[1024];
        int decompressLength = decompression.inflate(decompressBytes);
        decompression.end();
        String jsonString = new String(Arrays.copyOfRange((byte[])decompressBytes, (int)0, (int)decompressLength));
        JSONObject jsonObject = new JSONObject(jsonString);
        String sigTLS = jsonObject.getString("TLS.sig");
        byte[] signatureBytes = Base64.decode((byte[])sigTLS.getBytes(Charset.forName("UTF-8")));
        try {
            String strSdkAppid = jsonObject.getString("TLS.sdk_appid");
            String sigTime = jsonObject.getString("TLS.time");
            String sigExpire = jsonObject.getString("TLS.expire_after");
            if ((long)Integer.parseInt(strSdkAppid) != sdkAppid) {
                result.errMessage = new String("sdkappid " + strSdkAppid + " in tls sig not equal sdkappid " + sdkAppid + " in request");
                return result;
            }
            if (System.currentTimeMillis() / 1000L - Long.parseLong(sigTime) > Long.parseLong(sigExpire)) {
                result.errMessage = new String("TLS sig is out of date");
                return result;
            }
            String SerialString = "TLS.appid_at_3rd:0\nTLS.account_type:0\nTLS.identifier:" + identifier + "\nTLS.sdk_appid:" + sdkAppid + "\nTLS.time:" + sigTime + "\nTLS.expire_after:" + sigExpire + "\n";
            CharArrayReader reader = new CharArrayReader(publicKey.toCharArray());
            PEMParser parser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object obj = parser.readObject();
            parser.close();
            PublicKey pubKeyStruct = converter.getPublicKey((SubjectPublicKeyInfo)obj);
            Signature signature = Signature.getInstance("SHA256withECDSA", "BC");
            signature.initVerify(pubKeyStruct);
            signature.update(SerialString.getBytes(Charset.forName("UTF-8")));
            boolean bool = signature.verify(signatureBytes);
            result.expireTime = Integer.parseInt(sigExpire);
            result.initTime = Integer.parseInt(sigTime);
            result.verifyResult = bool;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.errMessage = "Failed in checking sig";
        }
        return result;
    }

    public static GenTLSSignatureResult genSig(long sdkappid, String identifier, String priKey) {
        return tls_sigature.GenTLSSignature(15552000L, "0", sdkappid, identifier, 0L, priKey);
    }

    public static GenTLSSignatureResult genSig(long sdkappid, String identifier, int expire, String priKey) {
        return tls_sigature.GenTLSSignature(expire, "0", sdkappid, identifier, 0L, priKey);
    }

    public static class CheckTLSSignatureResult {
        public String errMessage = "";
        public boolean verifyResult = false;
        public int expireTime;
        public int initTime;
    }

    public static class GenTLSSignatureResult {
        public String errMessage = "";
        public String urlSig = "";
        public int expireTime;
        public int initTime;
    }
}

