/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.proto.mapper;

import com.github.tobato.fastdfs.proto.mapper.FdfsColumn;
import com.github.tobato.fastdfs.proto.mapper.FdfsColumnMapException;
import com.github.tobato.fastdfs.proto.mapper.FieldMateData;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMateData {
    private static Logger LOGGER = LoggerFactory.getLogger(ObjectMateData.class);
    private String className;
    private List<FieldMateData> fieldList = new ArrayList<FieldMateData>();
    private List<FieldMateData> dynamicFieldList = new ArrayList<FieldMateData>();
    private int fieldsTotalSize = 0;

    public <T> ObjectMateData(Class<T> genericType) {
        this.className = genericType.getName();
        this.fieldList = this.praseFieldList(genericType);
        this.validatFieldListDefine();
    }

    public String getClassName() {
        return this.className;
    }

    public List<FieldMateData> getFieldList() {
        return Collections.unmodifiableList(this.fieldList);
    }

    private <T> List<FieldMateData> praseFieldList(Class<T> genericType) {
        Field[] fields = genericType.getDeclaredFields();
        ArrayList<FieldMateData> mapedFieldList = new ArrayList<FieldMateData>();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(FdfsColumn.class)) continue;
            FieldMateData fieldMateData = new FieldMateData(fields[i], this.fieldsTotalSize);
            mapedFieldList.add(fieldMateData);
            this.fieldsTotalSize += fieldMateData.getRealeSize();
            if (!fieldMateData.isDynamicField()) continue;
            this.dynamicFieldList.add(fieldMateData);
        }
        return mapedFieldList;
    }

    private void validatFieldListDefine() {
        for (FieldMateData field : this.fieldList) {
            this.validatFieldItemDefineByIndex(field);
        }
    }

    private void validatFieldItemDefineByIndex(FieldMateData field) {
        for (FieldMateData otherfield : this.fieldList) {
            if (field.equals(otherfield) || field.getIndex() != otherfield.getIndex()) continue;
            Object[] param = new Object[]{this.className, field.getFieldName(), otherfield.getFieldName(), field.getIndex()};
            LOGGER.warn("\u5728\u7c7b{}\u6620\u5c04\u5b9a\u4e49\u4e2d{}\u4e0e{}\u7d22\u5f15\u5b9a\u4e49\u76f8\u540c\u4e3a{}(\u8bf7\u68c0\u67e5\u662f\u5426\u4e3a\u7a0b\u5e8f\u9519\u8bef)", param);
        }
    }

    private boolean hasDynamicField() {
        for (FieldMateData field : this.fieldList) {
            if (!field.isDynamicField()) continue;
            return true;
        }
        return false;
    }

    private int getDynamicFieldSize(Object obj, Charset charset) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int size = 0;
        for (FieldMateData field : this.dynamicFieldList) {
            size += field.getDynamicFieldByteSize(obj, charset);
        }
        return size;
    }

    public int getFieldsFixTotalSize() {
        if (this.hasDynamicField()) {
            throw new FdfsColumnMapException(this.className + " class hasDynamicField, unsupport operator getFieldsTotalSize");
        }
        return this.fieldsTotalSize;
    }

    public int getFieldsSendTotalByteSize(Object bean, Charset charset) {
        if (!this.hasDynamicField()) {
            return this.fieldsTotalSize;
        }
        return this.getDynamicTotalFieldSize(bean, charset);
    }

    private int getDynamicTotalFieldSize(Object bean, Charset charset) {
        try {
            int dynamicFieldSize = this.getDynamicFieldSize(bean, charset);
            return this.fieldsTotalSize + dynamicFieldSize;
        }
        catch (NoSuchMethodException ie) {
            LOGGER.debug("Cannot invoke get methed: ", (Throwable)ie);
            throw new FdfsColumnMapException(ie);
        }
        catch (IllegalAccessException iae) {
            LOGGER.debug("Illegal access: ", (Throwable)iae);
            throw new FdfsColumnMapException(iae);
        }
        catch (InvocationTargetException ite) {
            LOGGER.debug("Cannot invoke method: ", (Throwable)ite);
            throw new FdfsColumnMapException(ite);
        }
    }

    public void dumpObjectMateData() {
        LOGGER.debug("dump class={}", (Object)this.className);
        LOGGER.debug("----------------------------------------");
        for (FieldMateData md : this.fieldList) {
            LOGGER.debug(md.toString());
        }
    }
}

