/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto.storage.internal;

import com.github.tobato.fastdfs.domain.proto.FdfsRequest;
import com.github.tobato.fastdfs.domain.proto.ProtoHead;
import com.github.tobato.fastdfs.domain.proto.mapper.DynamicFieldType;
import com.github.tobato.fastdfs.domain.proto.mapper.FdfsColumn;
import java.io.InputStream;

public class StorageUploadSlaveFileRequest
extends FdfsRequest {
    @FdfsColumn(index=0)
    private long masterFileNameSize;
    @FdfsColumn(index=1)
    private long fileSize;
    @FdfsColumn(index=2, max=16)
    private final String prefixName;
    @FdfsColumn(index=3, max=6)
    private String fileExtName;
    @FdfsColumn(index=4, dynamicField=DynamicFieldType.allRestByte)
    private final String masterFilename;

    public StorageUploadSlaveFileRequest(InputStream inputStream, long fileSize, String masterFilename, String prefixName, String fileExtName) {
        this.inputFile = inputStream;
        this.fileSize = fileSize;
        this.masterFileNameSize = masterFilename.length();
        this.masterFilename = masterFilename;
        this.fileExtName = fileExtName;
        this.prefixName = prefixName;
        this.head = new ProtoHead(21);
    }

    public long getMasterFileNameSize() {
        return this.masterFileNameSize;
    }

    public void setMasterFileNameSize(long masterFileNameSize) {
        this.masterFileNameSize = masterFileNameSize;
    }

    public String getPrefixName() {
        return this.prefixName;
    }

    public String getMasterFilename() {
        return this.masterFilename;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileExtName() {
        return this.fileExtName;
    }

    public void setFileExtName(String fileExtName) {
        this.fileExtName = fileExtName;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }
}

