/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.upload;

import com.github.tobato.fastdfs.domain.fdfs.MetaData;
import com.github.tobato.fastdfs.domain.upload.AbstractFastFileBuilder;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;

public class FastFile {
    protected InputStream inputStream;
    protected long fileSize;
    protected String fileExtName;
    protected Set<MetaData> metaDataSet;
    protected String groupName;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileExtName() {
        return this.fileExtName;
    }

    public Set<MetaData> getMetaDataSet() {
        return Collections.unmodifiableSet(this.metaDataSet);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public FastFile(InputStream inputStream, long fileSize, String fileExtName, Set<MetaData> metaDataSet) {
        this.inputStream = inputStream;
        this.fileSize = fileSize;
        this.fileExtName = fileExtName;
        this.metaDataSet = metaDataSet;
    }

    protected FastFile() {
    }

    public static class Builder
    extends AbstractFastFileBuilder<FastFile> {
        public Builder withFile(InputStream inputStream, long fileSize, String fileExtName) {
            super.withFile(inputStream, fileSize, fileExtName);
            return this;
        }

        public Builder withMetaData(String name, String value) {
            super.withMetaData(name, value);
            return this;
        }

        public Builder withMetaData(Set<MetaData> metaDataSet) {
            super.withMetaData(metaDataSet);
            return this;
        }

        public Builder toGroup(String groupName) {
            super.toGroup(groupName);
            return this;
        }

        @Override
        public FastFile build() {
            FastFile file = new FastFile();
            file.inputStream = this.inputStream;
            file.fileExtName = this.fileExtName;
            file.fileSize = this.fileSize;
            file.metaDataSet = this.metaDataSet;
            file.groupName = this.groupName;
            return file;
        }
    }
}

