/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.conn;

import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="fdfs.pool")
public class ConnectionPoolConfig
extends GenericKeyedObjectPoolConfig {
    public static final int FDFS_MAX_TOTAL = -1;
    public static final int FDFS_MAX_TOTAL_PER_KEY = 50;
    public static final int FDFS_MAX_IDLE_PER_KEY = 10;
    public static final int FDFS_MIN_IDLE_PER_KEY = 5;
    public static final boolean FDFS_TEST_WHILE_IDLE = true;
    public static final boolean FDFS_BLOCK_WHEN_EXHAUSTED = true;
    public static final long FDFS_MAX_WAIT_MILLIS = 5000L;
    public static final long FDFS_MIN_EVICTABLE_IDLETIME_MILLIS = 180000L;
    public static final long FDFS_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 60000L;
    public static final int FDFS_NUM_TESTS_PEREVICTION_RUN = -1;
    public static final String FDFS_JMX_NAME_BASE = "com.github.tobato.fastdfs.conn:type=FdfsConnectionPool";
    public static final String FDFS_JMX_NAME_PREFIX = "fdfsPool";

    public ConnectionPoolConfig() {
        this.setMaxTotal(-1);
        this.setTestWhileIdle(true);
        this.setBlockWhenExhausted(true);
        this.setMaxWaitMillis(5000L);
        this.setMaxTotalPerKey(50);
        this.setMaxIdlePerKey(10);
        this.setMinIdlePerKey(5);
        this.setMinEvictableIdleTimeMillis(180000L);
        this.setTimeBetweenEvictionRunsMillis(60000L);
        this.setNumTestsPerEvictionRun(-1);
        this.setJmxNameBase(FDFS_JMX_NAME_BASE);
        this.setJmxNamePrefix(FDFS_JMX_NAME_PREFIX);
    }
}

