/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.service;

import com.github.tobato.fastdfs.FdfsClientConstants;
import com.github.tobato.fastdfs.domain.fdfs.MetaData;
import com.github.tobato.fastdfs.domain.fdfs.StorageNode;
import com.github.tobato.fastdfs.domain.fdfs.StorePath;
import com.github.tobato.fastdfs.domain.fdfs.ThumbImageConfig;
import com.github.tobato.fastdfs.domain.proto.storage.StorageSetMetadataCommand;
import com.github.tobato.fastdfs.domain.proto.storage.StorageUploadFileCommand;
import com.github.tobato.fastdfs.domain.proto.storage.StorageUploadSlaveFileCommand;
import com.github.tobato.fastdfs.domain.proto.storage.enums.StorageMetadataSetType;
import com.github.tobato.fastdfs.domain.upload.FastFile;
import com.github.tobato.fastdfs.domain.upload.FastImageFile;
import com.github.tobato.fastdfs.domain.upload.ThumbImage;
import com.github.tobato.fastdfs.exception.FdfsUnsupportImageTypeException;
import com.github.tobato.fastdfs.exception.FdfsUploadImageException;
import com.github.tobato.fastdfs.service.DefaultGenerateStorageClient;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultFastFileStorageClient
extends DefaultGenerateStorageClient
implements FastFileStorageClient {
    private static final List<String> SUPPORT_IMAGE_LIST = Arrays.asList(FdfsClientConstants.SUPPORT_IMAGE_TYPE);
    @Autowired
    private ThumbImageConfig thumbImageConfig;

    @Override
    public StorePath uploadFile(InputStream inputStream, long fileSize, String fileExtName, Set<MetaData> metaDataSet) {
        FastFile fastFile = null == metaDataSet ? new FastFile.Builder().withFile(inputStream, fileSize, fileExtName).build() : ((FastFile.Builder)new FastFile.Builder().withFile(inputStream, fileSize, fileExtName).withMetaData((Set)metaDataSet)).build();
        return this.uploadFile(fastFile);
    }

    @Override
    public StorePath uploadImageAndCrtThumbImage(InputStream inputStream, long fileSize, String fileExtName, Set<MetaData> metaDataSet) {
        FastImageFile fastImageFile = null == metaDataSet ? new FastImageFile.Builder().withFile(inputStream, fileSize, fileExtName).withThumbImage().build() : ((FastImageFile.Builder)new FastImageFile.Builder().withFile(inputStream, fileSize, fileExtName).withMetaData((Set)metaDataSet)).withThumbImage().build();
        return this.uploadImage(fastImageFile);
    }

    @Override
    public StorePath uploadFile(FastFile fastFile) {
        Validate.notNull((Object)fastFile.getInputStream(), (String)"\u4e0a\u4f20\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fastFile.getFileExtName(), (String)"\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StorageNode client = this.getStorageNode(fastFile.getGroupName());
        return this.uploadFileAndMetaData(client, fastFile.getInputStream(), fastFile.getFileSize(), fastFile.getFileExtName(), fastFile.getMetaDataSet());
    }

    @Override
    public StorePath uploadImage(FastImageFile fastImageFile) {
        String fileExtName = fastImageFile.getFileExtName();
        Validate.notNull((Object)fastImageFile.getInputStream(), (String)"\u4e0a\u4f20\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileExtName, (String)"\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!this.isSupportImage(fileExtName)) {
            throw new FdfsUnsupportImageTypeException("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f" + fileExtName);
        }
        StorageNode client = this.getStorageNode(fastImageFile.getGroupName());
        byte[] bytes = this.inputStreamToByte(fastImageFile.getInputStream());
        StorePath path = this.uploadFileAndMetaData(client, new ByteArrayInputStream(bytes), fastImageFile.getFileSize(), fileExtName, fastImageFile.getMetaDataSet());
        if (null != fastImageFile.getThumbImage()) {
            this.uploadThumbImage(client, new ByteArrayInputStream(bytes), path.getPath(), fastImageFile);
        }
        bytes = null;
        return path;
    }

    private StorageNode getStorageNode(String groupName) {
        if (null == groupName) {
            return this.trackerClient.getStoreStorage();
        }
        return this.trackerClient.getStoreStorage(groupName);
    }

    private byte[] inputStreamToByte(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            LOGGER.error("image inputStream to byte error", (Throwable)e);
            throw new FdfsUploadImageException("upload ThumbImage error", e.getCause());
        }
    }

    private boolean hasMetaData(Set<MetaData> metaDataSet) {
        return null != metaDataSet && !metaDataSet.isEmpty();
    }

    private boolean isSupportImage(String fileExtName) {
        return SUPPORT_IMAGE_LIST.contains(fileExtName.toUpperCase());
    }

    private StorePath uploadFileAndMetaData(StorageNode client, InputStream inputStream, long fileSize, String fileExtName, Set<MetaData> metaDataSet) {
        StorageUploadFileCommand command = new StorageUploadFileCommand(client.getStoreIndex(), inputStream, fileExtName, fileSize, false);
        StorePath path = this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
        if (this.hasMetaData(metaDataSet)) {
            StorageSetMetadataCommand setMDCommand = new StorageSetMetadataCommand(path.getGroup(), path.getPath(), metaDataSet, StorageMetadataSetType.STORAGE_SET_METADATA_FLAG_OVERWRITE);
            this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), setMDCommand);
        }
        return path;
    }

    private void uploadThumbImage(StorageNode client, InputStream inputStream, String masterFilename, FastImageFile fastImageFile) {
        ByteArrayInputStream thumbImageStream = null;
        ThumbImage thumbImage = fastImageFile.getThumbImage();
        try {
            thumbImageStream = this.generateThumbImageStream(inputStream, thumbImage);
            long fileSize = thumbImageStream.available();
            String prefixName = thumbImage.getPrefixName();
            LOGGER.error("\u83b7\u53d6\u5230\u7f29\u7565\u56fe\u524d\u7f00{}", (Object)prefixName);
            StorageUploadSlaveFileCommand command = new StorageUploadSlaveFileCommand(thumbImageStream, fileSize, masterFilename, prefixName, fastImageFile.getFileExtName());
            this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
        }
        catch (IOException e) {
            try {
                LOGGER.error("upload ThumbImage error", (Throwable)e);
                throw new FdfsUploadImageException("upload ThumbImage error", e.getCause());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(thumbImageStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)thumbImageStream);
    }

    private ByteArrayInputStream generateThumbImageStream(InputStream inputStream, ThumbImage thumbImage) throws IOException {
        if (thumbImage.isDefaultConfig()) {
            thumbImage.setDefaultSize(this.thumbImageConfig.getWidth(), this.thumbImageConfig.getHeight());
            return this.generateThumbImageByDefault(inputStream);
        }
        if (thumbImage.getPercent() != 0.0) {
            return this.generateThumbImageByPercent(inputStream, thumbImage);
        }
        return this.generateThumbImageBySize(inputStream, thumbImage);
    }

    private ByteArrayInputStream generateThumbImageByPercent(InputStream inputStream, ThumbImage thumbImage) throws IOException {
        LOGGER.debug("\u6839\u636e\u4f20\u5165\u6bd4\u4f8b\u751f\u6210\u7f29\u7565\u56fe");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(thumbImage.getPercent()).imageType(2).toOutputStream((OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    private ByteArrayInputStream generateThumbImageBySize(InputStream inputStream, ThumbImage thumbImage) throws IOException {
        LOGGER.debug("\u6839\u636e\u4f20\u5165\u5c3a\u5bf8\u751f\u6210\u7f29\u7565\u56fe");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(thumbImage.getWidth(), thumbImage.getHeight()).imageType(2).toOutputStream((OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    private ByteArrayInputStream generateThumbImageByDefault(InputStream inputStream) throws IOException {
        LOGGER.debug("\u6839\u636e\u9ed8\u8ba4\u914d\u7f6e\u751f\u6210\u7f29\u7565\u56fe");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(this.thumbImageConfig.getWidth(), this.thumbImageConfig.getHeight()).imageType(2).toOutputStream((OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public void deleteFile(String filePath) {
        StorePath storePath = StorePath.parseFromUrl(filePath);
        super.deleteFile(storePath.getGroup(), storePath.getPath());
    }
}

