/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptableMutablePropertySourcesInterceptor;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.encryptor.DefaultLazyEncryptor;
import com.ulisesbocchio.jasyptspringboot.resolver.DefaultPropertyResolver;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aopalliance.aop.Advice;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class EncryptableEnvironmentProxy
implements ConfigurableEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptableEnvironmentProxy.class);
    private final ConfigurableEnvironment delegate;
    private final ConfigurablePropertyResolver propertyResolver;
    private MutablePropertySources propertySources;

    public EncryptableEnvironmentProxy(ConfigurableEnvironment delegate) {
        this(delegate, EncryptableEnvironmentProxy.discoverEncryptor(delegate));
    }

    public EncryptableEnvironmentProxy(ConfigurableEnvironment delegate, EncryptablePropertyDetector detector) {
        this(delegate, new DefaultPropertyResolver(EncryptableEnvironmentProxy.discoverEncryptor(delegate), detector));
    }

    public EncryptableEnvironmentProxy(ConfigurableEnvironment delegate, StringEncryptor encryptor) {
        this(delegate, new DefaultPropertyResolver(encryptor, new DefaultPropertyDetector()));
    }

    public EncryptableEnvironmentProxy(ConfigurableEnvironment delegate, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        this(delegate, new DefaultPropertyResolver(encryptor, detector));
    }

    public EncryptableEnvironmentProxy(ConfigurableEnvironment delegate, EncryptablePropertyResolver encryptablePropertyResolver) {
        this.delegate = delegate;
        this.propertySources = this.makeEncryptable(delegate.getPropertySources(), (Environment)delegate, encryptablePropertyResolver);
        this.propertyResolver = new PropertySourcesPropertyResolver((PropertySources)this.propertySources);
    }

    private static StringEncryptor discoverEncryptor(ConfigurableEnvironment delegate) {
        return new DefaultLazyEncryptor((Environment)delegate);
    }

    private MutablePropertySources makeEncryptable(MutablePropertySources propertySources, Environment environment, EncryptablePropertyResolver encryptablePropertyResolver) {
        StreamSupport.stream(propertySources.spliterator(), false).filter(ps -> !(ps instanceof EncryptablePropertySource)).map(s -> this.makeEncryptable((PropertySource)s, environment, encryptablePropertyResolver)).collect(Collectors.toList()).forEach(ps -> propertySources.replace(ps.getName(), ps));
        return this.proxy(propertySources, environment, encryptablePropertyResolver);
    }

    private MutablePropertySources proxy(MutablePropertySources propertySources, Environment environment, EncryptablePropertyResolver encryptablePropertyResolver) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(MutablePropertySources.class);
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setTarget((Object)propertySources);
        proxyFactory.addAdvice((Advice)new EncryptableMutablePropertySourcesInterceptor(ps -> this.makeEncryptable((PropertySource)ps, environment, encryptablePropertyResolver)));
        return (MutablePropertySources)proxyFactory.getProxy();
    }

    private <T> PropertySource<T> makeEncryptable(PropertySource<T> propertySource, Environment environment, EncryptablePropertyResolver encryptablePropertyResolver) {
        PropertySource<T> encryptablePropertySource = this.getInterceptionMode(environment) == InterceptionMode.PROXY ? EncryptablePropertySourceConverter.proxyPropertySource(propertySource, encryptablePropertyResolver) : EncryptablePropertySourceConverter.instantiatePropertySource(propertySource, encryptablePropertyResolver);
        LOG.info("Converting PropertySource {} [{}] to {}", new Object[]{propertySource.getName(), propertySource.getClass().getName(), AopUtils.isAopProxy(encryptablePropertySource) ? "AOP Proxy" : encryptablePropertySource.getClass().getSimpleName()});
        return encryptablePropertySource;
    }

    private InterceptionMode getInterceptionMode(Environment environment) {
        return (Boolean)environment.getProperty("jasypt.encryptor.proxyPropertySources", Boolean.TYPE, (Object)false) != false ? InterceptionMode.PROXY : InterceptionMode.WRAPPER;
    }

    public void addActiveProfile(String profile) {
        this.delegate.addActiveProfile(profile);
    }

    public MutablePropertySources getPropertySources() {
        return this.propertySources;
    }

    public Map<String, Object> getSystemEnvironment() {
        return this.delegate.getSystemEnvironment();
    }

    public Map<String, Object> getSystemProperties() {
        return this.delegate.getSystemProperties();
    }

    public void merge(ConfigurableEnvironment parent) {
        this.delegate.merge(parent);
    }

    public ConfigurableConversionService getConversionService() {
        return this.propertyResolver.getConversionService();
    }

    public void setConversionService(ConfigurableConversionService conversionService) {
        this.propertyResolver.setConversionService(conversionService);
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.propertyResolver.setPlaceholderPrefix(placeholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.propertyResolver.setPlaceholderSuffix(placeholderSuffix);
    }

    public void setValueSeparator(String valueSeparator) {
        this.propertyResolver.setValueSeparator(valueSeparator);
    }

    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.propertyResolver.setIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders);
    }

    public void setRequiredProperties(String ... requiredProperties) {
        this.propertyResolver.setRequiredProperties(requiredProperties);
    }

    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        this.propertyResolver.validateRequiredProperties();
    }

    public String[] getActiveProfiles() {
        return this.delegate.getActiveProfiles();
    }

    public void setActiveProfiles(String ... profiles) {
        this.delegate.setActiveProfiles(profiles);
    }

    public String[] getDefaultProfiles() {
        return this.delegate.getDefaultProfiles();
    }

    public void setDefaultProfiles(String ... profiles) {
        this.delegate.setDefaultProfiles(profiles);
    }

    public boolean acceptsProfiles(String ... profiles) {
        return this.delegate.acceptsProfiles(profiles);
    }

    public boolean containsProperty(String key) {
        return this.propertyResolver.containsProperty(key);
    }

    public String getProperty(String key) {
        return this.propertyResolver.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.propertyResolver.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        return (T)this.propertyResolver.getProperty(key, targetType);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)this.propertyResolver.getProperty(key, targetType, defaultValue);
    }

    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        return this.propertyResolver.getPropertyAsClass(key, targetType);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key);
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return (T)this.propertyResolver.getRequiredProperty(key, targetType);
    }

    public String resolvePlaceholders(String text) {
        return this.propertyResolver.resolvePlaceholders(text);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.propertyResolver.resolveRequiredPlaceholders(text);
    }
}

