/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleAsymmetricConfig;
import com.ulisesbocchio.jasyptspringboot.util.AsymmetricCryptography;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.jasypt.encryption.ByteEncryptor;

public class SimpleAsymmetricByteEncryptor
implements ByteEncryptor {
    private final AsymmetricCryptography crypto;
    private final Singleton<PublicKey> publicKey;
    private final Singleton<PrivateKey> privateKey;

    public SimpleAsymmetricByteEncryptor(SimpleAsymmetricConfig config) {
        this.crypto = new AsymmetricCryptography(config.getResourceLoader());
        this.privateKey = Singleton.fromLazy(this.crypto::getPrivateKey, config::loadPrivateKeyResource, config::getPrivateKeyFormat);
        this.publicKey = Singleton.fromLazy(this.crypto::getPublicKey, config::loadPublicKeyResource, config::getPublicKeyFormat);
    }

    public byte[] encrypt(byte[] message) {
        return this.crypto.encrypt(message, this.publicKey.get());
    }

    public byte[] decrypt(byte[] encryptedMessage) {
        return this.crypto.decrypt(encryptedMessage, this.privateKey.get());
    }
}

