/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.util.HostUtil;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.NamespaceUtil;
import com.github.netty.core.util.ThreadFactoryX;
import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractNettyServer
implements Runnable,
Closeable {
    protected LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private String name;
    private ServerSocketChannel serverChannel;
    private EventLoopGroup boss;
    private EventLoopGroup worker;
    private ServerBootstrap bootstrap;
    private InetSocketAddress serverAddress;
    private final boolean enableEpoll;
    private int ioThreadCount = 0;
    private int ioRatio = 100;
    private boolean running = false;
    private AtomicBoolean initFlag = new AtomicBoolean(false);

    public AbstractNettyServer(int port) {
        this(new InetSocketAddress(port));
    }

    public AbstractNettyServer(InetSocketAddress address) {
        this("", address);
    }

    public AbstractNettyServer(String preName, InetSocketAddress address) {
        this.enableEpoll = Epoll.isAvailable();
        this.serverAddress = address;
        this.name = NamespaceUtil.newIdName(preName, this.getClass());
        if (this.enableEpoll) {
            this.logger.info("enable epoll server = {}", (Object)this);
        }
    }

    public void setIoRatio(int ioRatio) {
        if (this.worker instanceof NioEventLoopGroup) {
            ((NioEventLoopGroup)this.worker).setIoRatio(ioRatio);
        } else if (this.worker instanceof EpollEventLoopGroup) {
            // empty if block
        }
        this.ioRatio = ioRatio;
    }

    public void setIoThreadCount(int ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    protected abstract ChannelHandler newWorkerChannelHandler();

    protected ChannelHandler newBossChannelHandler() {
        return null;
    }

    protected ServerBootstrap newServerBootstrap() {
        return new ServerBootstrap();
    }

    protected EventLoopGroup newWorkerEventLoopGroup() {
        Object worker = this.enableEpoll ? new EpollEventLoopGroup(this.ioThreadCount, (ThreadFactory)new ThreadFactoryX("Epoll", "Server-Worker")) : new NioEventLoopGroup(this.ioThreadCount, (ThreadFactory)new ThreadFactoryX("NIO", "Server-Worker"));
        return worker;
    }

    protected EventLoopGroup newBossEventLoopGroup() {
        EpollEventLoopGroup boss;
        if (this.enableEpoll) {
            EpollEventLoopGroup epollBoss;
            boss = epollBoss = new EpollEventLoopGroup(1, (ThreadFactory)new ThreadFactoryX("Epoll", "Server-Boss"));
        } else {
            NioEventLoopGroup jdkBoss = new NioEventLoopGroup(1, (ThreadFactory)new ThreadFactoryX("NIO", "Server-Boss"));
            jdkBoss.setIoRatio(this.ioRatio);
            boss = jdkBoss;
        }
        return boss;
    }

    public EventLoopGroup getWorker() {
        return this.worker;
    }

    public EventLoopGroup getBoss() {
        return this.boss;
    }

    protected ChannelFactory<? extends ServerChannel> newServerChannelFactory() {
        ChannelFactory channelFactory = this.enableEpoll ? EpollServerSocketChannel::new : NioServerSocketChannel::new;
        return channelFactory;
    }

    public ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void init() throws Exception {
        if (this.initFlag.compareAndSet(false, true)) {
            this.bootstrap = this.newServerBootstrap();
            this.boss = this.newBossEventLoopGroup();
            this.worker = this.newWorkerEventLoopGroup();
            ChannelFactory<? extends ServerChannel> channelFactory = this.newServerChannelFactory();
            ChannelHandler bossChannelHandler = this.newBossChannelHandler();
            ChannelHandler workerChannelHandler = this.newWorkerChannelHandler();
            if (bossChannelHandler != null) {
                this.bootstrap.handler(bossChannelHandler);
            }
            ((ServerBootstrap)this.bootstrap.group(this.boss, this.worker).channelFactory(channelFactory)).childHandler(workerChannelHandler);
            this.config(this.bootstrap);
        }
    }

    @Override
    public final void run() {
        try {
            if (this.running) {
                return;
            }
            this.init();
            ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)this.serverAddress).addListener((GenericFutureListener)((ChannelFutureListener)this::startAfter));
            this.serverChannel = (ServerSocketChannel)channelFuture.channel();
            this.running = true;
        }
        catch (Throwable throwable) {
            this.logger.error("server run fail. cause={}", (Object)throwable.toString(), (Object)throwable);
        }
    }

    public void stop() {
        if (this.serverChannel == null) {
            return;
        }
        this.serverChannel.close().addListener((GenericFutureListener)((ChannelFutureListener)closeFuture -> {
            if (this.boss == null) {
                return;
            }
            this.boss.shutdownGracefully().addListener(bossFuture -> {
                if (this.worker != null) {
                    this.worker.shutdownGracefully().addListener(this::stopAfter);
                }
            });
        }));
    }

    @Override
    public void close() {
        if (this.serverChannel != null) {
            this.stop();
        }
    }

    public ServerSocketChannel getServerChannel() {
        return this.serverChannel;
    }

    public boolean isEnableEpoll() {
        return this.enableEpoll;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        if (this.serverAddress == null) {
            return 0;
        }
        return this.serverAddress.getPort();
    }

    protected void config(ServerBootstrap bootstrap) throws Exception {
        ((ServerBootstrap)bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT);
        if (this.enableEpoll) {
            bootstrap.option(UnixChannelOption.SO_REUSEPORT, (Object)true);
        }
    }

    protected void stopAfter(Future future) {
        Throwable cause = future.cause();
        if (cause != null) {
            this.logger.error("stopAfter error={}", (Object)cause.toString(), (Object)cause);
        }
        this.logger.info("{} stop [port = {} , cause = {}]...", this.getName(), this.getPort(), cause);
    }

    protected void startAfter(ChannelFuture future) {
        Throwable cause = future.cause();
        if (cause != null) {
            PlatformDependent.throwException((Throwable)cause);
        }
        this.logger.info("{} start (port = {}, pid = {}, os = {}) ...", this.getName(), this.getPort() + "", HostUtil.getPid() + "", HostUtil.getOsName());
    }

    public String toString() {
        return this.name + "{port=" + this.getPort() + '}';
    }
}

