/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.AutoFlushChannelHandler;
import com.github.netty.core.ProtocolHandler;
import com.github.netty.core.ServerListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.concurrent.TimeUnit;

public abstract class AbstractProtocol
implements ProtocolHandler,
ServerListener {
    private int autoFlushIdleMs;

    public void setAutoFlushIdleMs(int autoFlushIdleMs) {
        this.autoFlushIdleMs = autoFlushIdleMs;
    }

    public int getAutoFlushIdleMs() {
        return this.autoFlushIdleMs;
    }

    @Override
    public void addPipeline(Channel channel) throws Exception {
        int autoFlushIdleTime = this.getAutoFlushIdleMs();
        if (autoFlushIdleTime > 0) {
            channel.pipeline().addLast("autoflush", (ChannelHandler)new AutoFlushChannelHandler(autoFlushIdleTime, TimeUnit.MILLISECONDS));
        }
    }

    public String toString() {
        return this.getProtocolName();
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

