/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.Packet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.AsciiString;
import java.util.Map;
import java.util.Objects;

public class AbstractProtocolEncoder<T extends Packet>
extends MessageToByteEncoder<T> {
    private int fixedLength;
    private byte[] versionBytes;

    public AbstractProtocolEncoder() {
        this.setVersionBytes(new byte[0]);
    }

    public void encode(ChannelHandlerContext ctx, T packet, ByteBuf out) throws Exception {
        ByteBuf body;
        int packetLength = this.fixedLength;
        int writerTotalLengthIndex = out.writerIndex();
        out.writerIndex(writerTotalLengthIndex + 2);
        out.writeByte(((Packet)packet).getPacketType());
        out.writeByte(((Packet)packet).getAck());
        out.writeBytes(this.versionBytes);
        Map<AsciiString, ByteBuf> fieldMap = ((Packet)packet).getFieldMap();
        int fieldSize = fieldMap == null ? 0 : fieldMap.size();
        out.writeByte(fieldSize);
        if (fieldSize > 0) {
            packetLength += fieldSize * 3;
            for (Map.Entry<AsciiString, ByteBuf> entry : fieldMap.entrySet()) {
                AsciiString key = entry.getKey();
                ByteBuf value = entry.getValue();
                packetLength += key.length();
                out.writeByte(key.length());
                ByteBufUtil.writeAscii((ByteBuf)out, (CharSequence)key);
                packetLength += value.readableBytes();
                out.writeChar(value.readableBytes());
                out.writeBytes(value);
            }
        }
        if ((body = ((Packet)packet).getBody()).readableBytes() > 0) {
            packetLength += body.readableBytes();
            out.writeBytes(body);
        }
        out.setChar(writerTotalLengthIndex, packetLength);
    }

    public void setVersionBytes(byte[] versionBytes) {
        this.versionBytes = Objects.requireNonNull(versionBytes);
        this.fixedLength = versionBytes.length + 1 + 1 + 1;
    }

    public byte[] getVersionBytes() {
        return this.versionBytes;
    }
}

