/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.JVMUtil;
import com.github.netty.core.util.LoggerFactoryX;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;

public class AbortPolicyWithReport
extends ThreadPoolExecutor.AbortPolicy {
    protected final String info;
    protected final String threadName;
    protected final String dumpPath;
    private static volatile long lastPrintTime = 0L;
    private static final long TEN_MINUTES_MILLS = 600000L;
    private static Semaphore guard = new Semaphore(1);

    public AbortPolicyWithReport(String threadName, String dumpPath, String info) {
        this.threadName = threadName;
        this.dumpPath = dumpPath == null ? System.getProperty("user.home") : dumpPath;
        this.info = info;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        String msg = String.format("Thread pool is EXHAUSTED! Thread Name: %s, Pool Size: %d (active: %d, core: %d, max: %d, largest: %d), Task: %d (completed: %d), Executor status:(isShutdown:%s, isTerminated:%s, isTerminating:%s), in %s", this.threadName, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating(), this.info);
        LoggerFactoryX.getLogger(AbortPolicyWithReport.class).warn(msg);
        if (!this.dumpPath.isEmpty()) {
            this.dumpJStack();
        }
        throw new RejectedExecutionException(msg);
    }

    protected void dumpJStack() {
        long now = System.currentTimeMillis();
        if (now - lastPrintTime < 600000L) {
            return;
        }
        if (!guard.tryAcquire()) {
            return;
        }
        ExecutorService pool = Executors.newSingleThreadExecutor();
        pool.execute(() -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String dateStr = sdf.format(new Date());
            try (FileOutputStream jStackStream = new FileOutputStream(new File(this.dumpPath, "NettyX_JStack.log." + dateStr));){
                JVMUtil.jstack(jStackStream);
            }
            catch (Throwable t) {
                LoggerFactoryX.getLogger(AbortPolicyWithReport.class).error("dump jStack error", t);
            }
            finally {
                guard.release();
            }
            lastPrintTime = System.currentTimeMillis();
        });
        pool.shutdown();
    }
}

