/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;

public class AnnotationMethodToParameterNamesFunction
implements Function<Method, String[]> {
    private final Collection<Class<? extends Annotation>> parameterAnnotationClasses;
    private final Collection<String> fieldNameList = new LinkedHashSet<String>(Arrays.asList("value", "name"));
    private final Map<Integer, Boolean> existAnnotationMap = new WeakHashMap<Integer, Boolean>(128);

    public AnnotationMethodToParameterNamesFunction(Collection<Class<? extends Annotation>> parameterAnnotationClasses) {
        this.parameterAnnotationClasses = Objects.requireNonNull(parameterAnnotationClasses);
    }

    @SafeVarargs
    public AnnotationMethodToParameterNamesFunction(Class<? extends Annotation> ... parameterAnnotationClasses) {
        this.parameterAnnotationClasses = new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(parameterAnnotationClasses));
    }

    public Collection<String> getFieldNameList() {
        return this.fieldNameList;
    }

    public Collection<Class<? extends Annotation>> getParameterAnnotationClasses() {
        return this.parameterAnnotationClasses;
    }

    @Override
    public String[] apply(Method method) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Parameter parameter : method.getParameters()) {
            Annotation annotation;
            String parameterName = null;
            Annotation[] annotationArray = parameter.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && ((parameterName = this.getName(annotation = annotationArray[i])) == null || parameterName.isEmpty()); ++i) {
            }
            if (parameterName == null) {
                parameterName = parameter.getName();
            }
            parameterNames.add(parameterName);
        }
        return parameterNames.toArray(new String[0]);
    }

    private String getName(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        for (Class<? extends Annotation> parameterAnnotationClass : this.parameterAnnotationClasses) {
            int hashCode = Objects.hash(annotationType, parameterAnnotationClass);
            Boolean exist = this.existAnnotationMap.get(hashCode);
            if (exist == null) {
                exist = Objects.equals(annotationType, parameterAnnotationClass) || ReflectUtil.findAnnotation(annotationType, parameterAnnotationClass) != null;
                this.existAnnotationMap.put(hashCode, exist != false ? Boolean.TRUE : Boolean.FALSE);
            }
            if (!exist.booleanValue()) continue;
            String methodName = this.getDirectName(annotation);
            if (methodName != null && !methodName.isEmpty()) {
                return methodName;
            }
            return annotation.annotationType().getSimpleName();
        }
        return null;
    }

    private String getDirectName(Annotation annotation) {
        Map<String, Object> memberValuesMap = ReflectUtil.getAnnotationValueMap(annotation);
        for (String fieldName : this.fieldNameList) {
            Object value = memberValuesMap.get(fieldName);
            if (value instanceof String[]) {
                for (String s : (String[])value) {
                    if (s == null || "".equals(s)) continue;
                    return s;
                }
                continue;
            }
            if (value == null || "".equals(value)) continue;
            return value.toString();
        }
        return null;
    }
}

