/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.core.util.BytesMetrics;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class BytesMetricsChannelHandler
extends AbstractChannelHandler<ByteBuf, ByteBuf> {
    private static final AttributeKey<BytesMetrics> ATTR_KEY_METRICS = AttributeKey.valueOf((String)(BytesMetrics.class + "#BytesMetrics"));
    private AtomicLong readBytes = new AtomicLong();
    private AtomicLong writeBytes = new AtomicLong();

    public BytesMetricsChannelHandler() {
        super(false);
        Runtime.getRuntime().addShutdownHook(new Thread("Metrics-Hook" + ((Object)((Object)this)).hashCode()){

            @Override
            public void run() {
                BytesMetricsChannelHandler.this.logger.info("Metrics bytes[read={}/byte, write={}/byte]", (Object)BytesMetricsChannelHandler.this.readBytes, (Object)BytesMetricsChannelHandler.this.writeBytes);
            }
        });
    }

    @Override
    public void onMessageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        BytesMetrics metrics = BytesMetricsChannelHandler.getOrSetMetrics(ctx.channel());
        metrics.incrementRead(msg.readableBytes());
        ctx.fireChannelRead((Object)msg);
    }

    @Override
    protected void onMessageWriter(ChannelHandlerContext ctx, ByteBuf msg, ChannelPromise promise) throws Exception {
        BytesMetrics metrics = BytesMetricsChannelHandler.getOrSetMetrics(ctx.channel());
        metrics.incrementWrote(msg.writableBytes());
        if (promise.isVoid()) {
            ctx.write((Object)msg, promise);
        } else {
            ctx.write((Object)msg, promise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        BytesMetrics metrics = BytesMetricsChannelHandler.getOrSetMetrics(ctx.channel());
        this.readBytes.getAndAdd(metrics.bytesRead());
        this.writeBytes.getAndAdd(metrics.bytesWrote());
        ctx.close(promise);
    }

    public static BytesMetrics getOrSetMetrics(Channel channel) {
        Attribute attribute = channel.attr(ATTR_KEY_METRICS);
        BytesMetrics metrics = (BytesMetrics)attribute.get();
        if (metrics == null) {
            metrics = new BytesMetrics();
            attribute.set((Object)metrics);
        }
        return metrics;
    }
}

