/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.StringUtil;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class NamespaceUtil {
    private static Namespace defaultNamespace;

    private NamespaceUtil() {
    }

    public static String newIdName(Object obj) {
        String startName = obj instanceof Class ? ((Class)obj).getSimpleName() : obj.toString();
        return NamespaceUtil.getDefaultNamespace().newIdName(obj, startName);
    }

    public static String newIdName(Object obj, String name) {
        return NamespaceUtil.getDefaultNamespace().newIdName(obj, name);
    }

    public static String getIdName(Object obj, String name) {
        return NamespaceUtil.getDefaultNamespace().getIdName(obj, name);
    }

    public static String newIdName(Class obj) {
        String name = StringUtil.firstUpperCase(obj.getSimpleName());
        return NamespaceUtil.getDefaultNamespace().newIdName(obj, name);
    }

    public static String newIdName(String preName, Class obj) {
        return preName + NamespaceUtil.newIdName(obj);
    }

    public static String getIdNameClass(Object obj, String name) {
        return NamespaceUtil.getDefaultNamespace().getIdNameClass(obj, name);
    }

    public static int getId(Object obj) {
        return NamespaceUtil.getDefaultNamespace().getId(obj);
    }

    public static int getIdClass(Object obj) {
        return NamespaceUtil.getDefaultNamespace().getIdClass(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Namespace getDefaultNamespace() {
        if (defaultNamespace != null) return defaultNamespace;
        Class<NamespaceUtil> clazz = NamespaceUtil.class;
        synchronized (NamespaceUtil.class) {
            if (defaultNamespace != null) return defaultNamespace;
            defaultNamespace = new Namespace();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultNamespace;
        }
    }

    public static Namespace newNamespace() {
        return new Namespace();
    }

    static class Namespace {
        private final Map<Object, AtomicInteger> idIncrMap = new WeakHashMap<Object, AtomicInteger>(16);
        private final Map<Object, Integer> idMap = new WeakHashMap<Object, Integer>(16);

        Namespace() {
        }

        public String newIdName(Object obj, String name) {
            return name + "@" + this.newId(obj);
        }

        public String getIdName(Object obj, String name) {
            return name + "@" + this.getId(obj);
        }

        public String getIdNameClass(Object obj, String name) {
            return name + "@" + this.getIdClass(obj);
        }

        public int getId(Object obj) {
            Integer id = this.idMap.get(obj);
            if (id != null) {
                return id;
            }
            id = this.newId(obj);
            this.idMap.put(obj, id);
            return id;
        }

        public int getIdClass(Object obj) {
            Integer id = this.idMap.get(obj);
            if (id != null) {
                return id;
            }
            id = this.newId(obj.getClass());
            this.idMap.put(obj, id);
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int newId(Object obj) {
            AtomicInteger atomicInteger = this.idIncrMap.get(obj);
            if (atomicInteger == null) {
                Map<Object, AtomicInteger> map = this.idIncrMap;
                synchronized (map) {
                    atomicInteger = this.idIncrMap.get(obj);
                    if (atomicInteger == null) {
                        atomicInteger = new AtomicInteger(0);
                        this.idIncrMap.put(obj, atomicInteger);
                    }
                }
            }
            return atomicInteger.incrementAndGet();
        }
    }
}

