/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TypeUtil {
    public static boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Short.class);
    }

    public static <T> TypeResult getGenericType(Class<T> type, Class<? extends T> clazz) {
        Type[] interfaces;
        for (Type iface : interfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pi;
            if (!(iface instanceof ParameterizedType) || !((pi = (ParameterizedType)iface).getRawType() instanceof Class) || !type.isAssignableFrom((Class)pi.getRawType())) continue;
            return TypeUtil.getTypeParameter(clazz, pi.getActualTypeArguments()[0]);
        }
        Class<? extends T> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return null;
        }
        TypeResult superClassTypeResult = TypeUtil.getGenericType(type, superClazz);
        int dimension = superClassTypeResult.getDimension();
        if (superClassTypeResult.getIndex() == -1 && dimension == 0) {
            return superClassTypeResult;
        }
        if (superClassTypeResult.getIndex() > -1) {
            ParameterizedType superClassType = (ParameterizedType)clazz.getGenericSuperclass();
            TypeResult result = TypeUtil.getTypeParameter(clazz, superClassType.getActualTypeArguments()[superClassTypeResult.getIndex()]);
            result.incrementDimension(superClassTypeResult.getDimension());
            if (result.getClazz() != null && result.getDimension() > 0) {
                superClassTypeResult = result;
            } else {
                return result;
            }
        }
        if (superClassTypeResult.getDimension() > 0) {
            Class<?> arrayClazz;
            StringBuilder className = new StringBuilder();
            for (int i = 0; i < dimension; ++i) {
                className.append('[');
            }
            className.append('L');
            className.append(superClassTypeResult.getClazz().getCanonicalName());
            className.append(';');
            try {
                arrayClazz = Class.forName(className.toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            return new TypeResult(arrayClazz, -1, 0);
        }
        return null;
    }

    private static TypeResult getTypeParameter(Class<?> clazz, Type argType) {
        if (argType instanceof Class) {
            return new TypeResult((Class)argType, -1, 0);
        }
        if (argType instanceof ParameterizedType) {
            return new TypeResult((Class)((ParameterizedType)argType).getRawType(), -1, 0);
        }
        if (argType instanceof GenericArrayType) {
            Type arrayElementType = ((GenericArrayType)argType).getGenericComponentType();
            TypeResult result = TypeUtil.getTypeParameter(clazz, arrayElementType);
            if (result != null) {
                result.incrementDimension(1);
            }
            return result;
        }
        TypeVariable<Class<?>>[] tvs = clazz.getTypeParameters();
        for (int i = 0; i < tvs.length; ++i) {
            if (!tvs[i].equals(argType)) continue;
            return new TypeResult(null, i, 0);
        }
        return null;
    }

    public static String castToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).stripTrailingZeros().toPlainString();
        }
        return value.toString();
    }

    public static Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new RuntimeException("can not cast to byte, value : " + value);
    }

    public static Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new IllegalArgumentException("can not cast to char, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new IllegalArgumentException("can not cast to char, value : " + value);
    }

    public static Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new IllegalArgumentException("can not cast to short, value : " + value);
    }

    public static BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        String strVal = value.toString();
        if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new IllegalArgumentException("can not cast to float, value : " + value);
    }

    public static Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Double.parseDouble(strVal);
        }
        throw new IllegalArgumentException("can not cast to double, value : " + value);
    }

    public static java.util.Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            return new java.util.Date(longValue);
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            Timestamp date = TypeUtil.parseDate(strVal);
            if (date != null) {
                return date;
            }
        }
        throw new IllegalArgumentException("can not cast to Date, value : " + value);
    }

    public static boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Integer[] parseIntegerNumbers(String str) {
        if (str == null) {
            return new Integer[0];
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            if (builder.length() <= 0) continue;
            result.add(Integer.valueOf(builder.toString()));
            builder.setLength(0);
        }
        if (builder.length() > 0) {
            result.add(Integer.valueOf(builder.toString()));
        }
        return result.toArray(new Integer[0]);
    }

    public static Timestamp parseDate(String noHasZoneAnyDateString) {
        if (noHasZoneAnyDateString == null || noHasZoneAnyDateString.isEmpty()) {
            return null;
        }
        int shotTimestampLength = 10;
        int longTimestampLength = 13;
        if ((noHasZoneAnyDateString.length() == shotTimestampLength || noHasZoneAnyDateString.length() == longTimestampLength) && TypeUtil.isNumeric(noHasZoneAnyDateString)) {
            long timestamp = Long.parseLong(noHasZoneAnyDateString);
            if (noHasZoneAnyDateString.length() == shotTimestampLength) {
                timestamp *= 1000L;
            }
            return new Timestamp(timestamp);
        }
        if ("null".equals(noHasZoneAnyDateString)) {
            return null;
        }
        if ("NULL".equals(noHasZoneAnyDateString)) {
            return null;
        }
        Integer[] numbers = TypeUtil.parseIntegerNumbers(noHasZoneAnyDateString);
        if (numbers.length == 0) {
            return null;
        }
        if (numbers[0] > 2999 || numbers[0] < 1900) {
            return null;
        }
        if (numbers.length >= 2 && (numbers[1] > 12 || numbers[1] <= 0)) {
            return null;
        }
        if (numbers.length >= 3 && (numbers[2] > 31 || numbers[2] <= 0)) {
            return null;
        }
        if (numbers.length >= 4 && (numbers[3] > 24 || numbers[3] < 0)) {
            return null;
        }
        if (numbers.length >= 5 && (numbers[4] >= 60 || numbers[4] < 0)) {
            return null;
        }
        if (numbers.length >= 6 && (numbers[5] >= 60 || numbers[5] < 0)) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (numbers.length == 1) {
                calendar.set(1, numbers[0]);
            } else if (numbers.length == 2) {
                calendar.set(1, numbers[0]);
                if (noHasZoneAnyDateString.contains("Q") && (noHasZoneAnyDateString.contains("Q1") || noHasZoneAnyDateString.contains("Q2") || noHasZoneAnyDateString.contains("Q3") || noHasZoneAnyDateString.contains("Q4"))) {
                    calendar.set(2, (numbers[1] - 1) * 3);
                } else {
                    calendar.set(2, numbers[1] - 1);
                }
            } else if (numbers.length == 3) {
                calendar.set(1, numbers[0]);
                calendar.set(2, numbers[1] - 1);
                calendar.set(5, numbers[2]);
            } else if (numbers.length == 4) {
                calendar.set(1, numbers[0]);
                calendar.set(2, numbers[1] - 1);
                calendar.set(5, numbers[2]);
                calendar.set(11, numbers[3]);
            } else if (numbers.length == 5) {
                calendar.set(1, numbers[0]);
                calendar.set(2, numbers[1] - 1);
                calendar.set(5, numbers[2]);
                calendar.set(11, numbers[3]);
                calendar.set(12, numbers[4]);
            } else {
                calendar.set(1, numbers[0]);
                calendar.set(2, numbers[1] - 1);
                calendar.set(5, numbers[2]);
                calendar.set(11, numbers[3]);
                calendar.set(12, numbers[4]);
                calendar.set(13, numbers[5]);
            }
            return new Timestamp(calendar.getTimeInMillis());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date castToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            return new Date(longValue);
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            Timestamp date = TypeUtil.parseDate(strVal);
            if (date != null) {
                return new Date(((java.util.Date)date).getTime());
            }
        }
        throw new IllegalArgumentException("can not cast to Date, value : " + value);
    }

    public static Timestamp castToTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            return new Timestamp(longValue);
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            Timestamp date = TypeUtil.parseDate(strVal);
            if (date != null) {
                return date;
            }
        }
        throw new IllegalArgumentException("can not cast to Timestamp, value : " + value);
    }

    public static Long castToLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            try {
                return Long.parseLong(strVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            try {
                return Integer.parseInt(strVal);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new IllegalArgumentException("can not cast to int, value : " + value);
    }

    public static byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        throw new IllegalArgumentException("can not cast to int, value : " + value);
    }

    public static Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if ("true".equalsIgnoreCase(strVal) || "1".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(strVal) || "0".equals(strVal)) {
                return Boolean.FALSE;
            }
            if ("Y".equalsIgnoreCase(strVal) || "T".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("F".equalsIgnoreCase(strVal) || "N".equals(strVal)) {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException("can not cast to boolean, value : " + value);
    }

    public static <T> T cast(Object obj, Class<T> clazz) {
        if (obj == null) {
            if (clazz == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (clazz == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (clazz == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (clazz == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (clazz == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            if (clazz == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (clazz == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz.isArray()) {
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                int index = 0;
                Object array = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object item : collection) {
                    Object value = TypeUtil.cast(item, clazz.getComponentType());
                    Array.set(array, index, value);
                    ++index;
                }
                return (T)array;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtil.castToBytes(obj);
            }
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtil.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtil.castToByte(obj);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return (T)TypeUtil.castToChar(obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtil.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtil.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtil.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtil.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtil.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtil.castToString(obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtil.castToBigDecimal(obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtil.castToBigInteger(obj);
        }
        if (clazz == java.util.Date.class) {
            return (T)TypeUtil.castToDate(obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtil.castToSqlDate(obj);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtil.castToTimestamp(obj);
        }
        if (clazz.isEnum()) {
            return TypeUtil.castToEnum(obj, clazz);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            java.util.Date date = TypeUtil.castToDate(obj);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance();
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("can not cast to : " + clazz.getName(), e);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        if (obj instanceof String) {
            String strVal = (String)obj;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (clazz == Currency.class) {
                return (T)Currency.getInstance(strVal);
            }
            if (clazz == Locale.class) {
                return (T)TypeUtil.toLocale(strVal);
            }
        }
        throw new IllegalArgumentException("can not cast to : " + clazz.getName());
    }

    public static Locale toLocale(String strVal) {
        String[] items = strVal.split("_");
        if (items.length == 1) {
            return new Locale(items[0]);
        }
        if (items.length == 2) {
            return new Locale(items[0], items[1]);
        }
        return new Locale(items[0], items[1], items[2]);
    }

    public static <T> T castToEnum(Object obj, Class<T> clazz) {
        try {
            T[] values;
            int ordinal;
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() == 0) {
                    return null;
                }
                char charAt0 = name.charAt(0);
                if (charAt0 >= '0' && charAt0 <= '9') {
                    obj = Integer.valueOf(name);
                } else {
                    return Enum.valueOf(clazz, name);
                }
            }
            if (obj instanceof Number && (ordinal = ((Number)obj).intValue()) < (values = clazz.getEnumConstants()).length) {
                return values[ordinal];
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("can not cast to : " + clazz.getName(), ex);
        }
        throw new IllegalArgumentException("can not cast to : " + clazz.getName());
    }

    public static <T> T cast(Object obj, Type type) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtil.cast(obj, (Class)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtil.cast(obj, (ParameterizedType)type);
        }
        if (obj instanceof String && ((strVal = (String)obj).length() == 0 || "null".equals(strVal) || "NULL".equals(strVal))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new IllegalArgumentException("can not cast to : " + type);
    }

    public static <T> T cast(Object obj, ParameterizedType type) {
        Type argType;
        String strVal;
        Type rawTye = type.getRawType();
        if (rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == List.class || rawTye == ArrayList.class) {
            Type itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                AbstractCollection collection = rawTye == Set.class || rawTye == HashSet.class ? new HashSet() : (rawTye == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object item : (Iterable)obj) {
                    collection.add(TypeUtil.cast(item, itemType));
                }
                return (T)collection;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtil.cast(entry.getKey(), keyType);
                    T value = TypeUtil.cast(entry.getValue(), valueType);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtil.cast(obj, rawTye);
        }
        throw new IllegalArgumentException("can not cast to : " + type);
    }

    public static class TypeResult {
        private final Class<?> clazz;
        private final int index;
        private int dimension;

        public TypeResult(Class<?> clazz, int index, int dimension) {
            this.clazz = clazz;
            this.index = index;
            this.dimension = dimension;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int getIndex() {
            return this.index;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void incrementDimension(int inc) {
            this.dimension += inc;
        }
    }
}

