/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.core.ProtocolHandler;
import com.github.netty.core.TcpChannel;
import com.github.netty.core.util.BytesMetricsChannelHandler;
import com.github.netty.core.util.MessageMetricsChannelHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class DynamicProtocolChannelHandler
extends AbstractChannelHandler<ByteBuf, Object> {
    public static final AttributeKey<TcpChannel> ATTR_KEY_TCP_CHANNEL = AttributeKey.valueOf((String)(TcpChannel.class + "#Dy"));
    private Collection<ProtocolHandler> protocolHandlers;
    private MessageMetricsChannelHandler messageMetricsChannelHandler;
    private BytesMetricsChannelHandler bytesMetricsChannelHandler;
    private LoggingHandler loggingHandler;
    private int maxConnections = 10000;
    private long firstClientPacketReadTimeoutMs = 1000L;

    public DynamicProtocolChannelHandler() {
        super(false);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        Channel channel = ctx.channel();
        ChannelId id = channel.id();
        ctx.executor().schedule(() -> {
            TcpChannel tcpChannel = this.getTcpChannel(id);
            if (tcpChannel == null || tcpChannel.getProtocol() == null && tcpChannel.isActive()) {
                this.onProtocolBindTimeout(ctx);
            }
        }, this.firstClientPacketReadTimeoutMs, TimeUnit.MILLISECONDS);
        channel.pipeline().addLast("tcpChannel", (ChannelHandler)new ChannelDuplexHandler(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                DynamicProtocolChannelHandler.this.removeTcpChannel(ctx.channel().id());
            }
        });
        if (this.bytesMetricsChannelHandler != null) {
            channel.pipeline().addFirst("bytemetrics", (ChannelHandler)this.bytesMetricsChannelHandler);
        }
        if (this.messageMetricsChannelHandler != null) {
            channel.pipeline().addLast("metrics", (ChannelHandler)this.messageMetricsChannelHandler);
        }
        if (this.loggingHandler != null) {
            channel.pipeline().addLast("logger", (ChannelHandler)this.loggingHandler);
        }
    }

    @Override
    protected void onMessageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        Channel channel = ctx.channel();
        channel.pipeline().remove((ChannelHandler)this);
        ProtocolHandler protocolHandler = this.getProtocolHandler(msg);
        if (protocolHandler == null) {
            this.addTcpChannel(channel.id(), new TcpChannel(channel, null, (ChannelHandler)this));
            this.onNoSupportProtocol(ctx, msg);
            return;
        }
        if (this.getTcpChannelCount() >= this.getMaxConnections()) {
            TcpChannel tcpChannel = new TcpChannel(channel, protocolHandler, (ChannelHandler)this);
            this.addTcpChannel(channel.id(), tcpChannel);
            this.onOutOfMaxConnection(ctx, msg, tcpChannel);
            return;
        }
        this.addPipeline(ctx, protocolHandler);
        if (channel.isActive()) {
            channel.pipeline().fireChannelRead((Object)msg);
        }
    }

    protected void addPipeline(ChannelHandlerContext ctx, ProtocolHandler protocolHandler) throws Exception {
        Channel channel = ctx.channel();
        this.logger.debug("{} protocol bind to [{}]", (Object)channel, (Object)protocolHandler.getProtocolName());
        this.addTcpChannel(channel.id(), new TcpChannel(channel, protocolHandler, (ChannelHandler)this));
        protocolHandler.addPipeline(channel);
        if (channel.isRegistered()) {
            channel.pipeline().fireChannelRegistered();
        }
        if (channel.isActive()) {
            channel.pipeline().fireChannelActive();
        }
    }

    public ProtocolHandler getProtocolHandler(ByteBuf msg) {
        for (ProtocolHandler protocolHandler : this.protocolHandlers) {
            if (!protocolHandler.canSupport(msg)) continue;
            return protocolHandler;
        }
        return null;
    }

    public ProtocolHandler getProtocolHandler(Channel channel) {
        for (ProtocolHandler protocolHandler : this.protocolHandlers) {
            if (!protocolHandler.canSupport(channel)) continue;
            return protocolHandler;
        }
        return null;
    }

    protected void onOutOfMaxConnection(ChannelHandlerContext ctx, ByteBuf msg, TcpChannel tcpChannel) {
        ctx.close();
        if (msg != null && msg.refCnt() > 0) {
            msg.release();
        }
    }

    protected void onProtocolBindTimeout(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        channel.pipeline().remove((ChannelHandler)this);
        ProtocolHandler protocolHandler = this.getProtocolHandler(channel);
        if (protocolHandler == null) {
            this.addTcpChannel(channel.id(), new TcpChannel(channel, null, (ChannelHandler)this));
            this.onNoSupportProtocol(ctx, null);
            return;
        }
        if (this.getTcpChannelCount() >= this.getMaxConnections()) {
            TcpChannel tcpChannel = new TcpChannel(channel, protocolHandler, (ChannelHandler)this);
            this.addTcpChannel(channel.id(), tcpChannel);
            this.onOutOfMaxConnection(ctx, null, tcpChannel);
            return;
        }
        try {
            this.addPipeline(ctx, protocolHandler);
        }
        catch (Exception e) {
            ctx.fireExceptionCaught((Throwable)e);
        }
    }

    protected void onNoSupportProtocol(ChannelHandlerContext ctx, ByteBuf msg) {
        if (msg != null) {
            this.logger.warn("Received no support protocol. message=[{}]", (Object)msg.toString(Charset.forName("UTF-8")));
            if (msg.refCnt() > 0) {
                msg.release();
            }
        }
        ctx.close();
    }

    public TcpChannel getTcpChannel(ChannelId id) {
        return TcpChannel.getChannels().get(id);
    }

    public void addTcpChannel(ChannelId id, TcpChannel tcpChannel) {
        tcpChannel.attr(ATTR_KEY_TCP_CHANNEL).set((Object)tcpChannel);
        TcpChannel.getChannels().put(id, tcpChannel);
    }

    public void removeTcpChannel(ChannelId id) {
        TcpChannel tcpChannel = TcpChannel.getChannels().remove(id);
        if (tcpChannel != null) {
            tcpChannel.attr(ATTR_KEY_TCP_CHANNEL).set(null);
        }
    }

    public int getTcpChannelCount() {
        return TcpChannel.getChannels().size();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Failed to initialize a channel. Closing: " + ctx.channel(), cause);
        ctx.close();
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setProtocolHandlers(Collection<ProtocolHandler> protocolHandlers) {
        this.protocolHandlers = protocolHandlers;
    }

    public long getFirstClientPacketReadTimeoutMs() {
        return this.firstClientPacketReadTimeoutMs;
    }

    public void setFirstClientPacketReadTimeoutMs(long firstClientPacketReadTimeoutMs) {
        this.firstClientPacketReadTimeoutMs = firstClientPacketReadTimeoutMs;
    }

    public void enableTcpPackageLog(LogLevel logLevel) {
        this.loggingHandler = new LoggingHandler(((Object)((Object)this)).getClass(), logLevel);
        this.messageMetricsChannelHandler = new MessageMetricsChannelHandler();
        this.bytesMetricsChannelHandler = new BytesMetricsChannelHandler();
    }
}

