/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol;

import com.github.netty.core.AbstractNettyServer;
import com.github.netty.core.AbstractProtocol;
import com.github.netty.core.DispatcherChannelHandler;
import com.github.netty.core.util.ChunkedWriteHandler;
import com.github.netty.core.util.IOUtil;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.NettyThreadPoolExecutor;
import com.github.netty.protocol.servlet.NettyMessageToServletRunnable;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletEventListenerManager;
import com.github.netty.protocol.servlet.ServletFilterRegistration;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletRegistration;
import com.github.netty.protocol.servlet.util.HttpAbortPolicyWithReport;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;

public class HttpServletProtocol
extends AbstractProtocol {
    private static final LoggerX LOGGER = LoggerFactoryX.getLogger(HttpServletProtocol.class);
    private final ServletContext servletContext;
    private SslContext sslContext;
    private SslContextBuilder sslContextBuilder;
    private DispatcherChannelHandler servletHandler;
    private long maxContentLength = 0x1400000L;
    private int maxInitialLineLength = 40960;
    private int maxHeaderSize = 81920;
    private int maxChunkSize = 0x500000;
    private boolean enableContentCompression = false;
    private int contentSizeThreshold = 8102;
    private String[] compressionMimeTypes = new String[]{"text/html", "text/xml", "text/plain", "text/css", "text/javascript", "application/javascript", "application/json", "application/xml"};
    private String[] compressionExcludedUserAgents = new String[0];
    private boolean onServerStart = false;

    public HttpServletProtocol(ServletContext servletContext) {
        this(servletContext, null, null);
    }

    public HttpServletProtocol(ServletContext servletContext, Supplier<Executor> executorSupplier, Supplier<Executor> defaultExecutorSupplier) {
        this.servletContext = servletContext;
        if (defaultExecutorSupplier == null) {
            defaultExecutorSupplier = new LazyPool("NettyX-http");
        }
        servletContext.setAsyncExecutorSupplier(executorSupplier);
        servletContext.setDefaultExecutorSupplier(defaultExecutorSupplier);
        this.servletHandler = new DispatcherChannelHandler(executorSupplier);
    }

    @Override
    public <T extends AbstractNettyServer> void onServerStart(T server) throws Exception {
        this.servletContext.setServerAddress(server.getServerAddress());
        this.configurableServletContext();
        ServletEventListenerManager listenerManager = this.servletContext.getServletEventListenerManager();
        if (listenerManager.hasServletContextListener()) {
            listenerManager.onServletContextInitialized(new ServletContextEvent((javax.servlet.ServletContext)this.servletContext));
        }
        this.initFilter(this.servletContext);
        listenerManager.onServletDefaultInitializer(this.servletContext.getDefaultServlet(), this.servletContext);
        listenerManager.onServletContainerInitializerStartup(Collections.emptySet(), this.servletContext);
        this.onServerStart = true;
    }

    @Override
    public <T extends AbstractNettyServer> void onServerStop(T server) {
        ServletEventListenerManager listenerManager = this.servletContext.getServletEventListenerManager();
        if (listenerManager.hasServletContextListener()) {
            listenerManager.onServletContextDestroyed(new ServletContextEvent((javax.servlet.ServletContext)this.servletContext));
        }
        this.destroyFilter();
        this.destroyServlet();
    }

    protected void configurableServletContext() throws Exception {
        if (this.servletContext.getResourceManager() == null) {
            this.servletContext.setDocBase(HttpServletProtocol.createTempDir("netty-docbase").getAbsolutePath());
        }
    }

    static File createTempDir(String prefix) {
        try {
            File tempDir = File.createTempFile(prefix + ".", "");
            tempDir.delete();
            tempDir.mkdir();
            tempDir.deleteOnExit();
            return tempDir;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), ex);
        }
    }

    protected void initFilter(ServletContext servletContext) throws ServletException {
        Map<String, ServletFilterRegistration> servletFilterRegistrationMap = servletContext.getFilterRegistrations();
        for (ServletFilterRegistration registration : servletFilterRegistrationMap.values()) {
            if (!registration.isInitFilterCas(false, true)) continue;
            registration.getFilter().init(registration.getFilterConfig());
        }
    }

    protected void destroyFilter() {
        Map<String, ServletFilterRegistration> servletRegistrationMap = this.servletContext.getFilterRegistrations();
        for (ServletFilterRegistration registration : servletRegistrationMap.values()) {
            Filter filter = registration.getFilter();
            if (filter == null || !registration.isInitFilter()) continue;
            try {
                filter.destroy();
            }
            catch (Exception e) {
                LOGGER.error("destroyFilter error={},filter={}", e.toString(), filter, e);
            }
        }
    }

    protected void destroyServlet() {
        Map<String, ServletRegistration> servletRegistrationMap = this.servletContext.getServletRegistrations();
        for (ServletRegistration registration : servletRegistrationMap.values()) {
            Servlet servlet = registration.getServlet();
            if (servlet == null || !registration.isInitServlet()) continue;
            try {
                servlet.destroy();
            }
            catch (Exception e) {
                LOGGER.error("destroyServlet error={},servlet={}", e.toString(), servlet, e);
            }
        }
        Servlet defaultServlet = this.servletContext.getDefaultServlet();
        if (this.onServerStart && defaultServlet != null) {
            try {
                defaultServlet.destroy();
            }
            catch (Exception e) {
                LOGGER.error("destroyServlet error={},servlet={}", e.toString(), defaultServlet, e);
            }
        }
    }

    @Override
    public boolean canSupport(ByteBuf msg) {
        int protocolEndIndex = IOUtil.indexOf(msg, (byte)10);
        if (protocolEndIndex == -1 && msg.readableBytes() > 7) {
            if (msg.getByte(0) == 71 && msg.getByte(1) == 69 && msg.getByte(2) == 84 && msg.getByte(3) == 32 && msg.getByte(4) == 47) {
                return true;
            }
            if (msg.getByte(0) == 80 && msg.getByte(1) == 79 && msg.getByte(2) == 83 && msg.getByte(3) == 84 && msg.getByte(4) == 32 && msg.getByte(5) == 47) {
                return true;
            }
            if (msg.getByte(0) == 80 && msg.getByte(1) == 85 && msg.getByte(2) == 84 && msg.getByte(3) == 32 && msg.getByte(4) == 47) {
                return true;
            }
            if (msg.getByte(0) == 68 && msg.getByte(1) == 69 && msg.getByte(2) == 76 && msg.getByte(3) == 69 && msg.getByte(4) == 84 && msg.getByte(5) == 69 && msg.getByte(6) == 32 && msg.getByte(7) == 47) {
                return true;
            }
            return msg.getByte(0) == 80 && msg.getByte(1) == 65 && msg.getByte(2) == 84 && msg.getByte(3) == 67 && msg.getByte(4) == 72 && msg.getByte(5) == 32 && msg.getByte(6) == 47;
        }
        if (protocolEndIndex < 9) {
            return false;
        }
        return msg.getByte(protocolEndIndex - 9) == 72 && msg.getByte(protocolEndIndex - 8) == 84 && msg.getByte(protocolEndIndex - 7) == 84 && msg.getByte(protocolEndIndex - 6) == 80;
    }

    @Override
    public void addPipeline(Channel ch) throws Exception {
        super.addPipeline(ch);
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslContextBuilder != null) {
            if (this.sslContext == null) {
                this.sslContext = this.sslContextBuilder.build();
            }
            SSLEngine engine = this.sslContext.newEngine(ch.alloc());
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
            pipeline.addLast("SSL", (ChannelHandler)new SslHandler(engine, true));
        }
        pipeline.addLast("ContentDecompressor", (ChannelHandler)new HttpContentDecompressor(false));
        pipeline.addLast("HttpCodec", (ChannelHandler)new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize, false));
        if (this.enableContentCompression) {
            pipeline.addLast("ContentCompressor", (ChannelHandler)new HttpContentCompressor(6, 15, 8, this.contentSizeThreshold){
                private ChannelHandlerContext ctx;

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    this.ctx = ctx;
                    super.handlerAdded(ctx);
                }

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg instanceof ByteBuf) {
                        msg = new DefaultHttpContent((ByteBuf)msg);
                    }
                    super.write(ctx, msg, promise);
                }

                protected HttpContentEncoder.Result beginEncode(HttpResponse response, String acceptEncoding) throws Exception {
                    ServletHttpExchange httpExchange;
                    if (HttpServletProtocol.this.compressionExcludedUserAgents.length > 0 && (httpExchange = ServletHttpExchange.getHttpExchange(this.ctx)) != null) {
                        List values = httpExchange.getRequest().getNettyHeaders().getAll(HttpHeaderConstants.USER_AGENT);
                        String[] stringArray = HttpServletProtocol.this.compressionExcludedUserAgents;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String excludedUserAgent = stringArray[i];
                            for (String value : values) {
                                if (!value.contains(excludedUserAgent)) continue;
                                return null;
                            }
                        }
                    }
                    if (HttpServletProtocol.this.compressionMimeTypes.length > 0) {
                        List values = response.headers().getAll(HttpHeaderConstants.CONTENT_TYPE);
                        for (String mimeType : HttpServletProtocol.this.compressionMimeTypes) {
                            for (String value : values) {
                                if (!value.contains(mimeType)) continue;
                                return super.beginEncode(response, acceptEncoding);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        pipeline.addLast("ChunkedWrite", (ChannelHandler)new ChunkedWriteHandler(this::getMaxBufferBytes));
        pipeline.addLast("Servlet", (ChannelHandler)this.servletHandler);
        DispatcherChannelHandler.setMessageToRunnable(ch, new NettyMessageToServletRunnable(this.servletContext, this.maxContentLength));
    }

    public long getMaxBufferBytes() {
        return this.servletContext.getMaxBufferBytes();
    }

    public void setMaxBufferBytes(int maxBufferBytes) {
        this.servletContext.setMaxBufferBytes(maxBufferBytes);
    }

    public void setExecutor(Supplier<Executor> dispatcherExecutor) {
        this.servletHandler.setDispatcherExecutor(dispatcherExecutor);
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public String getProtocolName() {
        String name = "http";
        if (this.sslContextBuilder != null) {
            name = name.concat("/https");
        }
        return name;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public SslContextBuilder getSslContextBuilder() {
        return this.sslContextBuilder;
    }

    public void setSslContextBuilder(SslContextBuilder sslContextBuilder) {
        this.sslContextBuilder = sslContextBuilder;
    }

    public void setMaxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public void setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public void setMaxChunkSize(long maxChunkSize) {
        this.maxChunkSize = maxChunkSize != (long)((int)maxChunkSize) ? Integer.MAX_VALUE : (int)maxChunkSize;
    }

    public void setCompressionMimeTypes(String[] compressionMimeTypes) {
        this.compressionMimeTypes = compressionMimeTypes == null ? new String[0] : compressionMimeTypes;
    }

    public void setEnableContentCompression(boolean enableContentCompression) {
        this.enableContentCompression = enableContentCompression;
    }

    public void setContentSizeThreshold(int contentSizeThreshold) {
        this.contentSizeThreshold = contentSizeThreshold;
    }

    public void setCompressionExcludedUserAgents(String[] compressionExcludedUserAgents) {
        this.compressionExcludedUserAgents = compressionExcludedUserAgents == null ? new String[0] : compressionExcludedUserAgents;
    }

    static class LazyPool
    implements Supplier<Executor> {
        private volatile NettyThreadPoolExecutor executor;
        private final String poolName;

        LazyPool(String poolName) {
            this.poolName = poolName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NettyThreadPoolExecutor get() {
            if (this.executor == null) {
                LazyPool lazyPool = this;
                synchronized (lazyPool) {
                    if (this.executor == null) {
                        int coreThreads = 2;
                        int maxThreads = 50;
                        int keepAliveSeconds = 180;
                        int priority = 5;
                        boolean daemon = false;
                        HttpAbortPolicyWithReport handler = new HttpAbortPolicyWithReport(this.poolName, System.getProperty("user.home"), "Http Servlet");
                        this.executor = new NettyThreadPoolExecutor(coreThreads, maxThreads, keepAliveSeconds, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.poolName, priority, daemon, handler);
                    }
                }
            }
            return this.executor;
        }
    }
}

