/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol;

import com.github.netty.core.AbstractProtocol;
import com.github.netty.core.SimpleNettyClient;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.mysql.MysqlProxyHandler;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.client.ClientConnectionDecoder;
import com.github.netty.protocol.mysql.client.ClientPacketEncoder;
import com.github.netty.protocol.mysql.client.MysqlFrontendBusinessHandler;
import com.github.netty.protocol.mysql.exception.ProxyException;
import com.github.netty.protocol.mysql.listener.MysqlPacketListener;
import com.github.netty.protocol.mysql.server.MysqlBackendBusinessHandler;
import com.github.netty.protocol.mysql.server.ServerConnectionDecoder;
import com.github.netty.protocol.mysql.server.ServerErrorPacket;
import com.github.netty.protocol.mysql.server.ServerPacketEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public class MysqlProtocol
extends AbstractProtocol {
    protected final LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private InetSocketAddress mysqlAddress;
    private int maxPacketSize = 0xFFFFFF;
    private Supplier<MysqlBackendBusinessHandler> backendBusinessHandler = MysqlBackendBusinessHandler::new;
    private Supplier<MysqlFrontendBusinessHandler> frontendBusinessHandler = MysqlFrontendBusinessHandler::new;
    private final List<MysqlPacketListener> mysqlPacketListeners = new CopyOnWriteArrayList<MysqlPacketListener>();

    public MysqlProtocol() {
    }

    public MysqlProtocol(InetSocketAddress mysqlAddress) {
        this.mysqlAddress = mysqlAddress;
    }

    @Override
    public int getOrder() {
        return 500;
    }

    @Override
    public String getProtocolName() {
        return "mysql";
    }

    @Override
    public boolean canSupport(Channel channel) {
        return true;
    }

    @Override
    public boolean canSupport(ByteBuf msg) {
        return false;
    }

    protected String newSessionId(InetSocketAddress frontendAddress, InetSocketAddress backendAddress) {
        String backendId = backendAddress.getHostString() + "_" + backendAddress.getPort();
        String frontendId = frontendAddress.getHostString() + "_" + frontendAddress.getPort();
        return backendId + "-" + frontendId;
    }

    @Override
    public void addPipeline(Channel frontendChannel) throws Exception {
        Session session = new Session(this.newSessionId((InetSocketAddress)frontendChannel.remoteAddress(), this.mysqlAddress));
        session.setFrontendChannel(frontendChannel);
        SimpleNettyClient mysqlClient = new SimpleNettyClient("Mysql");
        mysqlClient.handlers(() -> {
            MysqlBackendBusinessHandler backendBusinessHandler = this.backendBusinessHandler.get();
            backendBusinessHandler.setMysqlPacketListeners(this.mysqlPacketListeners);
            backendBusinessHandler.setMaxPacketSize(this.maxPacketSize);
            backendBusinessHandler.setSession(session);
            ChannelHandler[] channelHandlerArray = new ChannelHandler[5];
            channelHandlerArray[0] = new MysqlProxyHandler(session::getFrontendChannel);
            channelHandlerArray[1] = new ServerConnectionDecoder(session, this.maxPacketSize);
            channelHandlerArray[2] = new ClientPacketEncoder(session);
            channelHandlerArray[3] = new ServerPacketEncoder(session);
            channelHandlerArray[4] = backendBusinessHandler;
            return channelHandlerArray;
        }).ioRatio(80).ioThreadCount(1).connect(this.mysqlAddress).get().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                session.setBackendChannel(future.channel());
            } else {
                String stackTrace = ProxyException.stackTraceToString(future.cause());
                ServerErrorPacket errorPacket = new ServerErrorPacket(0, 3002, "#HY000".getBytes(), stackTrace);
                frontendChannel.writeAndFlush((Object)errorPacket).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }));
        MysqlFrontendBusinessHandler frontendBusinessHandler = this.frontendBusinessHandler.get();
        frontendBusinessHandler.setMaxPacketSize(this.maxPacketSize);
        frontendBusinessHandler.setSession(session);
        frontendBusinessHandler.setMysqlPacketListeners(this.mysqlPacketListeners);
        frontendChannel.pipeline().addLast(new ChannelHandler[]{new MysqlProxyHandler(this.newBackendChannelSupplier(session)), new ClientConnectionDecoder(session, this.maxPacketSize), new ClientPacketEncoder(session), new ServerPacketEncoder(session), frontendBusinessHandler});
    }

    protected Supplier<Channel> newBackendChannelSupplier(Session session) {
        return () -> {
            Channel backendChannel = session.getBackendChannel();
            if (backendChannel == null) {
                throw new ProxyException(3001, "cannot find a backendChannel");
            }
            return backendChannel;
        };
    }

    public void setMysqlAddress(InetSocketAddress mysqlAddress) {
        this.mysqlAddress = mysqlAddress;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public void setBackendBusinessHandler(Supplier<MysqlBackendBusinessHandler> backendBusinessHandler) {
        this.backendBusinessHandler = backendBusinessHandler;
    }

    public void setFrontendBusinessHandler(Supplier<MysqlFrontendBusinessHandler> frontendBusinessHandler) {
        this.frontendBusinessHandler = frontendBusinessHandler;
    }

    public InetSocketAddress getMysqlAddress() {
        return this.mysqlAddress;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public List<MysqlPacketListener> getMysqlPacketListeners() {
        return this.mysqlPacketListeners;
    }
}

