/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.protocol.mqtt.MqttUtil;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.List;

@ChannelHandler.Sharable
public class MqttLoggerChannelHandler
extends AbstractChannelHandler<MqttMessage, MqttMessage> {
    public MqttLoggerChannelHandler() {
        super(false);
    }

    @Override
    public void onMessageReceived(ChannelHandlerContext ctx, MqttMessage message) throws Exception {
        this.logMQTTMessage(ctx, message, "C->B");
        ctx.fireChannelRead((Object)message);
    }

    @Override
    protected void onMessageWriter(ChannelHandlerContext ctx, MqttMessage msg, ChannelPromise promise) throws Exception {
        this.logMQTTMessage(ctx, msg, "C<-B");
        if (promise.isVoid()) {
            ctx.write((Object)msg, promise);
        } else {
            ctx.write((Object)msg, promise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = MqttUtil.clientID(ctx.channel());
        if (clientID != null && !clientID.isEmpty()) {
            this.logger.debug("Channel closed <{}>", (Object)clientID);
        }
        ctx.fireChannelInactive();
    }

    private void logMQTTMessage(ChannelHandlerContext ctx, MqttMessage msg, String direction) throws Exception {
        if (msg.fixedHeader() == null) {
            throw new IOException("Unknown packet");
        }
        String clientID = MqttUtil.clientID(ctx.channel());
        MqttMessageType messageType = msg.fixedHeader().messageType();
        switch (messageType) {
            case CONNACK: 
            case PINGREQ: 
            case PINGRESP: {
                this.logger.debug("{} {} <{}>", direction, messageType, clientID);
                break;
            }
            case CONNECT: 
            case DISCONNECT: {
                this.logger.debug("{} {} <{}>", direction, messageType, clientID);
                break;
            }
            case SUBSCRIBE: {
                MqttSubscribeMessage subscribe = (MqttSubscribeMessage)msg;
                this.logger.debug("{} SUBSCRIBE <{}> to topics {}", direction, clientID, subscribe.payload().topicSubscriptions());
                break;
            }
            case UNSUBSCRIBE: {
                MqttUnsubscribeMessage unsubscribe = (MqttUnsubscribeMessage)msg;
                this.logger.debug("{} UNSUBSCRIBE <{}> to topics <{}>", direction, clientID, unsubscribe.payload().topics());
                break;
            }
            case PUBLISH: {
                MqttPublishMessage publish = (MqttPublishMessage)msg;
                this.logger.debug("{} PUBLISH <{}> to topics <{}>", direction, clientID, publish.variableHeader().topicName());
                break;
            }
            case PUBREC: 
            case PUBCOMP: 
            case PUBREL: 
            case PUBACK: 
            case UNSUBACK: {
                this.logger.debug("{} {} <{}> packetID <{}>", direction, messageType, clientID, MqttUtil.messageId(msg));
                break;
            }
            case SUBACK: {
                MqttSubAckMessage suback = (MqttSubAckMessage)msg;
                List grantedQoSLevels = suback.payload().grantedQoSLevels();
                this.logger.debug("{} SUBACK <{}> packetID <{}>, grantedQoses {}", direction, clientID, MqttUtil.messageId(msg), grantedQoSLevels);
                break;
            }
        }
    }
}

