/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import java.util.Map;

public final class MqttUtil {
    private static final AttributeKey<Integer> ATTR_KEY_KEEPALIVE = AttributeKey.valueOf((String)(String.class + "#keepAlive"));
    private static final AttributeKey<Boolean> ATTR_KEY_CLEANSESSION = AttributeKey.valueOf((String)(Boolean.class + "#removeTemporaryQoS2"));
    private static final AttributeKey<String> ATTR_KEY_CLIENTID = AttributeKey.valueOf((String)(String.class + "#ClientID"));
    private static final AttributeKey<String> ATTR_KEY_USERNAME = AttributeKey.valueOf((String)(String.class + "#username"));

    public static Object getAttribute(ChannelHandlerContext ctx, AttributeKey<Object> key) {
        Attribute attr = ctx.channel().attr(key);
        return attr.get();
    }

    public static void keepAlive(Channel channel, int keepAlive) {
        channel.attr(ATTR_KEY_KEEPALIVE).set((Object)keepAlive);
    }

    public static void cleanSession(Channel channel, boolean cleanSession) {
        channel.attr(ATTR_KEY_CLEANSESSION).set((Object)cleanSession);
    }

    public static boolean cleanSession(Channel channel) {
        return (Boolean)channel.attr(ATTR_KEY_CLEANSESSION).get();
    }

    public static void clientID(Channel channel, String clientID) {
        channel.attr(ATTR_KEY_CLIENTID).set((Object)clientID);
    }

    public static String clientID(Channel channel) {
        return (String)channel.attr(ATTR_KEY_CLIENTID).get();
    }

    public static void userName(Channel channel, String username) {
        channel.attr(ATTR_KEY_USERNAME).set((Object)username);
    }

    public static String userName(Channel channel) {
        return (String)channel.attr(ATTR_KEY_USERNAME).get();
    }

    public static <T, K> T defaultGet(Map<K, T> map, K key, T defaultValue) {
        T value = map.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static int messageId(MqttMessage msg) {
        return ((MqttMessageIdVariableHeader)msg.variableHeader()).messageId();
    }

    public static byte[] readBytesAndRewind(ByteBuf payload) {
        byte[] payloadContent = new byte[payload.readableBytes()];
        int mark = payload.readerIndex();
        payload.readBytes(payloadContent);
        payload.readerIndex(mark);
        return payloadContent;
    }

    public static String payload2Str(ByteBuf content) {
        byte[] bytesContent;
        ByteBuf copy = content.copy();
        if (copy.isDirect()) {
            int size = copy.readableBytes();
            bytesContent = new byte[size];
            copy.readBytes(bytesContent);
        } else {
            bytesContent = copy.array();
        }
        return new String(bytesContent, Charset.forName("UTF-8"));
    }

    private MqttUtil() {
    }
}

