/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.interception;

import com.github.netty.protocol.mqtt.interception.InterceptMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;

public class InterceptAcknowledgedMessage
implements InterceptMessage {
    private final StoredMessage msg;
    private final String username;
    private final String topic;
    private final int packetID;

    public InterceptAcknowledgedMessage(StoredMessage msg, String topic, String username, int packetID) {
        this.msg = msg;
        this.username = username;
        this.topic = topic;
        this.packetID = packetID;
    }

    public StoredMessage getMsg() {
        return this.msg;
    }

    public String getUsername() {
        return this.username;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPacketID() {
        return this.packetID;
    }

    class StoredMessage
    implements Serializable {
        private static final long serialVersionUID = 1755296138639817304L;
        private MqttQoS m_qos;
        final byte[] m_payload;
        final String m_topic;
        private boolean m_retained;
        private String m_clientID;

        public StoredMessage(byte[] message, MqttQoS qos, String topic) {
            this.m_qos = qos;
            this.m_payload = message;
            this.m_topic = topic;
        }

        public void setQos(MqttQoS qos) {
            this.m_qos = qos;
        }

        public MqttQoS getQos() {
            return this.m_qos;
        }

        public String getTopic() {
            return this.m_topic;
        }

        public String getClientID() {
            return this.m_clientID;
        }

        public void setClientID(String m_clientID) {
            this.m_clientID = m_clientID;
        }

        public ByteBuf getPayload() {
            return Unpooled.copiedBuffer((byte[])this.m_payload);
        }

        public void setRetained(boolean retained) {
            this.m_retained = retained;
        }

        public boolean isRetained() {
            return this.m_retained;
        }

        public String toString() {
            return "PublishEvent{clientID='" + this.m_clientID + '\'' + ", m_retain=" + this.m_retained + ", m_qos=" + this.m_qos + ", m_topic='" + this.m_topic + '\'' + '}';
        }
    }
}

